/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.trafo;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.editor.GraGraEditor;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.gui.options.GraTraMatchOptionGUI;
import agg.gui.options.GraTraOptionGUI;
import agg.gui.trafo.TransformDebug;
import agg.gui.trafo.TransformInterpret;
import agg.gui.trafo.TransformLayered;
import agg.gui.trafo.TransformRuleSequences;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.LayeredGraTraImpl;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.PriorityGraTraImpl;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleSequencesGraTraImpl;
import agg.xt_basis.csp.CompletionPropertyBits;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;

public class GraGraTransform {
    private final GraTraOptionGUI optionGUI;
    private final GraTraMatchOptionGUI generalOptionGUI;
    private MorphCompletionStrategy strategy;
    private final TransformDebug debugger;
    private TransformInterpret interpreterTransform;
    private TransformInterpret rulePriorityTransform;
    private TransformLayered layeredTransform;
    private TransformRuleSequences ruleSequenceTransform;
    private final Vector<TransformEventListener> transformListeners;
    private GraGraEditor editor;
    private int threadpriority;

    public GraGraTransform(GraGraEditor anEditor) {
        this.editor = anEditor;
        this.threadpriority = 7;
        this.generalOptionGUI = new GraTraMatchOptionGUI(this);
        this.optionGUI = new GraTraOptionGUI(this.editor.getParentFrame(), this);
        this.strategy = this.generalOptionGUI.getMorphCompletionStrategy();
        this.debugger = new TransformDebug(this);
        this.debugger.setCompletionStrategy(this.strategy);
        this.editor.addEditEventListener(this.debugger);
        this.transformListeners = new Vector();
    }

    public GraGraEditor getEditor() {
        return this.editor;
    }

    public EdGraGra getGraGra() {
        return this.editor.getGraGra();
    }

    public Vector<EdRule> getCurrentRuleSet() {
        if (this.editor.getGraGra() != null) {
            return this.editor.getGraGra().getEnabledRules();
        }
        return new Vector<EdRule>(0);
    }

    public GraTraOptionGUI getOptionGUI() {
        return this.optionGUI;
    }

    public GraTraMatchOptionGUI getGeneralOptionGUI() {
        return this.generalOptionGUI;
    }

    public MorphCompletionStrategy getStrategy() {
        return this.strategy;
    }

    public void setEachRuleToApplyOfRuleSequence(boolean b) {
        if (this.ruleSequenceTransform != null) {
            this.ruleSequenceTransform.setEachRuleToApplyOfRuleSequence(b);
        }
    }

    public void setRuleSequences(List<EdRule> rules, List<Pair<List<Pair<String, String>>, String>> sequences) {
        this.optionGUI.setRulesOfRuleSequenceGUI(rules);
        this.optionGUI.setRuleSequences(sequences);
        this.optionGUI.enableRuleSequenceGUI(this.optionGUI.ruleSequenceEnabled());
    }

    public void resetCurrentRuleSequences() {
        if (this.editor.getGraGra() != null) {
            this.optionGUI.setRulesOfRuleSequenceGUI(this.editor.getGraGra().getEnabledRules());
            this.optionGUI.setRuleSequences(this.editor.getGraGra().getRuleSequenceList());
            this.optionGUI.enableRuleSequenceGUI(this.optionGUI.ruleSequenceEnabled());
        }
    }

    public void setRuleSequences(List<Pair<List<Pair<String, String>>, String>> sequences) {
        this.optionGUI.setRuleSequences(sequences);
        this.optionGUI.enableRuleSequenceGUI(this.optionGUI.ruleSequenceEnabled());
    }

    public List<Pair<List<Pair<String, String>>, String>> getRuleSequences() {
        if (this.optionGUI.ruleSequenceEnabled()) {
            return this.optionGUI.getRuleSequences();
        }
        return null;
    }

    public String getRuleSequencesAsText() {
        if (this.optionGUI.ruleSequenceEnabled()) {
            return this.optionGUI.getRuleSequencesAsText();
        }
        return null;
    }

    public boolean nondeterministicallyEnabled() {
        return this.optionGUI.nondeterministicallyEnabled();
    }

    public boolean priorityEnabled() {
        return this.optionGUI.priorityEnabled();
    }

    public boolean layeredEnabled() {
        return this.optionGUI.layeredEnabled();
    }

    public boolean ruleSequenceEnabled() {
        return this.optionGUI.ruleSequenceEnabled();
    }

    public boolean consistencyEnabled() {
        return this.generalOptionGUI.consistencyEnabled();
    }

    public boolean consistencyCheckAfterGraphTrafoEnabled() {
        return this.generalOptionGUI.consistencyCheckAfterGraphTrafoEnabled();
    }

    public boolean showLayerEnabled() {
        return this.optionGUI.showLayerEnabled();
    }

    public boolean stopLayerAndWaitEnabled() {
        return this.optionGUI.stopLayerAndWaitEnabled();
    }

    public boolean breakLayerEnabled() {
        return this.optionGUI.breakLayerEnabled();
    }

    public boolean breakAllLayerEnabled() {
        return this.optionGUI.breakAllLayerEnabled();
    }

    public boolean showGraphAfterStepEnabled() {
        return this.generalOptionGUI.showGraphAfterStepEnabled();
    }

    public boolean waitAfterStepEnabled() {
        return this.generalOptionGUI.waitAfterStepEnabled();
    }

    public boolean checkRuleApplicabilityEnabled() {
        return this.generalOptionGUI.checkRuleApplicabilityEnabled();
    }

    public boolean selectMatchObjectsEnabled() {
        return this.generalOptionGUI.selectMatchObjectsEnabled();
    }

    public boolean selectNewAfterStepEnabled() {
        return this.generalOptionGUI.selectNewAfterStepEnabled();
    }

    public boolean layeredLoopEnabled() {
        return this.optionGUI.layeredLoopEnabled();
    }

    public boolean resetGraphEnabled() {
        return this.optionGUI.resetGraphEnabled();
    }

    public int getLayerToStop() {
        return this.optionGUI.getLayerToStop();
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
        this.debugger.setCompletionStrategy(strat);
        if (this.debugger.getMatch() != null) {
            this.debugger.getMatch().setCompletionStrategy(strat);
        }
        this.editor.getGraGra().getBasisGraGra().setGraTraOptions(strat);
    }

    public Vector<String> getGraTraOptionsList() {
        GraTraOptions gratraOptions = this.getGraTraOptions();
        return gratraOptions.getOptions();
    }

    public GraTraOptions getGraTraOptions() {
        GraTraOptions gratraOptions = new GraTraOptions();
        gratraOptions.addOption(CompletionStrategySelector.getName(this.strategy));
        BitSet activebits = this.strategy.getProperties();
        int i = 0;
        while (i < CompletionPropertyBits.BITNAME.length) {
            if (activebits.get(i)) {
                String bitName = CompletionPropertyBits.BITNAME[i];
                gratraOptions.addOption(bitName);
            }
            ++i;
        }
        if (!this.strategy.isRandomisedDomain()) {
            gratraOptions.addOption("determinedCSPDomain");
        }
        if (this.generalOptionGUI.consistencyEnabled()) {
            gratraOptions.addOption("consistency");
        }
        if (this.generalOptionGUI.consistencyCheckAfterGraphTrafoEnabled()) {
            gratraOptions.addOption("consistencyCheckAfterGraphTrafo");
        }
        if (this.optionGUI.priorityEnabled()) {
            gratraOptions.addOption("priority");
        } else if (this.optionGUI.layeredEnabled()) {
            gratraOptions.addOption("layered");
        } else if (this.optionGUI.ruleSequenceEnabled()) {
            gratraOptions.addOption("ruleSequence");
            if (this.optionGUI.eachRuleToApplyEnabled()) {
                gratraOptions.addOption("eachRuleToApply");
            }
        }
        if (this.optionGUI.stopLayerAndWaitEnabled()) {
            gratraOptions.addOption("stopLayerAndWait");
        }
        if (this.optionGUI.layeredLoopEnabled()) {
            gratraOptions.addOption("layeredLoop");
        }
        if (this.optionGUI.resetGraphEnabled()) {
            gratraOptions.addOption("resetGraph");
        }
        if (this.optionGUI.breakLayerEnabled()) {
            gratraOptions.addOption("breakLayer");
        }
        if (this.optionGUI.breakAllLayerEnabled()) {
            gratraOptions.addOption("breakAllLayer");
        }
        if (this.generalOptionGUI.checkRuleApplicabilityEnabled()) {
            gratraOptions.addOption("checkRuleApplicability");
        }
        if (this.generalOptionGUI.applyParallelEnabled()) {
            gratraOptions.addOption("parallelMatching");
        }
        if (this.generalOptionGUI.showGraphAfterStepEnabled()) {
            gratraOptions.addOption("showGraphAfterStep");
        }
        if (this.generalOptionGUI.waitAfterStepEnabled()) {
            gratraOptions.addOption("waitAfterStep");
        }
        return gratraOptions;
    }

    public void updateGraTraOption(String opt, boolean b) {
        if (this.editor.getGraGra() == null) {
            return;
        }
        if (this.layeredTransform != null && this.layeredTransform.isAlive()) {
            if (opt.equals("layeredLoop") && !b) {
                ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setLayeredLoop(false);
            } else if (opt.equals("breakAllLayer") && b) {
                ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setBreakAllLayer(true);
                this.layeredTransform.stopping();
            }
        } else if (b) {
            this.editor.getGraGra().getBasisGraGra().addGraTraOption(opt);
        } else {
            this.editor.getGraGra().getBasisGraGra().removeGraTraOption(opt);
        }
    }

    public void updateGraTraOptionGUI(Vector<String> optionsList) {
        this.optionGUI.update(optionsList);
        this.optionGUI.updateLayerToStopIfNeeded();
        this.generalOptionGUI.update(optionsList);
    }

    public void setRulesOfGraphRuleSequenceGUI(Vector<EdRule> rules) {
        this.optionGUI.setRulesOfRuleSequenceGUI(rules);
    }

    public void setTransformationThreadPriority(int prior) {
        this.threadpriority = prior;
    }

    public TransformDebug getTransformDebugger() {
        return this.debugger;
    }

    public TransformInterpret createInterpreterTransform() {
        this.interpreterTransform = new TransformInterpret(this);
        return this.interpreterTransform;
    }

    public TransformInterpret getInterpreterTransform() {
        return this.interpreterTransform;
    }

    public TransformInterpret createRulePriorityTransform() {
        this.rulePriorityTransform = new TransformInterpret(this, true);
        return this.rulePriorityTransform;
    }

    public TransformInterpret getRulePriorityTransform() {
        return this.rulePriorityTransform;
    }

    public TransformLayered createRuleLayerTransform() {
        this.layeredTransform = new TransformLayered(this);
        return this.layeredTransform;
    }

    public TransformLayered getRuleLayerTransform() {
        return this.layeredTransform;
    }

    public TransformRuleSequences createRuleSequenceTransform(boolean useApplRuleSequence) {
        this.ruleSequenceTransform = new TransformRuleSequences(this, useApplRuleSequence);
        return this.ruleSequenceTransform;
    }

    public TransformRuleSequences getRuleSequenceTransform() {
        return this.ruleSequenceTransform;
    }

    public void startTransformByRuleSequence(EdGraGra gragra, RuleSequence ruleSequence) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.ruleSequenceTransform);
        this.editor.setInterpreting(false);
        this.editor.setLayering(false);
        this.editor.setTransformRuleSequences(true);
        if (gragra.getBasisGraGra().trafoByApplicableRuleSequence()) {
            gragra.getBasisGraGra().addGraTraOption("waitAfterStep");
            gragra.getBasisGraGra().addGraTraOption("selectNewAfterStep");
        }
        this.ruleSequenceTransform.setGraGra(gragra, ruleSequence);
        this.ruleSequenceTransform.setCompletionStrategy(this.strategy);
        this.ruleSequenceTransform.setPriority(this.threadpriority);
        this.ruleSequenceTransform.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        ((RuleSequencesGraTraImpl)this.ruleSequenceTransform.getGraTra()).setGraTraOptions(this.getGraTraOptions());
        this.fireTransform(new TransformEvent(this.ruleSequenceTransform, 9));
        this.ruleSequenceTransform.start();
    }

    public void stopTransformRuleSequences() {
        this.ruleSequenceTransform.stopping();
        if (this.ruleSequenceTransform.getGraTra().getGraGra().trafoByApplicableRuleSequence()) {
            this.ruleSequenceTransform.getGraTra().getGraGra().removeGraTraOption("waitAfterStep");
            this.ruleSequenceTransform.getGraTra().getGraGra().removeGraTraOption("selectNewAfterStep");
        }
    }

    public void startTransformInterpreter(EdGraGra gragra) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.interpreterTransform);
        this.editor.setInterpreting(true);
        this.editor.setLayering(false);
        this.editor.setTransformRuleSequences(false);
        this.interpreterTransform.setGraGra(gragra);
        this.interpreterTransform.setCompletionStrategy(this.strategy);
        this.interpreterTransform.setPriority(this.threadpriority);
        this.interpreterTransform.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        ((DefaultGraTraImpl)this.interpreterTransform.getGraTra()).setGraTraOptions(this.getGraTraOptions());
        this.fireTransform(new TransformEvent(this.interpreterTransform, 9));
        this.interpreterTransform.start();
    }

    public void stopTransformInterpreter() {
        this.interpreterTransform.stopping();
    }

    public void startRulePriorityTransformInterpreter(EdGraGra gragra) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.rulePriorityTransform);
        this.editor.setInterpreting(true);
        this.editor.setLayering(false);
        this.editor.setTransformRuleSequences(false);
        this.rulePriorityTransform.setGraGra(gragra);
        this.rulePriorityTransform.setCompletionStrategy(this.strategy);
        this.rulePriorityTransform.setPriority(this.threadpriority);
        this.rulePriorityTransform.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        ((PriorityGraTraImpl)this.rulePriorityTransform.getGraTra()).setGraTraOptions(this.getGraTraOptions());
        this.fireTransform(new TransformEvent(this.rulePriorityTransform, 9));
        this.rulePriorityTransform.start();
    }

    public void stopRulePriorityTransformInterpreter() {
        this.rulePriorityTransform.stopping();
    }

    public void startTransformLayered(EdGraGra gragra) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.layeredTransform);
        this.editor.setInterpreting(false);
        this.editor.setLayering(true);
        this.editor.setTransformRuleSequences(false);
        this.layeredTransform.setGraGra(gragra);
        this.layeredTransform.setCompletionStrategy(this.strategy);
        this.layeredTransform.setPriority(this.threadpriority);
        this.layeredTransform.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setStopLayerAndWait(this.stopLayerAndWaitEnabled());
        ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setLayeredLoop(this.layeredLoopEnabled());
        ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setResetGraphBeforeLoop(this.resetGraphEnabled());
        ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setBreakLayer(this.breakLayerEnabled());
        ((LayeredGraTraImpl)this.layeredTransform.getGraTra()).setBreakAllLayer(this.breakAllLayerEnabled());
        this.fireTransform(new TransformEvent(this.layeredTransform, 9));
        this.layeredTransform.start();
    }

    public void stopTransformLayered() {
        this.layeredTransform.stopping();
    }

    public void changeFromTransformLayeredToTransformInterpreter() {
        this.stopTransformLayered();
        this.editor.startInterpreterTransform();
    }

    public Vector<Rule> getApplicableRules(EdGraGra gragra) {
        return this.debugger.getApplicableRules(gragra);
    }

    public Vector<EdRule> getApplicableRules(EdGraGra gragra, boolean applicable) {
        return this.debugger.getApplicableRules(gragra, applicable);
    }

    public void matchDef(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.matchDef();
    }

    public void destroyMatch() {
        this.debugger.destroyMatch();
    }

    public void nextCompletion(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.nextCompletion();
    }

    public void step(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.step();
    }

    public void unsetTransformDebug() {
        this.debugger.dispose();
    }

    public synchronized void addTransformEventListener(TransformEventListener l) {
        if (!this.transformListeners.contains(l)) {
            this.transformListeners.addElement(l);
        }
    }

    public synchronized void removeTransformEventListener(TransformEventListener l) {
        if (this.transformListeners.contains(l)) {
            this.transformListeners.removeElement(l);
        }
    }

    public void fireTransform(TransformEvent e) {
        int i = 0;
        while (i < this.transformListeners.size()) {
            this.transformListeners.get(i).transformEventOccurred(e);
            ++i;
        }
    }
}

