/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ItemImportDialog
extends JDialog
implements ActionListener {
    private final JPanel contentPane;
    private final JPanel panel;
    private final JPanel itemPanel;
    private final JPanel buttonPanel;
    private final JScrollPane scrollPane;
    private final Vector<String> itemNames;
    private final Vector<String> result;
    private final Vector<JCheckBox> checkBox;
    private final JButton allItemsButton;
    private final JButton closeButton;
    private final JButton cancelButton;

    public ItemImportDialog(JFrame parent, String title, Vector<String> itemNames) {
        super((Frame)parent, true);
        this.itemNames = itemNames;
        this.result = new Vector();
        this.setTitle(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ItemImportDialog.this.setVisible(false);
                ItemImportDialog.this.dispose();
            }
        });
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.checkBox = new Vector();
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new TitledBorder(" Please select items "));
        this.itemPanel = new JPanel(new GridLayout(itemNames.size(), 1));
        int i = 0;
        while (i < itemNames.size()) {
            String name = itemNames.get(i);
            JCheckBox cb = new JCheckBox(name, null, false);
            cb.addActionListener(this);
            this.checkBox.addElement(cb);
            this.itemPanel.add(cb);
            ++i;
        }
        this.scrollPane = new JScrollPane(this.itemPanel);
        this.scrollPane.setPreferredSize(new Dimension(100, 150));
        this.allItemsButton = new JButton();
        this.allItemsButton.setActionCommand("allItems");
        this.allItemsButton.setText("Select All");
        this.allItemsButton.addActionListener(this);
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.add((Component)this.allItemsButton, "South");
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Import");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(this.buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 10, 10, 5);
        this.constrainBuild(this.buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 10);
        this.contentPane.add((Component)this.panel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.allItemsButton) {
            int j = 0;
            while (j < this.checkBox.size()) {
                JCheckBox cb = this.checkBox.elementAt(j);
                cb.setSelected(true);
                ++j;
            }
        } else if (source == this.closeButton) {
            int j = 0;
            while (j < this.checkBox.size()) {
                JCheckBox cb = this.checkBox.elementAt(j);
                if (cb.isSelected()) {
                    this.result.addElement(this.itemNames.elementAt(j));
                }
                ++j;
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public Vector<String> getSelectedItemNames() {
        return this.result;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

