/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdGraGra;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;

public class GrammarTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdGraGra eGra;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public GrammarTreeNodeData(EdGraGra gra) {
        this.setGrammar(gra);
    }

    public GrammarTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public GrammarTreeNodeData(Object obj) {
        this.data = obj;
        if (obj instanceof EdGraGra) {
            new GrammarTreeNodeData((EdGraGra)obj);
        } else if (obj instanceof String) {
            new GrammarTreeNodeData((String)obj);
        }
    }

    private void setGrammar(EdGraGra gra) {
        this.data = gra;
        this.string = gra.getName();
        this.eGra = gra;
    }

    @Override
    public void dispose() {
        this.data = null;
        this.string = null;
        this.eGra = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdGraGra) {
            this.setGrammar((EdGraGra)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.eGra = null;
        } else {
            this.string = null;
            this.eGra = null;
            this.data = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        if (!this.eGra.getName().equals(newString)) {
            this.eGra.setName(newString);
            this.eGra.setChanged(true);
        }
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdGraGra getGraGra() {
        return this.eGra;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isGraGra() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = "";
        if (!this.eGra.getFileName().equals("")) {
            toolTipText = this.eGra.getDirName().indexOf(File.separator) != -1 ? "( " + this.eGra.getDirName() + this.eGra.getFileName() + " )" : "( " + this.eGra.getDirName() + File.separator + this.eGra.getFileName() + " )";
            if (!this.eGra.getBasisGraGra().getTextualComment().equals("")) {
                toolTipText = String.valueOf(toolTipText) + "  " + this.eGra.getBasisGraGra().getTextualComment();
            }
        } else {
            toolTipText = " Graph grammar ";
            if (!this.eGra.getBasisGraGra().getTextualComment().equals("")) {
                toolTipText = " " + this.eGra.getBasisGraGra().getTextualComment();
            }
        }
        return toolTipText;
    }
}

