/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.ExtendedLayerFunction;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.LayeredExcludeParser;
import agg.parser.LayeredSimpleExcludeParser;
import agg.parser.LayeredSimpleParser;
import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserOption;
import agg.parser.PriorityDependencyPairContainer;
import agg.parser.PriorityExcludePairContainer;
import agg.parser.SimpleExcludeParser;
import agg.parser.SimpleParser;
import agg.parser.WeakExtendedLayerFunction;
import agg.parser.WeakLayerFunction;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.RuleLayer;

public class ParserFactory {
    private ParserFactory() {
    }

    public static Parser createParser(GraGra grammar, Graph hostGraph, Graph stopGraph, PairContainer pairs, ParserOption option, LayerFunction layer) {
        AbstractParser p = null;
        if (option != null && grammar != null && hostGraph != null && stopGraph != null) {
            switch (option.getSelectedParser()) {
                case 0: {
                    if (option.layerEnabled()) {
                        p = new LayeredSimpleParser(grammar, hostGraph, stopGraph, layer);
                        break;
                    }
                    p = new SimpleParser(grammar, hostGraph, stopGraph);
                    break;
                }
                case 1: {
                    if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                    if (option.layerEnabled()) {
                        p = new LayeredExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                        break;
                    }
                    p = new ExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                    break;
                }
                case 2: {
                    if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                    if (option.layerEnabled()) {
                        p = new LayeredSimpleExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                        break;
                    }
                    p = new SimpleExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                    break;
                }
            }
        }
        return p;
    }

    public static Parser createParser(GraGra grammar, Graph hostGraph, Graph stopGraph, PairContainer pairs, ParserOption option, RuleLayer layer) {
        if (option == null || grammar == null || hostGraph == null || stopGraph == null) {
            return null;
        }
        AbstractParser p = null;
        switch (option.getSelectedParser()) {
            case 0: {
                if (option.layerEnabled()) {
                    p = new LayeredSimpleParser(grammar, hostGraph, stopGraph, layer);
                    break;
                }
                p = new SimpleParser(grammar, hostGraph, stopGraph);
                break;
            }
            case 1: {
                if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                if (option.layerEnabled()) {
                    p = new LayeredExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                    break;
                }
                p = new ExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                break;
            }
            case 2: {
                if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                if (option.layerEnabled()) {
                    p = new LayeredSimpleExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                    break;
                }
                p = new SimpleExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                break;
            }
        }
        return p;
    }

    public static PairContainer createEmptyCriticalPairs(GraGra grammar, LayerFunction layerFunc, CriticalPairOption option) {
        ExcludePairContainer pc = null;
        if (option != null && grammar != null) {
            switch (option.getCriticalPairAlgorithm()) {
                case 0: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredExcludePairContainer(grammar);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new ExcludePairContainer(grammar);
                    }
                    ((ExcludePairContainer)pc).enableComplete(option.completeEnabled());
                    pc.enableNACs(option.nacsEnabled());
                    pc.enablePACs(option.pacsEnabled());
                    pc.enableReduce(option.reduceEnabled());
                    pc.enableConsistent(option.consistentEnabled());
                    pc.enableStrongAttrCheck(option.strongAttrCheckEnabled());
                    pc.enableEqualVariableNameOfAttrMapping(option.equalVariableNameOfAttrMappingEnabled());
                    pc.enableIgnoreIdenticalRules(option.ignoreIdenticalRulesEnabled());
                    pc.enableReduceSameMatch(option.reduceSameMatchEnabled());
                    pc.enableDirectlyStrictConfluent(option.directlyStrictConflEnabled());
                    pc.enableDirectlyStrictConfluentUpToIso(option.directlyStrictConflUpToIsoEnabled());
                    pc.enableNamedObjectOnly(option.namedObjectEnabled());
                    pc.enableMaxBoundOfCriticKind(option.getMaxBoundOfCriticKind());
                    break;
                }
                case 1: 
                case 2: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredDependencyPairContainer(grammar);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new DependencyPairContainer(grammar);
                    }
                    ((DependencyPairContainer)pc).enableSwitchDependency(option.switchDependencyEnabled());
                    ((DependencyPairContainer)pc).enableComplete(option.completeEnabled());
                    ((DependencyPairContainer)pc).enableNACs(option.nacsEnabled());
                    ((DependencyPairContainer)pc).enableReduce(option.reduceEnabled());
                    ((DependencyPairContainer)pc).enableConsistent(option.consistentEnabled());
                    ((DependencyPairContainer)pc).enableIgnoreIdenticalRules(option.ignoreIdenticalRulesEnabled());
                    ((DependencyPairContainer)pc).enableReduceSameMatch(option.reduceSameMatchEnabled());
                    ((DependencyPairContainer)pc).enableDirectlyStrictConfluent(option.directlyStrictConflEnabled());
                    ((DependencyPairContainer)pc).enableNamedObjectOnly(option.namedObjectEnabled());
                    ((DependencyPairContainer)pc).enableMaxBoundOfCriticKind(option.getMaxBoundOfCriticKind());
                    break;
                }
            }
        }
        return pc;
    }

    public static PairContainer createEmptyCriticalPairs(GraGra grammar, CriticalPairOption option) {
        ExcludePairContainer pc = null;
        if (option != null && grammar != null) {
            switch (option.getCriticalPairAlgorithm()) {
                case 0: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredExcludePairContainer(grammar);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new ExcludePairContainer(grammar);
                    }
                    ((ExcludePairContainer)pc).enableComplete(option.completeEnabled());
                    pc.enableNACs(option.nacsEnabled());
                    pc.enablePACs(option.pacsEnabled());
                    pc.enableReduce(option.reduceEnabled());
                    pc.enableConsistent(option.consistentEnabled());
                    pc.enableStrongAttrCheck(option.strongAttrCheckEnabled());
                    pc.enableEqualVariableNameOfAttrMapping(option.equalVariableNameOfAttrMappingEnabled());
                    pc.enableIgnoreIdenticalRules(option.ignoreIdenticalRulesEnabled());
                    pc.enableReduceSameMatch(option.reduceSameMatchEnabled());
                    pc.enableDirectlyStrictConfluent(option.directlyStrictConflEnabled());
                    pc.enableDirectlyStrictConfluentUpToIso(option.directlyStrictConflUpToIsoEnabled());
                    pc.enableNamedObjectOnly(option.namedObjectEnabled());
                    pc.enableMaxBoundOfCriticKind(option.getMaxBoundOfCriticKind());
                    break;
                }
                case 1: 
                case 2: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredDependencyPairContainer(grammar);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new DependencyPairContainer(grammar);
                    }
                    ((DependencyPairContainer)pc).enableSwitchDependency(option.switchDependencyEnabled());
                    ((DependencyPairContainer)pc).enableComplete(option.completeEnabled());
                    ((DependencyPairContainer)pc).enableNACs(option.nacsEnabled());
                    ((DependencyPairContainer)pc).enableReduce(option.reduceEnabled());
                    ((DependencyPairContainer)pc).enableConsistent(option.consistentEnabled());
                    ((DependencyPairContainer)pc).enableStrongAttrCheck(option.strongAttrCheckEnabled());
                    ((DependencyPairContainer)pc).enableIgnoreIdenticalRules(option.ignoreIdenticalRulesEnabled());
                    ((DependencyPairContainer)pc).enableReduceSameMatch(option.reduceSameMatchEnabled());
                    ((DependencyPairContainer)pc).enableDirectlyStrictConfluent(option.directlyStrictConflEnabled());
                    ((DependencyPairContainer)pc).enableNamedObjectOnly(option.namedObjectEnabled());
                    ((DependencyPairContainer)pc).enableMaxBoundOfCriticKind(option.getMaxBoundOfCriticKind());
                    break;
                }
            }
        }
        return pc;
    }

    public static PairContainer createEmptyCriticalPairs(GraGra grammar, int algorithm, boolean layered) {
        ExcludePairContainer pc = null;
        if (grammar != null) {
            switch (algorithm) {
                case 0: {
                    if (layered) {
                        pc = new LayeredExcludePairContainer(grammar);
                        break;
                    }
                    if (grammar.trafoByPriority()) {
                        pc = new PriorityExcludePairContainer(grammar);
                        break;
                    }
                    pc = new ExcludePairContainer(grammar);
                    break;
                }
                case 1: 
                case 2: {
                    pc = layered ? new LayeredDependencyPairContainer(grammar) : (grammar.trafoByPriority() ? new PriorityDependencyPairContainer(grammar) : new DependencyPairContainer(grammar));
                    if (algorithm != 2) break;
                    ((DependencyPairContainer)pc).enableSwitchDependency(true);
                    break;
                }
            }
        }
        return pc;
    }

    public static Thread generateCriticalPairs(PairContainer pc) {
        Thread t = null;
        if (pc != null && pc instanceof Runnable) {
            t = new Thread((Runnable)((Object)pc));
            t.setPriority(4);
            t.start();
        }
        return t;
    }

    public static PairContainer generateCriticalPairs(GraGra grammar, LayerFunction layer, CriticalPairOption option) {
        PairContainer pc = ParserFactory.createEmptyCriticalPairs(grammar, layer, option);
        ParserFactory.generateCriticalPairs(pc);
        return pc;
    }

    public static LayerFunction createLayerFunction(GraGra grammar, LayerOption option) {
        LayerFunction lf = null;
        if (option != null && grammar != null) {
            switch (option.getLayer()) {
                case 1: {
                    lf = new LayerFunction(grammar);
                    break;
                }
                case 0: {
                    lf = new ExtendedLayerFunction(grammar);
                    break;
                }
                case 3: {
                    lf = new WeakLayerFunction(grammar);
                    break;
                }
                case 2: {
                    lf = new WeakExtendedLayerFunction(grammar);
                    break;
                }
            }
        }
        return lf;
    }
}

