/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.BinaryConstraint;
import agg.util.csp.Variable;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public abstract class Query {
    protected List<Variable> itsSources = new Vector<Variable>(2, 1);
    protected Variable itsTarget;
    protected int itsWeight;
    public String typeNameOfVariable = "";
    private BinaryConstraint correspondent;

    public Query(Variable tar, int weight) {
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    public Query(Variable src, Variable tar, int weight) {
        this.itsSources.add(src);
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    public Query(Variable src1, Variable src2, Variable tar, int weight) {
        this.itsSources.add(src1);
        this.itsSources.add(src2);
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    private final void initialize() {
        int i = 0;
        while (i < this.itsSources.size()) {
            this.itsSources.get(i).addOutgoingQuery(this);
            ++i;
        }
        if (this.itsTarget != null) {
            this.itsTarget.addIncomingQuery(this);
        } else {
            System.out.println("agg.util.csp.Query.initialize():: itsTarget is null!");
        }
    }

    public boolean isApplicable() {
        if (this.itsTarget.getInstance() != null) {
            return false;
        }
        int i = 0;
        while (i < this.itsSources.size()) {
            Variable v = this.itsSources.get(i);
            if (v.getInstance() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isConstant() {
        return this.itsSources.size() == 0;
    }

    public abstract HashSet<?> execute();

    public Variable getTarget() {
        return this.itsTarget;
    }

    public final List<?> getSources() {
        return this.itsSources;
    }

    public final Variable getSource(int i) {
        return this.itsSources.get(i);
    }

    public abstract int getSize();

    public final int getWeight() {
        return this.itsWeight;
    }

    public abstract String getKind();

    public abstract boolean isDomainEmpty();

    protected final Object getSourceInstance(int i) {
        return this.itsSources.get(i).getInstance();
    }

    public void setCorrespondent(BinaryConstraint constraint) {
        this.correspondent = constraint;
    }

    public void activateCorrespondent() {
        if (this.correspondent == null) {
            return;
        }
        this.correspondent.activate();
    }

    public void deactivateCorrespondent() {
        if (this.correspondent == null) {
            return;
        }
        this.correspondent.deactivate();
    }
}

