/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.Search_BreadthFirst;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import agg.xt_basis.csp.Query_Type;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solution_Backtrack
implements SolutionStrategy {
    private CSP itsCSP;
    private boolean parallel;
    private boolean startParallelbyFirst;
    private Vector<Query> itsQueries = new Vector();
    private final Dictionary<Variable, Integer> itsVarIndexMap = new Hashtable<Variable, Integer>();
    private final Dictionary<Object, Variable> itsInstanceVarMap = new Hashtable<Object, Variable>();
    private boolean itsInjectiveFlag;
    private Dictionary<Object, Variable> otherInstanceVarMap;
    private SearchStrategy itsSearcher = new Search_BreadthFirst();
    private int itsCurrentIndex;
    private Variable itsCurrentVar;
    private Query itsCurrentQuery;
    private int itsState;
    private int itsInstantiationCounter;
    private int itsBackstepCounter;
    private boolean solutionFound;
    private static final int START = 1;
    private static final int NEXT = 2;
    private static final int INSTANTIATE = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_SOLUTIONS = 6;
    private static final int BACKJUMP = 7;

    public Solution_Backtrack() {
        this.itsInjectiveFlag = false;
    }

    public Solution_Backtrack(boolean injective) {
        this.itsInjectiveFlag = injective;
    }

    @Override
    public void clear() {
        this.itsQueries.clear();
        ((Hashtable)this.itsVarIndexMap).clear();
        ((Hashtable)this.itsInstanceVarMap).clear();
    }

    @Override
    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relatedVarIndexMap) {
        this.otherInstanceVarMap = relatedVarIndexMap;
    }

    @Override
    public Dictionary<Object, Variable> getInstanceVarMap() {
        return this.itsInstanceVarMap;
    }

    private final boolean initialize(CSP csp) {
        this.itsCSP = csp;
        this.itsQueries.removeAllElements();
        this.itsQueries = this.itsSearcher.execute(this.itsCSP);
        this.itsQueries.trimToSize();
        int i = 0;
        while (i < this.itsQueries.size()) {
            this.itsVarIndexMap.put(this.itsQueries.elementAt(i).getTarget(), i);
            ++i;
        }
        Enumeration<Variable> anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, -1);
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        return true;
    }

    @Override
    public final boolean reinitialize(boolean doUpdateQueries) {
        if (doUpdateQueries) {
            this.itsQueries.removeAllElements();
            this.itsQueries = this.itsSearcher.execute(this.itsCSP);
            this.itsQueries.trimToSize();
        }
        ((Hashtable)this.itsVarIndexMap).clear();
        ((Hashtable)this.itsInstanceVarMap).clear();
        int i = 0;
        while (i < this.itsQueries.size()) {
            Query q = this.itsQueries.elementAt(i);
            this.itsVarIndexMap.put(q.getTarget(), i);
            if (q instanceof Query_Type) {
                ((Query_Type)q).resetObjects();
            }
            ++i;
        }
        Enumeration<Variable> anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, -1);
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        this.itsState = 1;
        return true;
    }

    @Override
    public void reinitialize(Variable var) {
        Variable v;
        boolean queryExists = false;
        Query q = null;
        int i = 0;
        while (i < this.itsQueries.size()) {
            q = this.itsQueries.elementAt(i);
            v = this.itsQueries.elementAt(i).getTarget();
            if (v == var) {
                queryExists = true;
                if (var.getInstance() != null) {
                    this.itsInstanceVarMap.remove(var.getInstance());
                }
                this.itsVarIndexMap.put(v, i);
                this.itsState = 1;
                break;
            }
            ++i;
        }
        if (!queryExists) {
            if (var.getInstance() != null) {
                this.itsInstanceVarMap.remove(var.getInstance());
            }
            if ((q = var.getTypeQuery()) != null) {
                this.itsQueries.add(0, q);
                i = 0;
                while (i < this.itsQueries.size()) {
                    q = this.itsQueries.elementAt(i);
                    v = this.itsQueries.elementAt(i).getTarget();
                    this.itsVarIndexMap.put(v, i);
                    ++i;
                }
                this.itsState = 1;
            }
        }
    }

    @Override
    public final void reset() {
        this.itsState = 1;
    }

    @Override
    public void resetQuery_Type() {
        int i = 0;
        while (i < this.itsQueries.size()) {
            if (this.itsQueries.elementAt(i) instanceof Query_Type) {
                ((Query_Type)this.itsQueries.elementAt(i)).resetObjects();
            }
            ++i;
        }
    }

    @Override
    public final synchronized boolean next(CSP csp) {
        this.solutionFound = false;
        if (!csp.equals(this.itsCSP)) {
            if (!this.initialize(csp)) {
                return false;
            }
            this.itsState = 1;
        }
        if (this.itsState == 5) {
            this.itsState = 4;
            ++this.itsCurrentIndex;
        }
        block9: while (true) {
            switch (this.itsState) {
                case 1: {
                    this.itsInstantiationCounter = 0;
                    this.itsBackstepCounter = 0;
                    this.itsCurrentIndex = -1;
                    this.itsState = 2;
                    continue block9;
                }
                case 2: {
                    if (this.itsCurrentIndex >= this.itsQueries.size() - 1) {
                        this.itsState = 5;
                        continue block9;
                    }
                    this.itsCurrentQuery = this.itsQueries.elementAt(++this.itsCurrentIndex);
                    this.itsCurrentVar = this.itsCurrentQuery.getTarget();
                    if (this.itsCurrentQuery.isApplicable()) {
                        this.itsCurrentVar.setDomainEnum(this.itsCurrentQuery.execute());
                        this.itsState = 3;
                        continue block9;
                    }
                    this.itsState = 6;
                    continue block9;
                }
                case 3: {
                    this.itsState = 4;
                    this.itsCurrentQuery.deactivateCorrespondent();
                    while (this.itsCurrentVar.hasNext()) {
                        ++this.itsInstantiationCounter;
                        this.itsCurrentVar.setInstance(this.itsCurrentVar.getNext());
                        Variable aConflictVar = this.checkInjection(this.itsCurrentVar);
                        if (aConflictVar != null) {
                            this.itsCurrentVar.setInstance(null);
                            continue;
                        }
                        Enumeration<Variable> allConflictVars = this.itsCurrentVar.checkConstraints();
                        if (allConflictVars.hasMoreElements()) continue;
                        this.itsState = 2;
                        this.addInjection(this.itsCurrentVar);
                        break;
                    }
                    this.itsCurrentQuery.activateCorrespondent();
                    continue block9;
                }
                case 4: {
                    ++this.itsBackstepCounter;
                    if (this.itsCurrentIndex == 0) {
                        if (this.itsCurrentVar != null && this.itsCurrentVar.hasNext()) {
                            this.removeInjection(this.itsCurrentVar);
                            this.itsCurrentVar.setInstance(null);
                            this.itsState = 3;
                            continue block9;
                        }
                        this.itsState = 6;
                        continue block9;
                    }
                    this.removeInjection(this.itsCurrentVar);
                    this.itsCurrentVar.setInstance(null);
                    this.itsCurrentVar = this.itsQueries.elementAt(--this.itsCurrentIndex).getTarget();
                    this.removeInjection(this.itsCurrentVar);
                    this.itsState = 3;
                    continue block9;
                }
                case 7: {
                    ++this.itsBackstepCounter;
                    this.itsState = 6;
                    while (true) {
                        if (this.itsCurrentIndex <= 0) continue block9;
                        this.removeInjection(this.itsCurrentVar);
                        this.itsCurrentVar.setInstance(null);
                        this.itsCurrentVar = this.itsQueries.elementAt(--this.itsCurrentIndex).getTarget();
                        this.removeInjection(this.itsCurrentVar);
                        this.itsState = 3;
                    }
                }
                case 5: {
                    if (this.parallel && this.startParallelbyFirst) {
                        this.removeUsedObjectFromDomain();
                    }
                    this.solutionFound = true;
                    return true;
                }
                case 6: {
                    return false;
                }
            }
            System.out.println("Should have never come here..." + this.itsState);
        }
    }

    private void removeUsedObjectFromDomain() {
        int i = 0;
        while (i < this.itsQueries.size()) {
            Query q = this.itsQueries.get(i);
            if (q instanceof Query_Type) {
                ((Query_Type)q).removeObject((GraphObject)q.getTarget().getInstance());
            }
            ++i;
        }
        ((Hashtable)this.itsInstanceVarMap).clear();
    }

    @Override
    public boolean hasSolution() {
        return this.solutionFound;
    }

    @Override
    public boolean hasQueries() {
        return !this.itsQueries.isEmpty();
    }

    private final void addInjection(Variable var) {
        if (this.itsInjectiveFlag) {
            this.itsInstanceVarMap.put(var.getInstance(), var);
        }
    }

    private final void removeInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.remove(var.getInstance());
        }
    }

    private final Variable checkInjection(Variable var) {
        if (var.getInstance() != null) {
            Variable other;
            if (this.otherInstanceVarMap != null && (other = this.otherInstanceVarMap.get(var.getInstance())) != null) {
                return other;
            }
            if (this.itsInjectiveFlag) {
                return this.itsInstanceVarMap.get(var.getInstance());
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean parallelSearch() {
        return this.parallel;
    }

    @Override
    public void enableParallelSearch(boolean b) {
        this.parallel = b;
    }

    @Override
    public void setStartParallelSearchByFirst(boolean b) {
        this.startParallelbyFirst = b;
    }

    @Override
    public Variable getStartVariable() {
        return this.itsQueries.get((int)0).itsTarget;
    }

    @Override
    public Query getQuery(Variable var) {
        return this.itsQueries.get(this.itsVarIndexMap.get(var));
    }
}

