/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.cons.AtomConstraint;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RulePriority;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import agg.xt_basis.agt.RuleScheme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class PriorityGraTraImpl
extends GraTra {
    Random ran = new Random();
    private boolean appliedOnce;
    private boolean priorityGraTra = false;
    private Vector<Pair<Integer, HashSet<Rule>>> sortedRules = new Vector();
    private File f;
    private FileOutputStream os;
    private String protocolFileName = "";
    private boolean grammarChecked;

    @Override
    public void dispose() {
        if (this.sortedRules != null) {
            this.sortedRules.clear();
        }
        super.dispose();
    }

    @Override
    public Pair<Morphism, Morphism> derivation(Match m) {
        return null;
    }

    public boolean atLeastOneRuleHasPriority() {
        int i = 0;
        while (i < this.currentRuleSet.size()) {
            Rule r = (Rule)this.currentRuleSet.get(i);
            if (r.getPriority() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void sortByPriority(Vector<Rule> rules) {
        RulePriority priority = new RulePriority(rules);
        Integer startPriority = priority.getStartPriority();
        Hashtable<Integer, HashSet<Rule>> invertedRulePriority = priority.invertPriority();
        OrderedSet<Integer> rulePrioritySet = new OrderedSet<Integer>(new IntComparator());
        Enumeration<Integer> en = invertedRulePriority.keys();
        while (en.hasMoreElements()) {
            rulePrioritySet.add(en.nextElement());
        }
        int i = 0;
        Integer maxPriorityInt = null;
        HashSet<Rule> priority0Set = null;
        Integer currentPriority = startPriority;
        boolean nextPriorityExists = true;
        while (nextPriorityExists && currentPriority != null) {
            HashSet<Rule> rulesForPriority = invertedRulePriority.get(currentPriority);
            Pair<Integer, HashSet<Rule>> p = new Pair<Integer, HashSet<Rule>>(currentPriority, rulesForPriority);
            if (currentPriority > 0) {
                this.sortedRules.add(p);
            } else {
                priority0Set = rulesForPriority;
            }
            maxPriorityInt = currentPriority;
            if (++i < rulePrioritySet.size()) {
                currentPriority = (Integer)rulePrioritySet.get(i);
                continue;
            }
            nextPriorityExists = false;
        }
        if (priority0Set != null && maxPriorityInt != null) {
            int maxPriority = maxPriorityInt + 1;
            Pair<Integer, Object> p0 = new Pair<Integer, Object>(new Integer(maxPriority), priority0Set);
            this.sortedRules.add(p0);
        }
    }

    @Override
    public boolean apply() {
        boolean applied = false;
        if (this.atLeastOneRuleHasPriority()) {
            this.priorityGraTra = true;
            this.sortByPriority(this.currentRuleSet);
            applied = this.applyPriorityGraTra();
            return applied;
        }
        return false;
    }

    private boolean applyPriorityGraTra() {
        boolean result = false;
        Pair<Integer, HashSet<Rule>> pFirst = this.sortedRules.get(0);
        HashSet ruleSetFirst = (HashSet)pFirst.second;
        boolean asLongAsPossible = true;
        boolean applied = true;
        while (!this.stopping && applied) {
            if (!this.stopping) {
                asLongAsPossible = true;
                applied = this.applyRandomly(ruleSetFirst, asLongAsPossible);
            }
            asLongAsPossible = false;
            Pair<Integer, HashSet<Rule>> p = null;
            HashSet ruleSet = null;
            int i = 1;
            while (!this.stopping && i < this.sortedRules.size()) {
                p = this.sortedRules.get(i);
                ruleSet = (HashSet)p.second;
                if (this.applyRandomly(ruleSet, asLongAsPossible)) {
                    applied = true;
                    break;
                }
                ++i;
            }
            if (!applied) continue;
            result = true;
        }
        return result;
    }

    private boolean applyRandomly(Vector<Rule> rules, boolean asLongAsPossible) {
        boolean result = false;
        boolean applied = true;
        block0: while (applied) {
            applied = false;
            Vector v = (Vector)rules.clone();
            while (!v.isEmpty()) {
                int j = this.ran.nextInt(v.size());
                this.currentRule = (Rule)v.get(j);
                if (this.currentRule instanceof RuleScheme) {
                    applied = this.apply((RuleScheme)this.currentRule);
                } else {
                    boolean bl = applied = this.currentRule.canMatch(this.hostgraph, this.strategy) && this.applyRule(this.currentRule);
                }
                if (applied) {
                    result = true;
                    if (asLongAsPossible) continue block0;
                    return result;
                }
                v.remove(this.currentRule);
            }
        }
        return result;
    }

    private boolean applyRandomly(HashSet rules, boolean asLongAsPossible) {
        Vector<Rule> rulesVec = new Vector<Rule>(rules.size());
        for (Rule r : rules) {
            rulesVec.add(r);
        }
        return this.applyRandomly(rulesVec, asLongAsPossible);
    }

    private boolean applyRule(Rule r) {
        boolean applied = false;
        if (this.apply(r)) {
            applied = true;
        }
        String s0 = String.valueOf(r.getName()) + " \t applied:  " + applied;
        System.out.println(s0);
        this.writeTransformProtocol(s0);
        String s1 = "";
        if (!applied) {
            s1 = String.valueOf(s1) + this.getErrorMsg();
            this.writeTransformProtocol(s1);
        }
        return applied;
    }

    @Override
    public void transform(List<Rule> ruleSet) {
        this.currentRuleSet.clear();
        this.currentRuleSet.addAll(ruleSet);
        boolean result = this.apply();
        if (!result && !this.priorityGraTra) {
            this.writeTransformProtocol("Graph transformation failed. No rule priority used.");
        }
    }

    @Override
    public void transform() {
        this.stopping = false;
        if (!this.grammar.getListOfRules().isEmpty() && this.currentRuleSet.isEmpty()) {
            this.setRuleSet();
        }
        if (this.writeLogFile) {
            String dirName = this.grammar.getDirName();
            String fileName = this.grammar.getFileName();
            if (fileName == null || fileName.equals("")) {
                fileName = this.grammar.getName();
            }
            this.openTransformProtocol(dirName, fileName);
            String version = "Version:  AGG " + Version.getID() + "\n";
            this.writeTransformProtocol(version);
            String s0 = "Graph transformation by rule priority of : " + this.grammar.getName();
            String s1 = "at graph : " + this.grammar.getGraph().getName();
            String s2 = this.getRuleNames(this.currentRuleSet);
            this.writeTransformProtocol(s0);
            this.writeTransformProtocol(s1);
            this.writeTransformProtocol(s2);
            this.writeTransformProtocol("\n");
        }
        if (!this.grammarChecked) {
            Pair<Object, String> pair = this.grammar.isReadyToTransform(true);
            if (pair != null) {
                Object test = pair.first;
                if (test != null) {
                    String s0 = String.valueOf((String)pair.second) + "\nTransformation is stopped.";
                    if (test instanceof Type) {
                        this.fireGraTra(new GraTraEvent((Object)this, 15, s0));
                    } else if (test instanceof Rule) {
                        this.fireGraTra(new GraTraEvent((Object)this, 9, s0));
                    } else if (test instanceof AtomConstraint) {
                        this.fireGraTra(new GraTraEvent((Object)this, 14, s0));
                    }
                    this.transformFailed(s0);
                    return;
                }
            } else {
                if (!this.grammar.isGraphReadyForTransform()) {
                    String s0 = "Graph of the grammar is not fine.\nPlease check attribute settings of the objects. \nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s0));
                    this.transformFailed(s0);
                    return;
                }
                if (!this.checkGraphConsistency()) {
                    String s = "Graph consistency failed.\nPlease check the host graph against the graph constraints.\nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s));
                    this.transformFailed(s);
                    return;
                }
            }
            this.grammarChecked = true;
        }
        long startTime = System.currentTimeMillis();
        Vector<Rule> ruleSet = this.getEnabledRules(this.currentRuleSet);
        this.transform(ruleSet);
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        System.out.println("Used time for graph transformation:  " + (System.currentTimeMillis() - startTime) + "ms");
        if (this.writeLogFile) {
            this.writeUsedTimeToProtocol("Used time for graph transformation: ", startTime);
            this.writeTransformProtocol("\nGraph transformation finished");
            this.closeTransformProtocol();
        }
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
    }

    private void writeUsedTimeToProtocol(String text, long beginTime) {
        this.writeTransformProtocol(String.valueOf(text) + (System.currentTimeMillis() - beginTime) + "ms");
    }

    private Vector<Rule> getEnabledRules(Vector<Rule> ruleSet) {
        Vector<Rule> vec = new Vector<Rule>(ruleSet.size());
        int j = 0;
        while (j < ruleSet.size()) {
            if (ruleSet.elementAt(j).isEnabled()) {
                vec.add(ruleSet.elementAt(j));
            }
            ++j;
        }
        return vec;
    }

    private void transformFailed(String text) {
        System.out.println(text);
        this.writeTransformProtocol(text);
        this.writeTransformProtocol("\nGraph transformation failed");
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
        this.closeTransformProtocol();
    }

    @Override
    public boolean transformationDone() {
        return this.appliedOnce;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    private String getRuleNames(Vector<Rule> rules) {
        String names = "[ ";
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.elementAt(j);
            names = String.valueOf(names) + r.getName() + " ";
            ++j;
        }
        names = String.valueOf(names) + "]";
        return names;
    }

    private void openTransformProtocol(String dirName, String fileName) {
        String dName = dirName;
        String fName = "PriorityGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_GraTra.log" : String.valueOf(fileName) + "_GraTra.log";
        }
        if (dName != null && !dName.equals("")) {
            this.f = new File(dirName);
            dName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? String.valueOf(this.f.getParent()) + File.separator : "." + File.separator) : (this.f.isDirectory() ? String.valueOf(this.f.getPath()) + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(String.valueOf(dirName) + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    private void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

