/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.ALPHA_DIAGRAM;
import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.COPROD_OBJECT;
import agg.xt_basis.colim.GRAPH_DIAGRAM;
import agg.xt_basis.colim.GRAPH_TEST;
import agg.xt_basis.colim.INT_VECTOR;
import agg.xt_basis.colim.SET_DIAGRAM;

public class ALPHA_TEST
implements COLIM_DEFS {
    private ALPHA_DIAGRAM alpha_diagram = new ALPHA_DIAGRAM();

    public ALPHA_TEST() {
        this.gen_alpha_test();
        System.out.print("\nalpha diagram:\n" + this.alpha_diagram.toString());
        COLIM_VECTOR items = this.alpha_diagram.get_colimit_items_total();
        COLIM_VECTOR refs = this.alpha_diagram.get_colimit_refs_total();
        COLIM_VECTOR attrs = this.alpha_diagram.get_colimit_attrs_total();
        COLIM_VECTOR attr_sets = this.alpha_diagram.get_colimit_attr_sets_total();
        System.out.print("\ncolimit alpha algebra:\n" + this.alpha_diagram.out_object(items, refs, attrs) + "\ncolimit alpha algebra with attribute sets:\n" + this.alpha_diagram.out_object_attr_sets(items, refs, attr_sets));
        System.out.flush();
    }

    private void gen_alpha_test() {
        GRAPH_TEST graph_test = new GRAPH_TEST();
        GRAPH_DIAGRAM graph_diagram = graph_test.graph_diagram;
        SET_DIAGRAM node_diagram = graph_diagram.get_node_diagram();
        SET_DIAGRAM edge_diagram = graph_diagram.get_edge_diagram();
        int obj = 0;
        while (obj < node_diagram.object_count()) {
            COLIM_VECTOR attr;
            INT_VECTOR ref;
            COPROD_OBJECT nodes = node_diagram.set_at_node(obj);
            COPROD_OBJECT edges = edge_diagram.set_at_node(obj);
            COLIM_VECTOR items = new COLIM_VECTOR();
            COLIM_VECTOR refs = new COLIM_VECTOR();
            COLIM_VECTOR attrs = new COLIM_VECTOR();
            int node = nodes.lower;
            while (node <= nodes.upper) {
                ref = new INT_VECTOR();
                attr = new COLIM_VECTOR();
                attr.push_back(node_diagram.get_element(node));
                items.push_back(node_diagram.get_element(node));
                refs.push_back(ref);
                attrs.push_back(attr);
                ++node;
            }
            int edge = edges.lower;
            while (edge <= edges.upper) {
                ref = new INT_VECTOR();
                ref.push_back(items.indexOf(graph_diagram.get_source(edge)));
                ref.push_back(items.indexOf(graph_diagram.get_target(edge)));
                attr = new COLIM_VECTOR();
                attr.push_back(edge_diagram.get_element(edge));
                items.push_back(edge_diagram.get_element(edge));
                refs.push_back(ref);
                attrs.push_back(attr);
                ++edge;
            }
            int n = this.alpha_diagram.insert_object(items, refs, attrs, graph_diagram.get_node_diagram().get_name(obj));
            ++obj;
        }
        int mor = 0;
        while (mor < node_diagram.morphism_count()) {
            INT_VECTOR morphism = new INT_VECTOR(node_diagram.morphism_at_edge(mor));
            int target_upper = node_diagram.object_size(node_diagram.target_at_edge(mor));
            INT_VECTOR e_mor = edge_diagram.morphism_at_edge(mor);
            int i = 0;
            while (i < e_mor.size()) {
                morphism.push_back(e_mor.item(i) + target_upper);
                ++i;
            }
            int n = this.alpha_diagram.insert_morphism(morphism, node_diagram.source_at_edge(mor), node_diagram.target_at_edge(mor));
            ++mor;
        }
    }
}

