/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrConditionMember;
import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrInstance;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.LoneTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarTuple;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class CondTuple
extends LoneTuple
implements AttrConditionTuple,
AttrMsgCode {
    protected static String boolHandlerName = JexHandler.getLabelName();
    protected static final String boolTypeName = "boolean";
    protected static final String trueVal = "true";
    protected static final String falseVal = "false";
    protected static final String namePrefix = "c";
    protected AttrHandler condHandler = null;
    protected HandlerType boolType = null;
    protected int condNum = 0;
    String failedCondAsString;

    public CondTuple(AttrTupleManager manager, ContextView context, CondTuple parent) {
        super(manager, context, parent);
        this.getContextView().setAllowVarDeclarations(true);
        this.getContextView().setAllowComplexExpr(true);
        this.initClass();
        if (parent != null) {
            if (this.getSize() == 0 && this.parent.getSize() > 0) {
                int i = 0;
                while (i < this.parent.getSize()) {
                    CondMember m = (CondMember)this.parent.getMemberAt(i);
                    CondMember mem = (CondMember)this.addCondition(m.getExprAsText());
                    if (mem != null) {
                        mem.setEnabled(m.isEnabled());
                        mem.setMark(m.getMark());
                    }
                    ++i;
                }
            }
            this.getContextView().setVariableContext(parent.getContextView().isVariableContext());
        }
    }

    protected void initClass() {
        if (this.boolType == null) {
            String errMsg = "";
            this.condHandler = this.manager.getHandler(boolHandlerName);
            try {
                this.boolType = this.condHandler.newHandlerType(boolTypeName);
                if (this.manager.classNameLookupMap.get(boolTypeName) == null) {
                    this.manager.classNameLookupMap.put(boolTypeName, Boolean.TRUE);
                }
            }
            catch (AttrHandlerException ex) {
                errMsg = ex.getMessage();
            }
            if (this.boolType == null) {
                errMsg = String.valueOf(errMsg) + "\nFinding a boolean type for condition expressions failed!\n";
                throw new AttrImplException(1, errMsg);
            }
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.getSize()) {
            this.deleteMemberAt(i);
            ++i;
        }
        this.condNum = 0;
        this.errorMsg = "";
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void makeCopyOf(CondTuple tuple) {
        if (this.getSize() == 0 && tuple.getSize() > 0) {
            int i = 0;
            while (i < tuple.getSize()) {
                CondMember m = (CondMember)tuple.getMemberAt(i);
                CondMember mem = (CondMember)this.addCondition(m.getExprAsText());
                if (mem != null) {
                    mem.setEnabled(m.isEnabled());
                    mem.setMark(m.getMark());
                }
                ++i;
            }
        }
    }

    protected String getNextName() {
        return namePrefix + this.condNum++;
    }

    protected String getNameFor(int index) {
        return namePrefix + index;
    }

    @Override
    protected ValueMember newMember(DeclMember decl) {
        return new CondMember(this, decl);
    }

    public CondMember getCondMemberAt(int index) {
        return (CondMember)this.getMemberAt(index);
    }

    @Override
    public AttrConditionMember addCondition(String expr) {
        if (expr.equals("")) {
            return null;
        }
        this.getTupleType().addMember(this.condHandler, boolTypeName, this.getNextName());
        CondMember cm = this.getCondMemberAt(this.getSize() - 1);
        cm.setExprAsText(expr);
        if (cm.getErrorMsg().indexOf("Parsing error") != -1) {
            this.errorMsg = cm.getErrorMsg();
        }
        return cm;
    }

    public AttrConditionMember addCondition(int indx, String expr) {
        if (expr.equals("")) {
            return null;
        }
        this.getTupleType().addMember(indx, this.condHandler, boolTypeName, this.getNextName());
        CondMember cm = this.getCondMemberAt(indx);
        cm.setExprAsText(expr);
        if (cm.getErrorMsg().indexOf("Parsing error") != -1) {
            this.errorMsg = cm.getErrorMsg();
        }
        return cm;
    }

    @Override
    public boolean isDefinite() {
        int i = 0;
        while (i < this.getSize()) {
            if (!this.getCondMemberAt(i).isDefinite()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDefinite(String name) {
        int i = 0;
        while (i < this.getSize()) {
            CondMember cm = this.getCondMemberAt(i);
            Vector<String> v = cm.getAllVariables();
            if (v.contains(name) && !cm.isDefinite()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(String expr) {
        int i = 0;
        while (i < this.getSize()) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.getExprAsText().equals(expr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEvaluable(VarTuple vars) {
        int i = 0;
        while (i < this.getSize()) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEnabled() && !cm.isEvaluable(vars)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isTrue() {
        this.failedCondAsString = "";
        int i = 0;
        while (i < this.getSize()) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEnabled() && !cm.isTrue()) {
                this.failedCondAsString = cm.getExprAsText();
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTrue(String name) {
        this.failedCondAsString = "";
        int i = 0;
        while (i < this.getSize()) {
            Vector<String> v;
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEnabled() && (v = cm.getAllVariables()).contains(name) && !cm.isTrue()) {
                this.failedCondAsString = cm.getExprAsText();
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isFalse() {
        this.failedCondAsString = "";
        int i = 0;
        while (i < this.getSize()) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEnabled() && cm.isDefinite() && !cm.isTrue()) {
                this.failedCondAsString = cm.getExprAsText();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFalse(String varname) {
        this.failedCondAsString = "";
        int i = 0;
        while (i < this.getSize()) {
            Vector<String> v;
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEnabled() && (v = cm.getAllVariables()).contains(varname) && cm.isDefinite() && !cm.isTrue()) {
                this.failedCondAsString = cm.getExprAsText();
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFailedConditionAsString() {
        String s = this.failedCondAsString;
        this.failedCondAsString = "";
        return s;
    }

    public void setVariableContext(boolean b) {
        this.getContextView().setVariableContext(b);
    }

    @Override
    public Vector<String> getAllVariables() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.getSize()) {
            CondMember member = this.getCondMemberAt(i);
            Vector<String> names = member.getAllVariables();
            int j = 0;
            while (j < names.size()) {
                String name = names.elementAt(j);
                if (!result.contains(name)) {
                    result.addElement(name);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean usesVariable(String var) {
        int i = 0;
        while (i < this.getSize()) {
            CondMember member = this.getCondMemberAt(i);
            Vector<String> names = member.getAllVariables();
            if (names.contains(var)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean compareTo(AttrInstance another) {
        CondTuple vt = (CondTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        int i = 0;
        while (i < length) {
            CondMember v = this.getCondMemberAt(i);
            CondMember v1 = vt.getCondMemberAt(i);
            if (v.getExpr() != null || v1.getExpr() != null) {
                if (v.getExpr() == null && v1.getExpr() != null) {
                    return false;
                }
                if (v.getExpr() != null && v1.getExpr() == null) {
                    return false;
                }
                if (!v.getExprAsText().equals(v1.getExprAsText())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void showConditions() {
        System.out.println("Attr. context conditions: ");
        int i = 0;
        while (i < this.getSize()) {
            CondMember c = (CondMember)this.getMemberAt(i);
            if (c != null) {
                System.out.println(String.valueOf(c.getExprAsText()) + "      (" + c.getMark() + ")");
            }
            ++i;
        }
        System.out.println("================================");
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int num = this.getSize();
        int i = 0;
        while (i < num) {
            CondMember cm = this.getCondMemberAt(i);
            h.openSubTag("Condition");
            if (!cm.isEnabled()) {
                h.addAttr("enabled", falseVal);
            }
            h.openSubTag("Value");
            h.addAttrValue("string", cm.getExprAsText());
            h.close();
            h.close();
            ++i;
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        Enumeration<Element> en = h.getEnumeration("", null, true, "Condition");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            if (h.getDocumentVersion().equals("1.0")) {
                boolean enabled = true;
                String attr_enabled = h.readAttr("enabled");
                if (attr_enabled != null && attr_enabled.equals(falseVal)) {
                    enabled = false;
                }
                if (h.readSubTag("Value")) {
                    Object obj = null;
                    String javaTag = h.readSubTag();
                    if (javaTag.equals("java") && (obj = h.getAttrValue("String")) == null) {
                        obj = h.getAttrValue("string");
                    }
                    if (javaTag.equals("string") || javaTag.equals("String")) {
                        obj = h.getElementData(h.top());
                    }
                    h.close();
                    if (obj instanceof String) {
                        String objStr = (String)obj;
                        String test = objStr.replaceAll("\n", "");
                        while (test.indexOf("  ") != -1) {
                            objStr = test.replaceAll("  ", " ");
                            test = objStr.toString();
                        }
                        CondMember cond = (CondMember)this.addCondition(objStr);
                        if (cond != null) {
                            cond.setEnabled(enabled);
                        }
                    }
                    h.close();
                }
            } else {
                this.addCondition(h.readAttr("value"));
            }
            h.close();
        }
    }
}

