/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.SymbolTable;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.EvalSet;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MatchHelper;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Convert {
    private Rule rule;
    private AtomConstraint atom;
    private String error = "";
    private boolean setEnabledTG = false;

    public Convert(Rule r, AtomConstraint a) {
        this.rule = r;
        this.atom = a;
        if (this.atom.getSource().isEmpty()) {
            this.setEnabledTG = true;
        }
    }

    private Pair<OrdinaryMorphism, OrdinaryMorphism> pushout(OrdinaryMorphism r, OrdinaryMorphism m) {
        Link l;
        OrdinaryMorphism morph;
        GraphObject img2;
        GraphObject img1;
        this.error = "";
        BaseFactory bf = BaseFactory.theFactory();
        Graph P = r.getOriginal();
        if (P != m.getOriginal()) {
            System.err.println("Failed!  Convert.pushout() called with morphisms from different sources");
            return null;
        }
        Graph G3 = bf.createGraph(r.getImage().getTypeSet());
        G3.setName(r.getName());
        OrdinaryMorphism p1 = bf.createMorphism(m.getImage(), G3);
        p1.setName("p1_morphism");
        OrdinaryMorphism p2 = bf.createMorphism(r.getImage(), G3);
        p2.setName("p2_morphism");
        HashMap<GraphObject, Link> hash = new HashMap<GraphObject, Link>();
        Iterator<GraphObject> en = P.getNodesSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        en = P.getArcsSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        en = r.getImage().getNodesSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        en = r.getImage().getArcsSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        en = m.getImage().getNodesSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        en = m.getImage().getArcsSet().iterator();
        while (en.hasNext()) {
            hash.put(en.next(), new Link());
        }
        Link empty = new Link();
        hash.put(null, empty);
        for (GraphObject graphObject : P.getNodesSet()) {
            img1 = r.getImage(graphObject);
            img2 = m.getImage(graphObject);
            if (img2 == null) {
                System.err.println("Argh!  Convert.pushout() FAILED! (m match is corrupt)");
                return null;
            }
            Link l2 = (Link)hash.get(graphObject);
            l2.link((Link)hash.get(img1)).link((Link)hash.get(img2));
            if (img1 != null || !graphObject.isNode()) continue;
            Node n = (Node)graphObject;
            Iterator<Arc> arcs = n.getIncomingArcsSet().iterator();
            while (arcs.hasNext()) {
                empty.link((Link)hash.get(arcs.next()));
            }
            arcs = n.getOutgoingArcsSet().iterator();
            while (arcs.hasNext()) {
                empty.link((Link)hash.get(arcs.next()));
            }
        }
        for (GraphObject graphObject : P.getArcsSet()) {
            img1 = r.getImage(graphObject);
            img2 = m.getImage(graphObject);
            if (img2 == null) {
                System.err.println("Argh!  Convert.pushout() FAILED! (m match is corrupt)");
                return null;
            }
            Link l2 = (Link)hash.get(graphObject);
            l2.link((Link)hash.get(img1)).link((Link)hash.get(img2));
        }
        empty = empty.find();
        int n = G3.getTypeSet().getLevelOfTypeGraphCheck();
        if (this.setEnabledTG) {
            G3.getTypeSet().setLevelOfTypeGraphCheck(10);
        }
        int k = 0;
        while (k < 2) {
            morph = k == 0 ? p1 : p2;
            for (Node n2 : morph.getOriginal().getNodesSet()) {
                l = ((Link)hash.get(n2)).find();
                if (l == empty) continue;
                Node n22 = (Node)l.get();
                if (n22 == null) {
                    block34: {
                        try {
                            n22 = G3.copyNode(n2);
                            n22.setContextUsage(n2.getContextUsage());
                            if (!this.checkAttributeValue(n2, n22)) break block34;
                            try {
                                morph.addMapping(n2, n22);
                            }
                            catch (BadMappingException ex1) {
                                this.error = ex1.getLocalizedMessage();
                                return null;
                            }
                        }
                        catch (TypeException ex) {
                            this.error = ex.getLocalizedMessage();
                            return null;
                        }
                    }
                    l.set(n22);
                    continue;
                }
                if (!this.checkAttributeValue(n2, n22)) continue;
                try {
                    morph.addMapping(n2, n22);
                }
                catch (BadMappingException ex1) {
                    this.error = ex1.getLocalizedMessage();
                    return null;
                }
            }
            ++k;
        }
        k = 0;
        while (k < 2) {
            morph = k == 0 ? p1 : p2;
            for (Arc a : morph.getOriginal().getArcsSet()) {
                l = ((Link)hash.get(a)).find();
                if (l == empty) continue;
                Arc a2 = (Arc)l.get();
                if (a2 == null) {
                    block35: {
                        GraphObject src = morph.getImage(a.getSource());
                        GraphObject tgt = morph.getImage(a.getTarget());
                        if (src == null || tgt == null) continue;
                        try {
                            a2 = G3.copyArc(a, (Node)src, (Node)tgt);
                            a2.setContextUsage(a.getContextUsage());
                            if (!this.checkAttributeValue(a, a2)) break block35;
                            try {
                                morph.addMapping(a, a2);
                            }
                            catch (BadMappingException ex1) {
                                this.error = ex1.getLocalizedMessage();
                                return null;
                            }
                        }
                        catch (TypeException e) {
                            this.error = e.getLocalizedMessage();
                            return null;
                        }
                    }
                    l.set(a2);
                    continue;
                }
                if (!this.checkAttributeValue(a, a2)) continue;
                try {
                    morph.addMapping(a, a2);
                }
                catch (BadMappingException ex1) {
                    this.error = ex1.getLocalizedMessage();
                    return null;
                }
            }
            ++k;
        }
        G3.getTypeSet().setLevelOfTypeGraphCheck(n);
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(p1, p2);
    }

    public String getErrorMsg() {
        return this.error;
    }

    public Vector<Object> convert() {
        Vector<Object> ret = new Vector<Object>();
        if (!this.atom.isValid()) {
            return ret;
        }
        this.atom.adoptEntriesWhereEmpty();
        this.renameVariables(this.rule, this.atom);
        Graph R = this.rule.getRight();
        boolean leftgraph = true;
        boolean disjunion = true;
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> all_s = null;
        all_s = MatchHelper.getOverlappings(this.atom, R, leftgraph, disjunion);
        while (all_s.hasMoreElements()) {
            ValueMember mimg;
            ValueMember m;
            int i;
            ValueTuple valimg;
            ValueTuple val;
            GraphObject img;
            GraphObject o;
            Pair<OrdinaryMorphism, OrdinaryMorphism> morphs = all_s.nextElement();
            OrdinaryMorphism p = (OrdinaryMorphism)morphs.first;
            OrdinaryMorphism s = (OrdinaryMorphism)morphs.second;
            if (!p.isInjective()) continue;
            Enumeration<GraphObject> e = p.getDomain();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (o.getAttribute() == null) continue;
                img = p.getImage(o);
                val = (ValueTuple)o.getAttribute();
                valimg = (ValueTuple)img.getAttribute();
                i = 0;
                while (i < val.getSize()) {
                    m = val.getValueMemberAt(i);
                    mimg = valimg.getValueMemberAt(i);
                    if (mimg.getExpr() != null && mimg.getExpr().isComplex()) {
                        if (m.getExpr() != null) {
                            if (m.getExpr().isVariable() || m.getExpr().isConstant()) {
                                mimg.setExprAsText(m.getExprAsText());
                                mimg.setTransient(true);
                            } else if (m.getExpr().isComplex()) {
                                mimg.setExpr(null);
                            }
                        } else {
                            mimg.setExpr(null);
                        }
                    }
                    ++i;
                }
            }
            e = s.getDomain();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (o.getAttribute() == null) continue;
                img = s.getImage(o);
                val = (ValueTuple)o.getAttribute();
                valimg = (ValueTuple)img.getAttribute();
                i = 0;
                while (i < val.getSize()) {
                    m = val.getValueMemberAt(i);
                    mimg = valimg.getValueMemberAt(i);
                    if (mimg.getExpr() != null && mimg.getExpr().isComplex()) {
                        if (m.getExpr() != null) {
                            if (m.getExpr().isVariable() || m.getExpr().isConstant()) {
                                mimg.setExprAsText(m.getExprAsText());
                            } else if (m.getExpr().isComplex()) {
                                mimg.setExpr(null);
                            }
                        } else {
                            mimg.setExpr(null);
                        }
                    }
                    ++i;
                }
            }
            OrdinaryMorphism pmatch = BaseFactory.theFactory().createMorphfromMorph(p, this.atom.getAttrContext());
            if (pmatch == null) continue;
            Vector<Object> v = new Vector<Object>();
            EvalSet set = null;
            Enumeration<AtomConstraint> conclusions = this.atom.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint conclusion = conclusions.nextElement();
                this.adoptEntriesWhereEmpty(pmatch);
                Pair<OrdinaryMorphism, OrdinaryMorphism> po = this.pushout(conclusion, pmatch);
                if (po == null) continue;
                OrdinaryMorphism t = (OrdinaryMorphism)po.first;
                OrdinaryMorphism q = (OrdinaryMorphism)po.second;
                if (!t.isTotal() || !q.isTotal()) continue;
                t.setAttrContext(conclusion.getAttrContext());
                this.adoptEntriesWhereEmpty(t);
                v.add(new AtomApplCond(conclusion, s, t, q));
            }
            if (v.isEmpty()) continue;
            set = new EvalSet(v);
            ret.add(set);
        }
        return ret;
    }

    private boolean checkAttributeValue(GraphObject from, GraphObject to) {
        if (from.getAttribute() == null && to.getAttribute() == null) {
            return true;
        }
        if (from.getAttribute() != null && to.getAttribute() != null) {
            ValueTuple valueFrom = (ValueTuple)from.getAttribute();
            ValueTuple valueTo = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < valueFrom.getSize()) {
                ValueMember mFrom = valueFrom.getValueMemberAt(i);
                ValueMember mTo = valueTo.getValueMemberAt(i);
                if (mFrom.isSet() && mTo.isSet() && (mFrom.getExpr().isConstant() || mTo.getExpr().isConstant()) && !mFrom.getExprAsText().equals(mTo.getExprAsText())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph) {
        Enumeration<GraphObject> e = morph.getDomain();
        while (e.hasMoreElements()) {
            ContextView context;
            Vector<TupleMapping> mappings;
            GraphObject obj = e.nextElement();
            GraphObject img = morph.getImage(obj);
            if (img.getAttribute() == null || (mappings = (context = (ContextView)morph.getAttrContext()).getMappingsToTarget((ValueTuple)img.getAttribute())) == null) continue;
            mappings.elementAt(0).adoptEntriesWhereEmpty((ValueTuple)obj.getAttribute(), (ValueTuple)img.getAttribute());
        }
    }

    private void renameVariables(Rule r, AtomConstraint atomic) {
        Rule m1 = r;
        Enumeration<AtomConstraint> conclusions = atomic.getConclusions();
        if (conclusions.hasMoreElements()) {
            OrdinaryMorphism m2 = conclusions.nextElement();
            int index = 1;
            String mark = String.valueOf(index);
            VarTuple varsm1 = (VarTuple)m1.getAttrContext().getVariables();
            VarTuple varsm2 = (VarTuple)m2.getAttrContext().getVariables();
            int i = 0;
            while (i < varsm1.getSize()) {
                VarMember vm1 = varsm1.getVarMemberAt(i);
                VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
                if (vm2 != null && vm1.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName())) {
                    String from = vm2.getName();
                    String to = String.valueOf(vm2.getName()) + mark;
                    while (varsm2.getVarMemberAt(to) != null) {
                        mark = String.valueOf(index++);
                        to = String.valueOf(vm2.getName()) + mark;
                    }
                    vm2.getDeclaration().setName(to);
                    this.setAttributeVariable(from, to, varsm2, m2.getSource().getNodesSet().iterator());
                    this.setAttributeVariable(from, to, varsm2, m2.getSource().getArcsSet().iterator());
                    this.setAttributeVariable(from, to, varsm2, m2.getTarget().getNodesSet().iterator());
                    this.setAttributeVariable(from, to, varsm2, m2.getTarget().getArcsSet().iterator());
                    CondTuple conds = (CondTuple)m2.getAttrContext().getConditions();
                    this.renameVariableInCondition(conds, from, to);
                    while (conclusions.hasMoreElements()) {
                        OrdinaryMorphism mc = conclusions.nextElement();
                        VarTuple varsmc = (VarTuple)mc.getAttrContext().getVariables();
                        this.setAttributeVariable(from, to, varsmc, mc.getTarget().getNodesSet().iterator());
                        this.setAttributeVariable(from, to, varsmc, mc.getTarget().getArcsSet().iterator());
                        conds = (CondTuple)mc.getAttrContext().getConditions();
                        this.renameVariableInCondition(conds, from, to);
                    }
                }
                ++i;
            }
        }
    }

    private void renameVariableInCondition(CondTuple conds, String from, String to) {
        int j = 0;
        while (j < conds.getSize()) {
            CondMember cm = conds.getCondMemberAt(j);
            Vector<String> v1 = cm.getAllVariables();
            if (v1.contains(from)) {
                JexExpr oldExpr = (JexExpr)cm.getExpr();
                Vector<String> variables = new Vector<String>();
                oldExpr.getAllVariables(variables);
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, null);
            }
            ++j;
        }
    }

    private void setAttributeVariable(String from, String to, VarTuple vars, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            ValueTuple fromObj = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < fromObj.getSize()) {
                ValueMember fromVM = fromObj.getValueMemberAt(i);
                if (fromVM.isSet()) {
                    if (fromVM.getExpr().isVariable()) {
                        if (fromVM.getExprAsText().equals(from) && vars.getVarMemberAt(to) != null) {
                            fromVM.setExprAsText(to);
                        }
                    } else if (fromVM.getExpr().isComplex()) {
                        JexExpr oldExpr = (JexExpr)fromVM.getExpr();
                        Vector<String> variables = new Vector<String>();
                        oldExpr.getAllVariables(variables);
                        this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, vars);
                    }
                }
                ++i;
            }
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, VarTuple vars) {
        int j = 0;
        while (j < node.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(j);
            if (n instanceof ASTPrimaryExpression) {
                int j1 = 0;
                while (j1 < n.jjtGetNumChildren()) {
                    SimpleNode n1 = (SimpleNode)n.jjtGetChild(j1);
                    if (n1 instanceof ASTExpression) {
                        this.findPrimaryAndReplace(n1, from, to, vars);
                    }
                    ++j1;
                }
                if (n.getString().equals(from)) {
                    SimpleNode test;
                    HandlerExpr expression2;
                    HandlerType t;
                    VarMember vm;
                    SymbolTable symbs = SimpleNode.getSymbolTable();
                    boolean to_found = false;
                    ContextView context = (ContextView)symbs;
                    VarTuple vt = (VarTuple)context.getVariables();
                    int i = 0;
                    while (i < vt.getSize()) {
                        vm = vt.getVarMemberAt(i);
                        if (vm.getName().equals(to)) {
                            to_found = true;
                            t = vm.getDeclaration().getType();
                            try {
                                expression2 = vm.getHandler().newHandlerExpr(t, to);
                                test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                node.replaceChild(n, test);
                            }
                            catch (AttrHandlerException expression2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    if (!to_found && vars != null) {
                        i = 0;
                        while (i < vars.getSize()) {
                            vm = vars.getVarMemberAt(i);
                            if (vm.getName().equals(to)) {
                                to_found = true;
                                t = vm.getDeclaration().getType();
                                try {
                                    expression2 = vm.getHandler().newHandlerExpr(t, to);
                                    test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                    node.replaceChild(n, test);
                                }
                                catch (AttrHandlerException attrHandlerException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                        if (!to_found) {
                            System.out.println("Something wrong again:  " + to + "  NOT FOUND! CANNOT replace.");
                        }
                    }
                }
            } else {
                this.findPrimaryAndReplace(n, from, to, vars);
            }
            ++j;
        }
    }

    class Link {
        private Link up = null;
        private GraphObject o = null;

        public Link find() {
            Link l = this;
            while (l.up != null) {
                l = l.up;
            }
            Link m = this;
            while (m.up != null) {
                Link n = m.up;
                m.up = l;
                m = n;
            }
            return l;
        }

        public Link link(Link other) {
            Link pt;
            Link po = other.find();
            po.up = pt = this.find();
            return pt;
        }

        public GraphObject get() {
            return this.find().o;
        }

        public void set(GraphObject go) {
            this.find().o = go;
        }
    }
}

