/*
 * Decompiled with CFR 0.152.
 */
package agg.convert;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConverterXML {
    String sourceName;
    String ext;

    public boolean ggx2gxl(String filenameIn, String filenameOut, String srcName) {
        this.sourceName = srcName;
        return this.ggx2gxl(filenameIn, filenameOut);
    }

    public boolean ggx2gxl(String filenameIn, String filenameOut) {
        TransformerFactory tf = TransformerFactory.newInstance();
        Source templatesSrc = null;
        if (this.sourceName != null && !this.sourceName.equals("")) {
            templatesSrc = this.getTemplatesSource(this.sourceName);
        } else {
            URL url = ClassLoader.getSystemClassLoader().getResource("agg/convert/ggx2gxl.xsl");
            if (url != null) {
                templatesSrc = this.getTemplatesSource(url.getFile());
            }
        }
        if (templatesSrc == null) {
            System.out.println("agg.convert.ConverterXML.ggx2gxl:: source  'ggx2gxl.xsl'  NOT FOUND");
            return false;
        }
        Source src = this.getSource(".ggx", filenameIn);
        Result result = this.getResult(".gxl", filenameOut);
        if (src == null || result == null) {
            return false;
        }
        Templates templates = null;
        try {
            templates = tf.newTemplates(templatesSrc);
        }
        catch (TransformerConfigurationException ex1) {
            System.out.println(ex1.getMessage());
            return false;
        }
        Transformer transformer = null;
        try {
            transformer = templates.newTransformer();
            try {
                transformer.transform(src, result);
            }
            catch (TransformerException ex3) {
                System.out.println(ex3.getMessage());
                return false;
            }
        }
        catch (TransformerConfigurationException ex2) {
            System.out.println(ex2.getMessage());
            return false;
        }
        return true;
    }

    public boolean gxl2ggx(String filenameIn, String filenameOut, String srcName) {
        this.sourceName = srcName;
        return this.gxl2ggx(filenameIn, filenameOut);
    }

    public boolean gxl2ggx(String filenameIn, String filenameOut) {
        TransformerFactory tf = TransformerFactory.newInstance();
        Source templatesSrc = null;
        if (this.sourceName != null && !this.sourceName.equals("")) {
            templatesSrc = this.getTemplatesSource(this.sourceName);
        } else {
            URL url = ClassLoader.getSystemClassLoader().getResource("agg/convert/gxl2ggx.xsl");
            if (url != null) {
                templatesSrc = this.getTemplatesSource(url.getFile());
            }
        }
        if (templatesSrc == null) {
            System.out.println("agg.convert.ConverterXML.gxl2ggx:: source  'gxl2ggx.xsl'  NOT FOUND");
            return false;
        }
        Source src = this.getSource(".gxl", filenameIn);
        Result result = this.getResult(".ggx", filenameOut);
        System.out.println("result: " + result);
        if (src == null || result == null) {
            return false;
        }
        Templates templates = null;
        try {
            templates = tf.newTemplates(templatesSrc);
        }
        catch (TransformerConfigurationException ex1) {
            System.out.println("TransformerConfigurationException. " + ex1.getMessage());
            return false;
        }
        Transformer transformer = null;
        try {
            transformer = templates.newTransformer();
            try {
                transformer.transform(src, result);
            }
            catch (TransformerException ex3) {
                System.out.println(ex3.getMessage());
                return false;
            }
        }
        catch (TransformerConfigurationException ex2) {
            System.out.println(ex2.getMessage());
            return false;
        }
        return true;
    }

    public boolean gts2gtxl(String filenameIn, String filenameOut, String srcName) {
        this.sourceName = srcName;
        return this.gts2gtxl(filenameIn, filenameOut);
    }

    public boolean gts2gtxl(String filenameIn, String filenameOut) {
        TransformerFactory tf = TransformerFactory.newInstance();
        Source templatesSrc = null;
        if (this.sourceName != null && !this.sourceName.equals("")) {
            templatesSrc = this.getTemplatesSource(this.sourceName);
        } else {
            URL url = ClassLoader.getSystemClassLoader().getResource("agg/convert/gts2gtxl.xsl");
            if (url != null) {
                templatesSrc = this.getTemplatesSource(url.getFile());
            }
        }
        if (templatesSrc == null) {
            System.out.println("agg.convert.ConverterXML.gts2gtxl:: source  'gts2gtxl.xsl'  NOT FOUND");
            return false;
        }
        Source src = this.getSource(".ggx", filenameIn);
        Result result = this.getResult(".gtxl", filenameOut);
        if (src == null || result == null) {
            return false;
        }
        Templates templates = null;
        try {
            templates = tf.newTemplates(templatesSrc);
        }
        catch (TransformerConfigurationException ex1) {
            System.out.println(ex1.getMessage());
            return false;
        }
        Transformer transformer = null;
        try {
            transformer = templates.newTransformer();
            try {
                transformer.transform(src, result);
            }
            catch (TransformerException ex3) {
                System.out.println(ex3.getMessage());
                return false;
            }
        }
        catch (TransformerConfigurationException ex2) {
            System.out.println(ex2.getMessage());
            return false;
        }
        return true;
    }

    public boolean gtxl2gts(String filenameIn, String filenameOut, String srcName) {
        return false;
    }

    public boolean gtxl2gts(String filenameIn, String filenameOut) {
        return false;
    }

    public boolean omondoxmi2ggx(String filenameIn, String filenameOut, String sourceNameGXL, String sourceNameGGX) {
        String name = filenameIn.substring(0, filenameIn.lastIndexOf(46));
        System.out.println(name);
        String filenameOutGXL = String.valueOf(name) + "_ecore.gxl";
        TransformerFactory tf = TransformerFactory.newInstance();
        Source templatesSrcGXL = null;
        if (sourceNameGXL != null && !sourceNameGXL.equals("")) {
            templatesSrcGXL = this.getTemplatesSource(sourceNameGXL);
        } else {
            URL url = ClassLoader.getSystemClassLoader().getResource("agg/convert/omondoxmi2gxl.xsl");
            if (url != null) {
                templatesSrcGXL = this.getTemplatesSource(url.getFile());
            }
        }
        if (templatesSrcGXL == null) {
            System.out.println("agg.convert.ConverterXML.omondoxmi2gxl:: template source  'omondoxmi2gxl.xsl'  NOT FOUND");
            return false;
        }
        Source templatesSrcGGX = null;
        if (sourceNameGGX != null && !sourceNameGGX.equals("")) {
            templatesSrcGGX = this.getTemplatesSource(sourceNameGGX);
        } else {
            URL url = ClassLoader.getSystemResource("agg/convert/gxl2ggx.xsl");
            templatesSrcGGX = this.getTemplatesSource(url.getFile());
        }
        if (templatesSrcGGX == null) {
            System.out.println("agg.convert.ConverterXML.omondoxmi2gxl:: template source  'gxl2ggx.xsl'  NOT FOUND");
            return false;
        }
        Source src = this.getSource(".ecore", filenameIn);
        this.ext = src != null ? ".ecore" : "";
        Result result = this.getResult(".gxl", filenameOutGXL);
        if (src == null || result == null) {
            return false;
        }
        Templates templates = null;
        try {
            templates = tf.newTemplates(templatesSrcGXL);
        }
        catch (TransformerConfigurationException ex1) {
            System.out.println("agg.convert.ConverterXML.omondoxmi2gxl:: TransformerConfigurationException\n" + ex1.getLocalizedMessage());
            return false;
        }
        Transformer transformer = null;
        try {
            transformer = templates.newTransformer();
            transformer.transform(src, result);
        }
        catch (TransformerException ex3) {
            System.out.println("agg.convert.ConverterXML.omondoxmi2gxl:: TransformerException:\n" + ex3.getLocalizedMessage());
            return false;
        }
        return this.gxl2ggx(filenameOutGXL, filenameOut, sourceNameGGX);
    }

    public String getFileExtOfImport() {
        return this.ext;
    }

    public File copyFile(String dirName, String fileName) {
        try {
            InputStream fis = this.getClass().getResourceAsStream("/agg/convert/" + fileName);
            File outFile = new File(String.valueOf(dirName) + fileName);
            outFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(outFile);
            byte[] buffer = new byte[65536];
            try {
                int length;
                while ((length = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, length);
                }
                fis.close();
                fos.close();
                return outFile;
            }
            catch (IOException iOException) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        System.out.println("agg.convert.ConverterXML.copyFile:: source  " + fileName + "  NOT FOUND");
        return null;
    }

    private Source getTemplatesSource(String filename) {
        File f = new File(filename);
        StreamSource stream = new StreamSource(f);
        return stream;
    }

    private Source getSource(String filter, String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        StreamSource stream = new StreamSource(f);
        return stream;
    }

    private Result getResult(String filter, String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ex) {
                return null;
            }
        }
        StreamResult stream = new StreamResult(f);
        return stream;
    }
}

