/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.termination;

import agg.gui.IconResource;
import agg.gui.help.HtmlBrowser;
import agg.gui.termination.LayerTerminationCondTable;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.termination.TerminationLGTSInterface;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.xt_basis.Arc;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.RulePriority;
import agg.xt_basis.Type;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class TerminationDialog
extends JDialog
implements ActionListener {
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JPanel creationPanel;
    private JScrollPane creationScrollPane;
    private JTable creationTable;
    private JPanel deletionPanel;
    private JScrollPane deletionScrollPane;
    private JTable deletionTable;
    private JButton checkButton;
    JCheckBox generateCB;
    private JButton helpButton;
    private JButton closeButton;
    private JButton resetButton;
    private JButton acceptButton;
    private JButton moreButton;
    private JPanel contentPane;
    private JLabel statusLabel;
    private TerminationLGTSInterface terminationLGTS;
    boolean generateRuleLayer;
    private JPanel rcdPanel0;
    private boolean all;
    private boolean terminate;
    private LayerTerminationCondTable tableLTC;
    private HtmlBrowser helpBrowser;
    private boolean priority;
    private static final Icon OK_ICON = IconResource.getIconFromURL(IconResource.getOkIcon());
    private static final Icon WRONG_ICON = IconResource.getIconFromURL(IconResource.getWrongIcon());
    protected GraGraTreeView treeView;

    public TerminationDialog(JFrame parent, GraGraTreeView treeView, TerminationLGTSInterface termination) {
        super((Frame)parent, false);
        this.treeView = treeView;
        this.setTitle("Termination of LGTS");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TerminationDialog.this.exitForm(evt);
            }
        });
        this.setBackground(Color.lightGray);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
            this.setLocation(50, 50);
        } else {
            this.setLocation(50, 50);
        }
        this.priority = termination.getGrammar().trafoByPriority();
        this.terminationLGTS = termination;
        this.initComponents();
        this.terminate = false;
        JScrollPane scroll = new JScrollPane(this.contentPane);
        scroll.setPreferredSize(new Dimension(400, 450));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(scroll);
        this.validate();
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    public void init(TerminationLGTSInterface termination) {
        if (this.terminationLGTS != termination) {
            this.terminationLGTS = termination;
            this.initComponents();
        } else {
            this.reinit();
        }
        this.terminate = false;
        this.statusLabel.setIcon(WRONG_ICON);
    }

    public void reinit() {
        this.reinitComponents();
        this.terminate = false;
        this.statusLabel.setIcon(WRONG_ICON);
    }

    public void reinit(TerminationLGTSInterface termination) {
        this.terminationLGTS = termination;
        this.reinitComponents();
        this.terminate = false;
        this.statusLabel.setIcon(WRONG_ICON);
    }

    private void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        JPanel rcdPanel = new JPanel(new BorderLayout());
        this.rcdPanel0 = new JPanel(gridbag);
        this.rulePanel = new JPanel();
        this.rulePanel.setBackground(Color.orange);
        this.ruleScrollPane = new JScrollPane();
        this.rulePanel.setVisible(true);
        this.creationPanel = new JPanel();
        this.creationPanel.setLayout(new BorderLayout());
        this.creationPanel.setBackground(Color.orange);
        this.creationScrollPane = new JScrollPane();
        this.deletionPanel = new JPanel();
        this.deletionPanel.setLayout(new BorderLayout());
        this.deletionPanel.setBackground(Color.orange);
        this.deletionScrollPane = new JScrollPane();
        this.checkButton = new JButton();
        this.closeButton = new JButton();
        this.resetButton = new JButton();
        this.acceptButton = new JButton();
        this.moreButton = new JButton();
        this.moreButton.setEnabled(false);
        this.helpButton = new JButton();
        this.statusLabel = new JLabel();
        this.rulePanel.setLayout(new BorderLayout());
        if (this.priority) {
            this.rulePanel.setBorder(new TitledBorder("Rule Priority"));
            this.ruleTable = new JTable(new HashTableModel(new RulePriority(this.terminationLGTS.getListOfRules()), new String[]{"  Rule  ", "  Priority  "}));
        } else {
            this.rulePanel.setBorder(new TitledBorder("Rule Layer"));
            this.ruleTable = new JTable(new HashTableModel(new RuleLayer(this.terminationLGTS.getListOfRules()), new String[]{"  Rule  ", "  Layer  "}));
        }
        this.ruleTable.doLayout();
        int h = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight());
        this.ruleScrollPane.setViewportView(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, h));
        this.rulePanel.add(this.ruleScrollPane);
        Hashtable<Object, Integer> creationTypeTable = new Hashtable<Object, Integer>();
        creationTypeTable.putAll(this.terminationLGTS.getCreationLayer());
        this.creationTable = new JTable();
        if (this.priority) {
            this.creationPanel.setBorder(new TitledBorder("Creation Priority Layer"));
            this.creationTable.setModel(new HashTableModel(creationTypeTable, new String[]{"  Type  ", "  Priority  "}));
        } else {
            this.creationPanel.setBorder(new TitledBorder("Creation Layer"));
            this.creationTable.setModel(new HashTableModel(creationTypeTable, new String[]{"  Type  ", "  Layer  "}));
        }
        this.creationTable.doLayout();
        this.creationTable.setEnabled(false);
        this.creationScrollPane.setViewportView(this.creationTable);
        this.creationScrollPane.setPreferredSize(new Dimension(200, 150));
        this.creationPanel.add(this.creationScrollPane);
        Hashtable<Object, Integer> deletionTypeTable = new Hashtable<Object, Integer>();
        deletionTypeTable.putAll(this.terminationLGTS.getDeletionLayer());
        this.deletionTable = new JTable();
        if (this.priority) {
            this.deletionPanel.setBorder(new TitledBorder("Deletion Priority Layer"));
            this.deletionTable.setModel(new HashTableModel(deletionTypeTable, new String[]{"  Type  ", "  Priority  "}));
        } else {
            this.deletionPanel.setBorder(new TitledBorder("Deletion Layer"));
            this.deletionTable.setModel(new HashTableModel(deletionTypeTable, new String[]{"  Type  ", "  Layer  "}));
        }
        this.deletionTable.doLayout();
        this.deletionTable.setEnabled(false);
        this.deletionScrollPane.setViewportView(this.deletionTable);
        this.deletionScrollPane.setPreferredSize(new Dimension(200, 150));
        this.deletionPanel.add(this.deletionScrollPane);
        this.constrainBuild(this.rcdPanel0, this.rulePanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.all = false;
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText("Are termination criteria satisfied?");
        this.statusLabel.setIcon(WRONG_ICON);
        this.statusLabel.setIconTextGap(5);
        try {
            this.statusLabel.setHorizontalTextPosition(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JLabel emptyLabel0 = new JLabel("               ");
        statusPanel.add((Component)this.statusLabel, "Center");
        statusPanel.add((Component)emptyLabel0, "South");
        rcdPanel.add((Component)statusPanel, "South");
        rcdPanel.add(this.rcdPanel0);
        JPanel checkPanel = new JPanel(new BorderLayout());
        JPanel genPanel = new JPanel(new BorderLayout());
        genPanel.setBorder(new TitledBorder(""));
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1));
        this.generateCB = new JCheckBox("generate rule layer", null, false);
        checkBoxPanel.add(this.generateCB);
        this.generateCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TerminationDialog.this.generateRuleLayer = TerminationDialog.this.generateCB.isSelected();
            }
        });
        JLabel layerLabel = new JLabel("  Creation / Deletion type layer will be generated automatically  ");
        checkBoxPanel.add(layerLabel);
        genPanel.add((Component)checkBoxPanel, "Center");
        JLabel emptyLabel = new JLabel("               ");
        checkPanel.add((Component)emptyLabel, "Center");
        checkPanel.add((Component)genPanel, "North");
        JPanel buttonPanel = new JPanel(new GridLayout(0, 4, 5, 5));
        this.checkButton.setActionCommand("check");
        this.checkButton.setText("Check");
        this.checkButton.setToolTipText(" Check layer function ");
        this.checkButton.addActionListener(this);
        this.resetButton.setActionCommand("reset");
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(this);
        this.acceptButton.setActionCommand("accept");
        this.acceptButton.setText("Accept");
        this.acceptButton.addActionListener(this);
        this.moreButton.setActionCommand("more");
        this.moreButton.setText("More Info");
        this.moreButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(this);
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        buttonPanel.add(this.checkButton);
        buttonPanel.add(this.moreButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(this.acceptButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.helpButton);
        checkPanel.add((Component)buttonPanel, "South");
        this.contentPane.add(rcdPanel);
        this.contentPane.add((Component)checkPanel, "South");
        this.contentPane.revalidate();
    }

    private void reinitComponents() {
        this.ruleScrollPane.setViewportView(null);
        this.ruleTable = this.priority ? new JTable(new HashTableModel(new RulePriority(this.terminationLGTS.getListOfRules()), new String[]{"  Rule  ", "  Priority  "})) : new JTable(new HashTableModel(new RuleLayer(this.terminationLGTS.getListOfRules()), new String[]{"  Rule  ", "  Layer  "}));
        this.ruleTable.doLayout();
        int h = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight());
        this.ruleScrollPane.setViewportView(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, h));
        this.creationScrollPane.setViewportView(null);
        Hashtable<Object, Integer> creationTypeTable = new Hashtable<Object, Integer>();
        creationTypeTable.putAll(this.terminationLGTS.getCreationLayer());
        this.creationTable = new JTable();
        if (this.priority) {
            this.creationTable.setModel(new HashTableModel(creationTypeTable, new String[]{"  Type  ", "  Priority  "}));
        } else {
            this.creationTable.setModel(new HashTableModel(creationTypeTable, new String[]{"  Type  ", "  Layer  "}));
        }
        this.creationTable.doLayout();
        this.creationTable.setEnabled(false);
        this.creationScrollPane.setViewportView(this.creationTable);
        this.deletionScrollPane.setViewportView(null);
        Hashtable<Object, Integer> deletionTypeTable = new Hashtable<Object, Integer>();
        deletionTypeTable.putAll(this.terminationLGTS.getDeletionLayer());
        this.deletionTable = new JTable();
        if (this.priority) {
            this.deletionTable.setModel(new HashTableModel(deletionTypeTable, new String[]{"  Type  ", "  Priority  "}));
        } else {
            this.deletionTable.setModel(new HashTableModel(deletionTypeTable, new String[]{"  Type  ", "  Layer  "}));
        }
        this.deletionTable.doLayout();
        this.deletionTable.setEnabled(false);
        this.deletionScrollPane.setViewportView(this.deletionTable);
        this.contentPane.revalidate();
        this.validate();
        this.pack();
    }

    protected void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        if (this.terminationLGTS.hasGrammarChanged()) {
            this.reinit();
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.checkButton) {
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
                this.tableLTC.dispose();
                this.tableLTC = null;
            }
            this.terminationLGTS.initRuleLayer(((HashTableModel)this.ruleTable.getModel()).getTable());
            if (!this.terminate) {
                this.terminationLGTS.setGenerateRuleLayer(this.generateRuleLayer);
                this.terminate = this.terminationLGTS.checkTermination();
                if (this.terminate) {
                    this.terminate = this.terminationLGTS.isValid();
                }
            }
            if (this.terminate) {
                Object t;
                int l;
                if (!this.all) {
                    this.ruleTable.doLayout();
                    int h = this.getHeight(this.creationTable.getRowCount(), this.creationTable.getRowHeight());
                    this.creationPanel.setPreferredSize(new Dimension(200, h));
                    this.creationTable.doLayout();
                    h = this.getHeight(this.deletionTable.getRowCount(), this.deletionTable.getRowHeight());
                    this.deletionPanel.setPreferredSize(new Dimension(200, h));
                    this.deletionTable.doLayout();
                    this.constrainBuild(this.rcdPanel0, this.creationPanel, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.constrainBuild(this.rcdPanel0, this.deletionPanel, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.setSize(this.getWidth(), this.getHeight() + 2 * h + 50);
                    this.validate();
                    this.all = true;
                }
                HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
                int i = 0;
                while (i < htm.getRowCount()) {
                    Object r = htm.getRuleAt(i, 0);
                    if (r instanceof Rule && this.generateRuleLayer) {
                        l = this.terminationLGTS.getRuleLayer((Rule)r);
                        htm.setValueAt(String.valueOf(l), i, 1);
                    }
                    ++i;
                }
                htm = (HashTableModel)this.creationTable.getModel();
                i = 0;
                while (i < htm.getRowCount()) {
                    t = htm.getTypeAt(i, 0);
                    if (t instanceof Type) {
                        l = this.terminationLGTS.getCreationLayer((Type)t);
                        htm.setValueAt(String.valueOf(l), i, 1);
                    } else if (t instanceof GraphObject) {
                        l = this.terminationLGTS.getCreationLayer((GraphObject)t);
                        htm.setValueAt(String.valueOf(l), i, 1);
                    }
                    ++i;
                }
                htm = (HashTableModel)this.deletionTable.getModel();
                i = 0;
                while (i < htm.getRowCount()) {
                    t = htm.getTypeAt(i, 0);
                    if (t instanceof Type) {
                        l = this.terminationLGTS.getDeletionLayer((Type)t);
                        htm.setValueAt(String.valueOf(l), i, 1);
                    } else if (t instanceof GraphObject) {
                        l = this.terminationLGTS.getDeletionLayer((GraphObject)t);
                        htm.setValueAt(String.valueOf(l), i, 1);
                    }
                    ++i;
                }
                this.statusLabel.setIcon(OK_ICON);
            } else {
                this.statusLabel.setIcon(WRONG_ICON);
                String errorMsg = this.terminationLGTS.getErrorMessage();
                if (errorMsg.length() == 0) {
                    errorMsg = "Termination conditions could not be checked.";
                }
                JOptionPane.showMessageDialog(null, errorMsg, "  Termination check failed ", 0);
            }
            this.moreButton.setEnabled(true);
        } else if (source == this.closeButton) {
            if (this.terminationLGTS.isValid()) {
                HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
                int i = 0;
                while (i < htm.getRowCount()) {
                    Object r = htm.getRuleAt(i, 0);
                    if (r instanceof Rule) {
                        Integer v = (Integer)htm.getValueAt(i, 1);
                        ((Rule)r).setLayer(v);
                    }
                    ++i;
                }
            }
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
                this.tableLTC.dispose();
                this.tableLTC = null;
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.resetButton) {
            if (this.generateRuleLayer) {
                this.terminationLGTS.initAll(this.generateRuleLayer);
            } else {
                this.terminationLGTS.resetLayer();
            }
            this.resetLayer();
            this.terminate = false;
            this.statusLabel.setIcon(WRONG_ICON);
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
                this.tableLTC.dispose();
                this.tableLTC = null;
            }
            this.moreButton.setEnabled(false);
        } else if (source == this.acceptButton) {
            this.terminationLGTS.saveRuleLayer();
            new GrammarTreeNode().refreshCurrentGraGra(this.treeView, this.treeView.getTreePathOfGrammar(this.treeView.getCurrentGraGra().getBasisGraGra()), this.treeView.getCurrentGraGra());
        } else if (source == this.moreButton) {
            if (this.tableLTC != null) {
                this.tableLTC.refreshView();
                this.tableLTC.setVisible(true);
            } else {
                this.tableLTC = new LayerTerminationCondTable(this.terminationLGTS);
                this.tableLTC.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
                this.tableLTC.showGUI();
            }
        } else if (source == this.helpButton) {
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(true);
            }
            if (this.helpBrowser == null) {
                this.helpBrowser = new HtmlBrowser("TerminationHelp.html");
                this.helpBrowser.setSize(500, 300);
                this.helpBrowser.setLocation(50, 50);
                this.helpBrowser.setVisible(true);
                this.helpBrowser.toFront();
            }
        }
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 3) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void resetLayer() {
        Object t;
        int l;
        HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
        int i = 0;
        while (i < htm.getRowCount()) {
            Object r = htm.getRuleAt(i, 0);
            l = this.terminationLGTS.getRuleLayer((Rule)r);
            htm.setValueAt(String.valueOf(l), i, 1);
            ++i;
        }
        htm = (HashTableModel)this.creationTable.getModel();
        i = 0;
        while (i < htm.getRowCount()) {
            t = htm.getTypeAt(i, 0);
            if (t instanceof Type) {
                l = this.terminationLGTS.getCreationLayer((Type)t);
                htm.setValueAt(String.valueOf(l), i, 1);
            } else if (t instanceof GraphObject) {
                l = this.terminationLGTS.getCreationLayer((GraphObject)t);
                htm.setValueAt(String.valueOf(l), i, 1);
            }
            ++i;
        }
        htm = (HashTableModel)this.deletionTable.getModel();
        i = 0;
        while (i < htm.getRowCount()) {
            t = htm.getTypeAt(i, 0);
            if (t instanceof Type) {
                l = this.terminationLGTS.getDeletionLayer((Type)t);
                htm.setValueAt(String.valueOf(l), i, 1);
            } else if (t instanceof GraphObject) {
                l = this.terminationLGTS.getDeletionLayer((GraphObject)t);
                htm.setValueAt(String.valueOf(l), i, 1);
            }
            ++i;
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable<Object, Integer> table;

        public HashTableModel(Hashtable<Object, Integer> table, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = table;
            Enumeration<Object> keys = table.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Integer value = table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = new Hashtable();
            this.table.putAll(layer.getRuleLayer());
            Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = layer.invertLayer();
            OrderedSet<Integer> ruleLayerSet = new OrderedSet<Integer>(new IntComparator());
            Enumeration<Integer> en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            Integer startLayer = layer.getStartLayer();
            int i2 = 0;
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet<Rule> rulesForLayer = invertedRuleLayer.get(currentLayer);
                for (Rule rule : rulesForLayer) {
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(rule.getLayer());
                    this.addRow(tmpVector);
                }
                if (++i2 < ruleLayerSet.size()) {
                    currentLayer = (Integer)ruleLayerSet.get(i2);
                    continue;
                }
                nextLayerExists = false;
            }
        }

        public HashTableModel(RulePriority priority, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = new Hashtable();
            this.table.putAll(priority.getRulePriority());
            Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = priority.invertPriority();
            OrderedSet<Integer> ruleLayerSet = new OrderedSet<Integer>(new IntComparator());
            Enumeration<Integer> en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            Integer startLayer = priority.getStartPriority();
            int i2 = 0;
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet<Rule> rulesForLayer = invertedRuleLayer.get(currentLayer);
                for (Rule rule : rulesForLayer) {
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(rule.getPriority());
                    this.addRow(tmpVector);
                }
                if (++i2 < ruleLayerSet.size()) {
                    currentLayer = (Integer)ruleLayerSet.get(i2);
                    continue;
                }
                nextLayerExists = false;
            }
        }

        public Hashtable<Object, Integer> getTable() {
            return this.table;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else if (result instanceof Type) {
                result = !((Type)result).getStringRepr().equals("") ? ((Type)result).getStringRepr() : "(unnamed)";
            } else if (result instanceof GraphObject) {
                GraphObject go = (GraphObject)result;
                result = go instanceof Node ? this.getTypeStringOfNode((Node)go) : this.getTypeStringOfEdge((Arc)go);
            }
            return result;
        }

        private String getTypeStringOfNode(Node go) {
            String s = go.getType().getStringRepr();
            if (s.equals("")) {
                s = "(unnamed)";
            }
            return s;
        }

        private String getTypeStringOfEdge(Arc go) {
            String s = this.getTypeStringOfNode((Node)go.getSource());
            s = s.concat("--");
            String s1 = go.getType().getStringRepr();
            if (s1.equals("")) {
                s1 = "(unnamed)";
            }
            s = s.concat(s1);
            s = s.concat("->");
            s = s.concat(this.getTypeStringOfNode((Node)go.getTarget()));
            return s;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = Integer.valueOf((String)aValue);
                super.setValueAt(i, row, column);
                this.table.put(key, i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Object getRuleAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                return result;
            }
            return null;
        }

        public Object getTypeAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof GraphObject) {
                return result;
            }
            if (result instanceof Type) {
                return result;
            }
            return null;
        }
    }
}

