/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrContext;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.csp.Constraint_InheritAttribute;
import agg.xt_basis.csp.Constraint_InheritType;
import agg.xt_basis.csp.Constraint_ObjectName;
import agg.xt_basis.csp.Constraint_Source;
import agg.xt_basis.csp.Constraint_SourceTarget;
import agg.xt_basis.csp.Constraint_Target;
import agg.xt_basis.csp.Constraint_TargetSource;
import agg.xt_basis.csp.Query_Incoming;
import agg.xt_basis.csp.Query_IncomingOutgoing;
import agg.xt_basis.csp.Query_Outgoing;
import agg.xt_basis.csp.Query_OutgoingIncoming;
import agg.xt_basis.csp.Query_Source;
import agg.xt_basis.csp.Query_SourceTarget;
import agg.xt_basis.csp.Query_Target;
import agg.xt_basis.csp.Query_TargetSource;
import agg.xt_basis.csp.Query_Type;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ALR_InheritCSP
extends CSP {
    private AttrContext itsAttrContext;
    private boolean directed = true;
    private final Dictionary<GraphObject, Variable> itsObjVarMap = new Hashtable<GraphObject, Variable>();
    private final Dictionary<String, HashSet<GraphObject>> itsTypeMap = new Hashtable<String, HashSet<GraphObject>>();

    public ALR_InheritCSP(Graph vargraph, AttrContext ac) {
        super(new Solution_Backjump(true));
        this.itsAttrContext = ac;
        this.directed = vargraph.getTypeSet().isArcDirected();
        this.buildConstraintGraph(vargraph);
    }

    public void clear() {
        this.itsSolver.clear();
        ((Hashtable)this.itsObjVarMap).clear();
    }

    private final synchronized void buildConstraintGraph(Graph vargraph) {
        Variable anObjVar;
        for (GraphObject graphObject : vargraph.getNodesSet()) {
            String keystr = graphObject.convertToKey();
            if (this.itsTypeMap.get(keystr) == null) {
                this.itsTypeMap.put(keystr, new LinkedHashSet());
            }
            anObjVar = new Variable();
            anObjVar.setKind(0);
            anObjVar.setGraphObject(graphObject);
            this.itsObjVarMap.put(graphObject, anObjVar);
        }
        for (GraphObject graphObject : vargraph.getArcsSet()) {
            String keystr = graphObject.convertToKey();
            if (this.itsTypeMap.get(keystr) == null) {
                this.itsTypeMap.put(keystr, new LinkedHashSet());
            }
            anObjVar = new Variable();
            anObjVar.setKind(1);
            anObjVar.setGraphObject(graphObject);
            this.itsObjVarMap.put(graphObject, anObjVar);
        }
        this.buildQueriesAndConstraints(this.itsObjVarMap.keys());
    }

    private void buildQueriesAndConstraints(Enumeration<GraphObject> anEnum) {
        while (anEnum.hasMoreElements()) {
            GraphObject anObj = anEnum.nextElement();
            Variable anObjVar = this.itsObjVarMap.get(anObj);
            Query query = new Query_Type(anObjVar);
            BinaryConstraint constraint = new Constraint_InheritType(anObj, anObjVar);
            query.setCorrespondent(constraint);
            if (anObj.getType().getAttrType() != null || anObj.getType().hasInheritedAttribute()) {
                new Constraint_InheritAttribute(anObj, anObjVar, this.itsAttrContext, AttrTupleManager.getDefaultManager());
            }
            if (!anObj.isArc()) continue;
            Variable aSrcObjVar = this.itsObjVarMap.get(((Arc)anObj).getSource());
            Variable aTarObjVar = this.itsObjVarMap.get(((Arc)anObj).getTarget());
            if (this.directed) {
                constraint = new Constraint_Source(aSrcObjVar, anObjVar);
                query = new Query_Outgoing(aSrcObjVar, anObjVar);
                query.setCorrespondent(constraint);
                query = new Query_Source(anObjVar, aSrcObjVar);
                query.setCorrespondent(constraint);
                constraint = new Constraint_Target(aTarObjVar, anObjVar);
                query = new Query_Incoming(aTarObjVar, anObjVar);
                query.setCorrespondent(constraint);
                query = new Query_Target(anObjVar, aTarObjVar);
                query.setCorrespondent(constraint);
                continue;
            }
            constraint = new Constraint_SourceTarget(aSrcObjVar, anObjVar);
            query = new Query_OutgoingIncoming(aSrcObjVar, anObjVar);
            query.setCorrespondent(constraint);
            query = new Query_SourceTarget(anObjVar, aSrcObjVar);
            query.setCorrespondent(constraint);
            constraint = new Constraint_TargetSource(aTarObjVar, anObjVar);
            query = new Query_IncomingOutgoing(aTarObjVar, anObjVar);
            query.setCorrespondent(constraint);
            query = new Query_TargetSource(anObjVar, aTarObjVar);
            query.setCorrespondent(constraint);
        }
    }

    @Override
    protected final synchronized void preprocessDomain(Object domaingraph) {
        this.resetTypeMap((Graph)domaingraph);
    }

    public AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    @Override
    public final Enumeration<Variable> getVariables() {
        return this.itsObjVarMap.elements();
    }

    public void enableAllVariables() {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject obj = keys.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            var.setEnabled(true);
        }
    }

    public boolean isDomainOfTypeEmpty(Type t) {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject go = keys.nextElement();
            if (go.isArc() || !go.getType().compareTo(t)) continue;
            Variable var = this.itsObjVarMap.get(go);
            return !var.hasNext();
        }
        return false;
    }

    public boolean isDomainOfTypeEmpty(Type t, Type src, Type tar) {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject go = keys.nextElement();
            if (go.isNode() || !go.getType().compareTo(t) || !((Arc)go).getSource().getType().compareTo(src) || !((Arc)go).getTarget().getType().compareTo(tar)) continue;
            Variable var = this.itsObjVarMap.get(go);
            return !var.hasNext();
        }
        return false;
    }

    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relatedVarMap) {
        this.itsSolver.setRelatedInstanceVarMap(relatedVarMap);
    }

    public Dictionary<Object, Variable> getInstanceVarMap() {
        return this.itsSolver.getInstanceVarMap();
    }

    @Override
    public final int getSize() {
        return this.itsObjVarMap.size();
    }

    @Override
    public final Variable getVariable(GraphObject obj) {
        return this.itsObjVarMap.get(obj);
    }

    @Override
    public void addObjectNameConstraint(GraphObject anObj) {
        Variable anObjVar = this.itsObjVarMap.get(anObj);
        if (anObjVar != null) {
            new Constraint_ObjectName(anObj, anObjVar);
        }
    }

    @Override
    public void removeObjectNameConstraint(GraphObject anObj) {
        Variable anObjVar = this.itsObjVarMap.get(anObj);
        if (anObjVar != null) {
            Enumeration<?> cons = anObjVar.getConstraints();
            while (cons.hasMoreElements()) {
                Object c = cons.nextElement();
                if (!(c instanceof Constraint_ObjectName)) continue;
                anObjVar.removeConstraint((Constraint_ObjectName)c);
            }
        }
    }

    protected void fillTypeMap(Graph domaingraph) {
        HashSet<GraphObject> anObjVec;
        String keystr;
        for (Node node : domaingraph.getNodesSet()) {
            keystr = node.convertToKey();
            if (node.getType().hasParent()) {
                Vector<Type> myParents = node.getType().getAllParents();
                int i = 0;
                while (i < myParents.size()) {
                    Type anObjType = myParents.get(i);
                    keystr = anObjType.convertToKey();
                    if (this.itsTypeMap.get(keystr) != null) {
                        HashSet<GraphObject> anObjVec2 = this.itsTypeMap.get(keystr);
                        anObjVec2.add(node);
                    }
                    ++i;
                }
                continue;
            }
            if (this.itsTypeMap.get(keystr) == null) continue;
            anObjVec = this.itsTypeMap.get(keystr);
            anObjVec.add(node);
        }
        for (Arc arc : domaingraph.getArcsSet()) {
            keystr = arc.convertToKey();
            if (arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
                Vector<Type> mySrcParents = arc.getSource().getType().getAllParents();
                Vector<Type> myTarParents = arc.getTarget().getType().getAllParents();
                int i = 0;
                while (i < mySrcParents.size()) {
                    int j = 0;
                    while (j < myTarParents.size()) {
                        keystr = String.valueOf(mySrcParents.get(i).convertToKey()) + arc.getType().convertToKey() + myTarParents.get(j).convertToKey();
                        if (this.itsTypeMap.get(keystr) != null) {
                            HashSet<GraphObject> anObjVec3 = this.itsTypeMap.get(keystr);
                            anObjVec3.add(arc);
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            if (this.itsTypeMap.get(keystr) == null) continue;
            anObjVec = this.itsTypeMap.get(keystr);
            anObjVec.add(arc);
        }
    }

    protected void resetTypeMap(Graph g) {
        Enumeration<GraphObject> lhsObjs = this.itsObjVarMap.keys();
        while (lhsObjs.hasMoreElements()) {
            GraphObject lhsobj = lhsObjs.nextElement();
            Variable var = this.itsObjVarMap.get(lhsobj);
            String key = lhsobj.convertToKey();
            if (g.getTypeObjectsMap().get(key) == null) {
                int i;
                LinkedHashSet<GraphObject> v = new LinkedHashSet<GraphObject>();
                if (lhsobj.isNode()) {
                    Vector<Type> parents = lhsobj.getType().getAllParents();
                    int p = 1;
                    while (p < parents.size()) {
                        Type pt = parents.get(p);
                        Vector<GraphObject> vp = g.getElementsOfTypeAsVector(pt);
                        i = 0;
                        while (i < vp.size()) {
                            if (!v.contains(vp.get(i))) {
                                v.add(vp.get(i));
                            }
                            ++i;
                        }
                        ++p;
                    }
                } else {
                    GraphObject src = ((Arc)lhsobj).getSource();
                    GraphObject tar = ((Arc)lhsobj).getTarget();
                    Vector<Type> src_parents = src.getType().getAllParents();
                    Vector<Type> tar_parents = tar.getType().getAllParents();
                    i = 0;
                    while (i < src_parents.size()) {
                        Type srcp = src_parents.get(i);
                        Vector<GraphObject> vsrcp = g.getElementsOfTypeAsVector(lhsobj.getType(), srcp, tar.getType());
                        int k = 0;
                        while (k < vsrcp.size()) {
                            if (!v.contains(vsrcp.get(k))) {
                                v.add(vsrcp.get(k));
                            }
                            ++k;
                        }
                        int j = 0;
                        while (j < tar_parents.size()) {
                            Type tarp = tar_parents.get(j);
                            Vector<GraphObject> vtarp = g.getElementsOfTypeAsVector(lhsobj.getType(), srcp, tarp);
                            int l = 0;
                            while (l < vtarp.size()) {
                                if (!v.contains(vtarp.get(l))) {
                                    v.add(vtarp.get(l));
                                }
                                ++l;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                g.getTypeObjectsMap().put(key, v);
            }
            this.itsTypeMap.put(key, g.getTypeObjectsMap().get(key));
            var.getTypeQuery().setObjects(g.getTypeObjectsMap().get(key));
        }
    }

    protected void resetTypeMap(Hashtable<String, HashSet<GraphObject>> aTypeMap) {
        Enumeration<GraphObject> lhsObjs = this.itsObjVarMap.keys();
        while (lhsObjs.hasMoreElements()) {
            GraphObject obj = lhsObjs.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            String key = obj.convertToKey();
            HashSet<GraphObject> list = aTypeMap.get(key);
            if (list == null) {
                list = new LinkedHashSet<GraphObject>();
                aTypeMap.put(key, list);
            }
            this.itsTypeMap.put(key, list);
            var.getTypeQuery().setObjects(list);
        }
    }

    protected void reinitializeSolver(boolean doUpdateQueries) {
        this.itsSolver.reinitialize(doUpdateQueries);
    }

    protected void resetSolver(boolean doUpdateQueries) {
        this.resetSolverVariables();
        this.itsSolver.reinitialize(doUpdateQueries);
    }

    protected void resetSolverVariables() {
        Enumeration<GraphObject> lhsObjs = this.itsObjVarMap.keys();
        while (lhsObjs.hasMoreElements()) {
            GraphObject obj = lhsObjs.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            var.setInstance(null);
        }
    }

    protected void resetVariableDomain(boolean resetByNull) {
        if (resetByNull) {
            Enumeration<Variable> cspVars = this.itsObjVarMap.elements();
            while (cspVars.hasMoreElements()) {
                cspVars.nextElement().setInstance(null);
            }
        }
        this.unsetAttrContextVariable();
    }

    protected void resetVariableDomain(GraphObject go) {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject obj = keys.nextElement();
            if (obj != go) continue;
            Variable var = this.itsObjVarMap.get(obj);
            this.itsSolver.reinitialize(var);
            var.setInstance(null);
            return;
        }
        this.unsetAttrContextVariable(go);
    }

    protected void unsetAttrContextVariable() {
        VarTuple varTuple = (VarTuple)this.itsAttrContext.getVariables();
        int i = 0;
        while (i < varTuple.getSize()) {
            VarMember vm = varTuple.getVarMemberAt(i);
            if (vm != null) {
                vm.setExpr(null);
            }
            ++i;
        }
    }

    protected void unsetAttrContextVariable(GraphObject go) {
        if (go.getAttribute() == null) {
            return;
        }
        Vector<String> attrVars = ((ValueTuple)go.getAttribute()).getAllVariableNames();
        VarTuple varTup = (VarTuple)this.itsAttrContext.getVariables();
        int i = 0;
        while (i < attrVars.size()) {
            String name = attrVars.elementAt(i);
            VarMember vm = varTup.getVarMemberAt(name);
            if (vm != null) {
                vm.setExpr(null);
            }
            ++i;
        }
    }
}

