/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.Map;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ApplicationCondition;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Solution;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class SolutionFinder
extends ApplicationCondition {
    protected final ConditionHandler conditionHandler;
    protected boolean started;
    protected Solution nextSolution;

    public SolutionFinder(EGraph graph, Map<Variable, DomainSlot> variableDomainMap, ConditionHandler conditionHandler, ApplicationMonitor monitor) {
        super(graph, variableDomainMap, monitor);
        this.conditionHandler = conditionHandler;
        this.started = false;
    }

    public boolean findSolution() {
        boolean matchIsPossible = false;
        if (!this.started) {
            this.started = true;
            matchIsPossible = true;
        } else {
            int varCount = this.variables.size();
            int i = varCount - 1;
            while (i >= 0) {
                Variable var = (Variable)this.variables.get(i);
                if (((DomainSlot)this.domainMap.get(var)).unlock(var)) {
                    matchIsPossible = true;
                    break;
                }
                ((DomainSlot)this.domainMap.get(var)).clear(var);
                --i;
            }
        }
        if (matchIsPossible) {
            boolean success = this.findGraph();
            if (success) {
                this.nextSolution = new Solution(this.variables, this.domainMap, this.conditionHandler);
            }
            return success;
        }
        return false;
    }

    public Solution getNextSolution() {
        if (this.findSolution()) {
            return this.nextSolution;
        }
        return null;
    }
}

