/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.scanners;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.internal.ui.text.JavaPartitionScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

/**
 * @author jcheuoua
 * 
 * To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code
 * and Comments
 * @version $Revision: 1.3 $
 */
public class JETTemplatePartitionScanner extends JavaPartitionScanner {

  public static final String JET_SCRIPTLET = "jet_scriptlet";

  public static final String JET_DIRECTIVE = "jet_directive";

  public static final String JET_EXPRESSION = "jet_expression";

  public JETTemplatePartitionScanner() {
    super();

    IToken expression = new Token(JET_EXPRESSION);
    IToken directive = new Token(JET_DIRECTIVE);
    IToken scriptlet = new Token(JET_SCRIPTLET);

    List rules = new ArrayList();

    // Add rule for expressions.
    rules.add(new MultiLineRule("<%=", "%>", expression, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

    // Add rule for directives.
    rules.add(new MultiLineRule("<%@", "%>", directive, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

    // Add rule for scriptlets.
    rules.add(new MultiLineRule("<%", "%>", scriptlet, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

    // Add JDT Partition Scanner rules
    for (int i = 0; i < fRules.length; i++) {
      rules.add((IPredicateRule) fRules[i]);
    }

    IPredicateRule[] result = new IPredicateRule[rules.size()];
    rules.toArray(result);
    setPredicateRules(result);
  }

  /**
   * Returns the legal partition types for an JET Template file. *
   * 
   * @return String[]
   */
  public static String[] getLegalContentTypes() {
    return new String[] { JAVA_SINGLE_LINE_COMMENT, JAVA_MULTI_LINE_COMMENT, JAVA_STRING, JAVA_DOC, JAVA_CHARACTER,
        JET_SCRIPTLET, JET_EXPRESSION, JET_DIRECTIVE, IDocument.DEFAULT_CONTENT_TYPE };
  }
}
