/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.util.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;


/**
 * @author Joel Cheuoua
 * @version $Revision: 1.2 $
 */
public class JETTemplateWordRule extends WordRule {

	/**
	 * Constructor for JETTemplateWordRule.
	 * @param detector IWordDetector
	 */
	public JETTemplateWordRule(IWordDetector detector) {
		super(detector);
	}

	/**
	 * Constructor for JETTemplateWordRule.
	 * @param detector IWordDetector
	 * @param defaultToken IToken
	 */
	public JETTemplateWordRule(IWordDetector detector, IToken defaultToken) {
		super(detector, defaultToken);
	}

	/**
	 * Method evaluate.
	 * @param scanner ICharacterScanner
	 * @return IToken
	 * @see org.eclipse.jface.text.rules.IRule#evaluate(ICharacterScanner)
	 */
	public IToken evaluate(ICharacterScanner scanner) {
		return super.evaluate(scanner);
	}
}