/*******************************************************************************
 * Copyright (c) 2005 - 2006 IBM Corporation & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Chris Aniszczyk - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.codegen.jet.editor.JETUIMessages;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/**
 * @author Chris Aniszczyk
 * @since 1.0.0
 */
public class NewJETFileCreationWizard extends Wizard implements INewWizard {
	
	private IContainer container;
	private NewJETFileCreationWizardPage mainPage;
	
	public NewJETFileCreationWizard() {
		setWindowTitle(JETUIMessages.NewJETFileCreationWizard_windowTitle);
		setNeedsProgressMonitor(true);
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		Object sel = selection.getFirstElement();
		if (sel instanceof IJavaProject) {
			container = ((IJavaProject) sel).getProject();
		} else if (sel instanceof IContainer)
			container = (IContainer) sel;
	}
	
	public void addPages() {
		mainPage = new NewJETFileCreationWizardPage(container);
		addPage(mainPage);
	}
	
	public boolean performFinish() {
		return mainPage.finish();
	}
	
}
