/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProcessingKindSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private CCombo processingKindCb;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.processingKindCb = this.getWidgetFactory().createCCombo(composite, 0x800808);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.processingKindCb, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.processingKindCb.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.processingKindCb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessingKindSection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing) {
            final int newProcessingKind = this.getIndex(this.processingKindCb.getText());
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                int oldProcessingKind = ExtendedMetaData.INSTANCE.getProcessingKind((EStructuralFeature)this.getEObject());
                if (oldProcessingKind != newProcessingKind) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setProcessingKind((EStructuralFeature)ProcessingKindSection.this.getEObject(), newProcessingKind);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    int oldProcessingKind = ExtendedMetaData.INSTANCE.getProcessingKind((EStructuralFeature)nextObject);
                    if (oldProcessingKind == newProcessingKind) continue;
                    compoundCommand.append((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setProcessingKind((EStructuralFeature)nextObject, newProcessingKind);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.processingKindCb.setItems(ExtendedMetaData.PROCESSING_KINDS);
        int processingKind = ExtendedMetaData.INSTANCE.getProcessingKind((EStructuralFeature)this.getEObject());
        this.processingKindCb.setText(ExtendedMetaData.PROCESSING_KINDS[processingKind]);
        this.isRefreshing = false;
    }

    private int getIndex(String key) {
        String[] contentKinds = ExtendedMetaData.PROCESSING_KINDS;
        int i = 0;
        while (i < contentKinds.length) {
            if (contentKinds[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.ProcessingKindSection_ProcessingKind;
    }
}

