/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.cdo.core.protocol.ResourceChangeInfo;
import org.eclipse.emf.cdo.server.AttributeInfo;
import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.ColumnConverter;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ResourceInfo;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.emf.cdo.server.ServerCDOResProtocol;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;
import org.eclipse.net4j.util.ImplementationError;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CommitTransactionIndication
extends AbstractIndicationWithResponse {
    public static final int CAPACITY_tempIdtoPersistentIdMap = 499;
    private Map<Long, Long> tempOIDs = new HashMap<Long, Long>(499);
    private List<Long> changedObjectIds = new ArrayList<Long>();
    private Map<Long, Integer> changedObjectOIDOCA = new HashMap<Long, Integer>();
    private List<Long> oidList = new ArrayList<Long>();
    private boolean optimisticControlException = false;
    private Mapper mapper;
    private List<ResourceChangeInfo> newResources = new ArrayList<ResourceChangeInfo>();

    public short getSignalId() {
        return 7;
    }

    public void indicate() {
        try {
            TransactionTemplate transactionTemplate = ((ServerCDOProtocol)this.getProtocol()).getTransactionTemplate();
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    CommitTransactionIndication.this.receiveObjectsToDetach();
                    CommitTransactionIndication.this.receiveObjectsToAttach();
                    CommitTransactionIndication.this.receiveObjectChanges();
                    CommitTransactionIndication.this.receiveNewResources();
                    if (CommitTransactionIndication.this.optimisticControlException) {
                        status.setRollbackOnly();
                    }
                }
            });
        }
        catch (TransactionException ex) {
            this.error("Error while committing transaction to database", ex);
        }
        if (!this.optimisticControlException) {
            this.transmitInvalidations();
            this.transmitResourceChanges();
        }
    }

    public void respond() {
        if (this.optimisticControlException) {
            this.transmitBoolean(false);
            return;
        }
        this.transmitBoolean(true);
        this.transmitInt(this.oidList.size());
        for (Long id : this.oidList) {
            this.transmitLong(id);
        }
        this.transmitInt(this.changedObjectIds.size());
        for (Long id : this.changedObjectIds) {
            this.transmitLong(id);
            Integer oca = this.changedObjectOIDOCA.get(id);
            this.transmitInt(oca);
        }
    }

    private void receiveNewResources() {
        int rid;
        while ((rid = this.receiveInt()) != 0) {
            String path = this.receiveString();
            this.getMapper().insertResource(rid, path);
            this.newResources.add(new ResourceChangeInfo(1, rid, path));
        }
    }

    private void receiveObjectsToDetach() {
        long oid;
        if (this.isDebugEnabled()) {
            this.debug("receiveObjectsToDetach()");
        }
        while ((oid = this.receiveLong()) != 0L) {
            this.getMapper().removeObject(oid);
        }
    }

    private void receiveObjectsToAttach() {
        if (this.isDebugEnabled()) {
            this.debug("receiveObjectsToAttach()");
        }
        int count = this.receiveInt();
        int i = 0;
        while (i < count) {
            long oid = this.receiveLong();
            if (oid < 0L) {
                oid = this.registerTempOID(oid);
            }
            ClassInfo info = this.receiveClassInfo();
            this.getMapper().insertObject(oid, info.getCID());
            boolean isContent = this.receiveBoolean();
            if (isContent) {
                this.getMapper().insertContent(oid);
            }
            this.receiveObjectsToAttachAttributes(info, oid);
            ++i;
        }
        this.receiveObjectsToAttachReferences();
    }

    private void receiveObjectsToAttachReferences() {
        if (this.isDebugEnabled()) {
            this.debug("receiveObjectsToAttachReferences()");
        }
        int count = this.receiveInt();
        int i = 0;
        while (i < count) {
            long oid = this.receiveLong();
            int feature = this.receiveInt();
            int ordinal = this.receiveInt();
            long target = this.receiveLong();
            boolean containment = this.receiveBoolean();
            if (oid < 0L) {
                oid = this.resolveTempOID(oid);
            }
            if (target < 0L) {
                target = this.resolveTempOID(target);
            }
            this.getMapper().insertReference(oid, feature, ordinal, target, containment);
            ++i;
        }
    }

    private ClassInfo receiveClassInfo() {
        int cid = this.receiveInt();
        ClassInfo classInfo = this.getMapper().getPackageManager().getClassInfo(cid);
        if (classInfo == null) {
            throw new ImplementationError("Unknown cid " + cid);
        }
        return classInfo;
    }

    private long registerTempOID(long tempOID) {
        OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
        int rid = oidEncoder.getRID(-tempOID);
        ResourceInfo resourceInfo = this.getMapper().getResourceManager().getResourceInfo(rid, this.getMapper());
        long oidFragment = resourceInfo.getNextOIDFragment();
        Long key = new Long(tempOID);
        long oid = oidEncoder.getOID(rid, oidFragment);
        Long val = new Long(oid);
        this.tempOIDs.put(key, val);
        this.oidList.add(val);
        if (this.isDebugEnabled()) {
            this.debug("Mapping oid " + oidEncoder.toString(key.longValue()) + " --> " + oidEncoder.toString(val.longValue()));
        }
        return oid;
    }

    private long resolveTempOID(long tempOID) {
        Long sourceVal = this.tempOIDs.get(new Long(tempOID));
        if (sourceVal == null) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            throw new ImplementationError("no mapping for temporary oid " + oidEncoder.toString(tempOID));
        }
        return sourceVal;
    }

    private void receiveObjectChanges() {
        long oid;
        if (this.isDebugEnabled()) {
            this.debug("receiveObjectChanges()");
        }
        while ((oid = this.receiveLong()) != 0L) {
            int oca = this.receiveInt();
            int newOCA = this.lock(oid, oca);
            this.receiveReferenceChanges();
            this.receiveAttributeChanges(oid);
            this.rememberChangedObject(oid, newOCA);
        }
    }

    private void receiveReferenceChanges() {
        byte changeKind;
        block7: while ((changeKind = this.receiveByte()) != 0) {
            switch (changeKind) {
                case 1: {
                    this.receiveReferenceSet();
                    continue block7;
                }
                case 2: {
                    this.receiveReferenceUnset();
                    continue block7;
                }
                case 3: {
                    this.receiveReferenceAdd();
                    continue block7;
                }
                case 4: {
                    this.receiveReferenceRemove();
                    continue block7;
                }
                case 5: {
                    this.receiveReferenceMove();
                    continue block7;
                }
            }
            throw new ImplementationError("invalid changeKind: " + changeKind);
        }
    }

    private void receiveReferenceSet() {
        long oid = this.receiveLong();
        int feature = this.receiveInt();
        long target = this.receiveLong();
        boolean containment = this.receiveBoolean();
        if (target < 0L) {
            target = this.resolveTempOID(target);
        }
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            this.debug("received reference set: oid=" + oidEncoder.toString(oid) + ", feature=" + feature + ", target=" + oidEncoder.toString(target) + ", containment=" + containment);
        }
        this.getMapper().insertReference(oid, feature, 0, target, containment);
    }

    private void receiveReferenceUnset() {
        long oid = this.receiveLong();
        int feature = this.receiveInt();
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            this.debug("received reference unset: oid=" + oidEncoder.toString(oid) + ", feature=" + feature);
        }
        this.getMapper().removeReference(oid, feature, 0);
    }

    private void receiveReferenceAdd() {
        long oid = this.receiveLong();
        int feature = this.receiveInt();
        int ordinal = this.receiveInt() + 1;
        long target = this.receiveLong();
        boolean containment = this.receiveBoolean();
        if (target < 0L) {
            target = this.resolveTempOID(target);
        }
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            this.debug("received reference add: oid=" + oidEncoder.toString(oid) + ", feature=" + feature + ", ordinal=" + ordinal + ", target=" + oidEncoder.toString(target) + ", containment=" + containment);
        }
        if (ordinal == 0) {
            ordinal = this.getMapper().getCollectionCount(oid, feature);
        }
        this.getMapper().moveReferencesRelative(oid, feature, ordinal, Integer.MAX_VALUE, 1);
        this.getMapper().insertReference(oid, feature, ordinal, target, containment);
    }

    private void receiveReferenceRemove() {
        long oid = this.receiveLong();
        int feature = this.receiveInt();
        int ordinal = this.receiveInt() + 1;
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            this.debug("receiveObjectChangesReferences(REMOVE, sourceId=" + oidEncoder.toString(oid) + ", featureId=" + feature + ", sourceOrdinal=" + ordinal + ")");
        }
        this.getMapper().removeReference(oid, feature, ordinal);
        this.getMapper().moveReferencesRelative(oid, feature, ordinal, Integer.MAX_VALUE, -1);
    }

    private void receiveReferenceMove() {
        long oid = this.receiveLong();
        int feature = this.receiveInt();
        int ordinal = this.receiveInt();
        int moveToIndex = this.receiveInt();
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getMapper().getOidEncoder();
            this.debug("received reference move: oid=" + oidEncoder.toString(oid) + ", feature=" + feature + ", ordinal=" + ordinal + ", moveToIndex=" + moveToIndex);
        }
        this.getMapper().moveReferenceAbsolute(oid, feature, -1, ++ordinal);
        if (++moveToIndex > ordinal) {
            this.getMapper().moveReferencesRelative(oid, feature, ordinal + 1, moveToIndex, -1);
        } else if (moveToIndex < ordinal) {
            this.getMapper().moveReferencesRelative(oid, feature, moveToIndex, ordinal - 1, 1);
        }
        this.getMapper().moveReferenceAbsolute(oid, feature, moveToIndex, -1);
    }

    private int lock(long oid, int oca) {
        boolean ok = this.getMapper().lock(oid, oca);
        if (!ok) {
            this.optimisticControlException = true;
            if (this.isDebugEnabled()) {
                this.debug("");
                this.debug("============================");
                this.debug("OPTIMISTIC CONTROL EXCEPTION");
                this.debug("============================");
                this.debug("");
            }
            return oca;
        }
        return oca + 1;
    }

    private void rememberChangedObject(long oid, int oca) {
        Long key = new Long(oid);
        this.changedObjectIds.add(key);
        this.changedObjectOIDOCA.put(key, new Integer(oca));
    }

    private void receiveAttributeChanges(long oid) {
        int cid;
        ClassInfo classInfo = null;
        while ((cid = this.receiveInt()) != 0) {
            classInfo = this.getMapper().getPackageManager().getClassInfo(cid);
            this.receiveAttributeChangeSegment(oid, classInfo);
        }
    }

    private void receiveAttributeChangeSegment(long oid, ClassInfo classInfo) {
        int count = this.receiveInt();
        Object[] args = new Object[count + 1];
        args[count] = oid;
        int[] types = new int[count + 1];
        types[count] = -5;
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(classInfo.getTableName());
        sql.append(" SET ");
        int i = 0;
        while (i < count) {
            int feature = this.receiveInt();
            AttributeInfo attributeInfo = classInfo.getAttributeInfo(feature);
            ColumnConverter converter = this.getMapper().getColumnConverter();
            args[i] = converter.fromChannel(this.getChannel(), attributeInfo.getDataType());
            types[i] = attributeInfo.getColumnType();
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(attributeInfo.getColumnName());
            sql.append("=?");
            ++i;
        }
        sql.append(" WHERE ");
        sql.append("CDO_OID");
        sql.append("=?");
        this.getMapper().sql(sql.toString(), args, types);
    }

    private void receiveObjectsToAttachAttributes(ClassInfo classInfo, long oid) {
        if (this.isDebugEnabled()) {
            this.debug("receiveObjectsToAttachAttributes()");
        }
        while (classInfo != null) {
            AttributeInfo[] attributeInfos = classInfo.getAttributeInfos();
            Object[] args = new Object[attributeInfos.length + 1];
            args[0] = oid;
            int[] types = new int[attributeInfos.length + 1];
            types[0] = -5;
            StringBuffer sql = new StringBuffer("INSERT INTO ");
            sql.append(classInfo.getTableName());
            sql.append(" VALUES(?");
            int i = 0;
            while (i < attributeInfos.length) {
                AttributeInfo attributeInfo = attributeInfos[i];
                if (this.isDebugEnabled()) {
                    this.debug("Receiving attribute " + attributeInfo.getName());
                }
                ColumnConverter converter = this.getMapper().getColumnConverter();
                args[i + 1] = converter.fromChannel(this.getChannel(), attributeInfo.getDataType());
                types[i + 1] = attributeInfo.getColumnType();
                sql.append(", ?");
                ++i;
            }
            sql.append(")");
            this.getMapper().sql(sql.toString(), args, types);
            classInfo = classInfo.getParent();
        }
    }

    private void transmitInvalidations() {
        if (!this.changedObjectIds.isEmpty()) {
            Channel me = this.getChannel();
            ServerCDOProtocol cdo = (ServerCDOProtocol)me.getProtocol();
            cdo.fireInvalidationNotification(me, this.changedObjectIds);
        }
    }

    private void transmitResourceChanges() {
        if (!this.newResources.isEmpty()) {
            Channel me = this.getChannel();
            ServerCDOProtocol cdo = (ServerCDOProtocol)me.getProtocol();
            ServerCDOResProtocol cdores = cdo.getServerCDOResProtocol();
            cdores.fireResourcesChangedNotification(this.newResources);
        }
    }

    private Mapper getMapper() {
        if (this.mapper == null) {
            this.mapper = ((ServerCDOProtocol)this.getProtocol()).getMapper();
        }
        return this.mapper;
    }
}

