/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ResourceInfo;
import org.eclipse.emf.cdo.server.ResourceManager;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;

public class ResourcePathIndication
extends AbstractIndicationWithResponse {
    private String path;

    public short getSignalId() {
        return 4;
    }

    public void indicate() {
        this.path = this.receiveString();
        if (this.isDebugEnabled()) {
            this.debug("Requested path " + this.path);
        }
    }

    public void respond() {
        Mapper mapper = ((ServerCDOProtocol)this.getProtocol()).getMapper();
        ResourceManager resourceManager = mapper.getResourceManager();
        ResourceInfo info = resourceManager.getResourceInfo(this.path, mapper);
        if (info == null) {
            int rid = mapper.getNextRID();
            resourceManager.registerResourceInfo(this.path, rid, 1L);
            if (this.isDebugEnabled()) {
                this.debug("No resource with path " + this.path);
            }
            if (this.isDebugEnabled()) {
                this.debug("Reserving rid " + rid);
            }
            this.transmitInt(-rid);
        } else {
            if (this.isDebugEnabled()) {
                this.debug("Responding rid " + info.getRID());
            }
            this.transmitInt(info.getRID());
        }
    }
}

