/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.gmf.runtime.emf.ui.internal.l10n.EMFUIMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PathmapsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ScrolledComposite referencedPathVariablesScroll;
    private TableViewer referencedPathVariables;
    private StringsContentProvider referencedPathVariablesContent;
    private ScrolledComposite pathVariablesScroll;
    private TableViewer pathVariables;
    private StringsContentProvider pathVariablesContent;
    private Button add;
    private Button remove;
    private IPathVariableChangeListener pathVariableChangeListener;
    private boolean disposed = true;

    protected void initHelp() {
    }

    protected Control createContents(Composite parent) {
        GridData gridData = null;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        PreferenceLinkArea pathVariablesArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.LinkedResources", EMFUIMessages.PathmapsPreferencePage_mainDescription, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 3;
        pathVariablesArea.getControl().setLayoutData((Object)gridData);
        Composite pathVariablesComposite = new Composite(composite, 0);
        pathVariablesComposite.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        pathVariablesComposite.setLayoutData((Object)gridData);
        Label pathVariablesLabel = new Label(pathVariablesComposite, 16384);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        pathVariablesLabel.setLayoutData((Object)gridData);
        pathVariablesLabel.setText(EMFUIMessages.PathmapsPreferencePage_availablePathVariables);
        this.pathVariablesScroll = new ScrolledComposite(pathVariablesComposite, 2816);
        this.pathVariablesScroll.setExpandHorizontal(true);
        this.pathVariablesScroll.setExpandVertical(true);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.pathVariablesScroll.setLayoutData((Object)gridData);
        this.pathVariables = new TableViewer((Composite)this.pathVariablesScroll, 2);
        this.pathVariablesScroll.setContent((Control)this.pathVariables.getTable());
        TableColumn column = new TableColumn(this.pathVariables.getTable(), 16384);
        column.setMoveable(false);
        column.setResizable(false);
        this.pathVariables.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PathmapsPreferencePage.this.pathVariables.getTable().getColumn(0).setWidth(((PathmapsPreferencePage)PathmapsPreferencePage.this).pathVariables.getTable().getClientArea().width);
            }
        });
        this.pathVariablesContent = new StringsContentProvider();
        this.pathVariables.setContentProvider((IContentProvider)this.pathVariablesContent);
        this.pathVariables.setLabelProvider((IBaseLabelProvider)new StringsLabelProvider());
        this.pathVariables.setComparator((ViewerComparator)new StringsViewerComparator());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.add = new Button(buttonComposite, 0x1000000);
        this.add.setText(EMFUIMessages.PathmapsPreferencePage_addChevron);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        this.add.setLayoutData((Object)gridData);
        Button addAll = new Button(buttonComposite, 0x1000000);
        addAll.setText(EMFUIMessages.PathmapsPreferencePage_addAllChevron);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        addAll.setLayoutData((Object)gridData);
        this.remove = new Button(buttonComposite, 0x1000000);
        this.remove.setText(EMFUIMessages.PathmapsPreferencePage_removeChevron);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalIndent = 10;
        this.remove.setLayoutData((Object)gridData);
        Button removeAll = new Button(buttonComposite, 0x1000000);
        removeAll.setText(EMFUIMessages.PathmapsPreferencePage_removeAllChevron);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        removeAll.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)gridData);
        Composite referencedPathVariablesComposite = new Composite(composite, 0);
        referencedPathVariablesComposite.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        referencedPathVariablesComposite.setLayoutData((Object)gridData);
        Label referencedPathVariablesLabel = new Label(referencedPathVariablesComposite, 16384);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalIndent = 20;
        referencedPathVariablesLabel.setLayoutData((Object)gridData);
        referencedPathVariablesLabel.setText(EMFUIMessages.PathmapsPreferencePage_pathVariablesUsedInModeling);
        this.referencedPathVariablesScroll = new ScrolledComposite(referencedPathVariablesComposite, 2816);
        this.referencedPathVariablesScroll.setExpandHorizontal(true);
        this.referencedPathVariablesScroll.setExpandVertical(true);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.referencedPathVariablesScroll.setLayoutData((Object)gridData);
        this.referencedPathVariables = new TableViewer((Composite)this.referencedPathVariablesScroll, 2);
        this.referencedPathVariablesScroll.setContent((Control)this.referencedPathVariables.getTable());
        column = new TableColumn(this.referencedPathVariables.getTable(), 16384);
        column.setMoveable(false);
        column.setResizable(false);
        this.referencedPathVariables.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PathmapsPreferencePage.this.referencedPathVariables.getTable().getColumn(0).setWidth(((PathmapsPreferencePage)PathmapsPreferencePage.this).referencedPathVariables.getTable().getClientArea().width);
            }
        });
        this.referencedPathVariablesContent = new StringsContentProvider();
        this.referencedPathVariables.setContentProvider((IContentProvider)this.referencedPathVariablesContent);
        this.referencedPathVariables.setLabelProvider((IBaseLabelProvider)new StringsLabelProvider(true));
        this.referencedPathVariables.setComparator((ViewerComparator)new StringsViewerComparator());
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PathmapsPreferencePage.this.adjustScrollpanes();
            }
        });
        this.pathVariables.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TableItem item = PathmapsPreferencePage.this.pathVariables.getTable().getItem(new Point(e.x, e.y));
                String tip = null;
                if (item != null) {
                    String var = item.getText(0);
                    tip = PathmapsPreferencePage.this.getValue(var, false);
                }
                PathmapsPreferencePage.this.pathVariables.getTable().setToolTipText(tip);
            }
        });
        this.pathVariables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    PathmapsPreferencePage.this.referencedPathVariables.setSelection((ISelection)new StructuredSelection());
                    PathmapsPreferencePage.this.remove.setEnabled(true);
                    if (!PathmapsPreferencePage.this.validateAdditions((IStructuredSelection)event.getSelection(), true)) {
                        PathmapsPreferencePage.this.add.setEnabled(false);
                    } else {
                        PathmapsPreferencePage.this.setMessage(null);
                        PathmapsPreferencePage.this.add.setEnabled(true);
                    }
                }
            }
        });
        this.referencedPathVariables.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TableItem item = PathmapsPreferencePage.this.referencedPathVariables.getTable().getItem(new Point(e.x, e.y));
                String tip = null;
                if (item != null) {
                    String var = item.getText(0);
                    tip = PathmapsPreferencePage.this.getValue(var, true);
                }
                PathmapsPreferencePage.this.referencedPathVariables.getTable().setToolTipText(tip);
            }
        });
        this.referencedPathVariables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    PathmapsPreferencePage.this.add.setEnabled(true);
                    PathmapsPreferencePage.this.pathVariables.setSelection((ISelection)new StructuredSelection());
                    if (!PathmapsPreferencePage.this.validateRemovals((IStructuredSelection)event.getSelection(), true)) {
                        PathmapsPreferencePage.this.remove.setEnabled(false);
                    } else {
                        PathmapsPreferencePage.this.setMessage(null);
                        PathmapsPreferencePage.this.remove.setEnabled(true);
                    }
                }
            }
        });
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PathmapsPreferencePage.this.pathVariables.getSelection();
                for (String name : selection) {
                    PathmapsPreferencePage.this.pathVariablesContent.remove(name);
                    PathmapsPreferencePage.this.referencedPathVariablesContent.add(name);
                    PathmapsPreferencePage.this.adjustScrollpanes();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] items = PathmapsPreferencePage.this.pathVariablesContent.getElements(null);
                int i = items.length - 1;
                while (i >= 0) {
                    if (PathmapsPreferencePage.this.validateAdditions((IStructuredSelection)new StructuredSelection(items[i]), false)) {
                        String name = (String)items[i];
                        PathmapsPreferencePage.this.pathVariablesContent.remove(name);
                        PathmapsPreferencePage.this.referencedPathVariablesContent.add(name);
                        PathmapsPreferencePage.this.adjustScrollpanes();
                    }
                    --i;
                }
            }
        });
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PathmapsPreferencePage.this.referencedPathVariables.getSelection();
                for (String name : selection) {
                    PathmapsPreferencePage.this.referencedPathVariablesContent.remove(name);
                    PathmapsPreferencePage.this.pathVariablesContent.add(name);
                    PathmapsPreferencePage.this.adjustScrollpanes();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        removeAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] items = PathmapsPreferencePage.this.referencedPathVariablesContent.getElements(null);
                int i = items.length - 1;
                while (i >= 0) {
                    if (PathmapsPreferencePage.this.validateRemovals((IStructuredSelection)new StructuredSelection(items[i]), false)) {
                        String name = (String)items[i];
                        PathmapsPreferencePage.this.referencedPathVariablesContent.remove(name);
                        PathmapsPreferencePage.this.pathVariablesContent.add(name);
                        PathmapsPreferencePage.this.adjustScrollpanes();
                    }
                    --i;
                }
            }
        });
        this.initializeContents();
        this.pathVariableChangeListener = new IPathVariableChangeListener(){

            public void pathVariableChanged(IPathVariableChangeEvent event) {
                PathmapsPreferencePage.this.referencedPathVariables.getTable().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!PathmapsPreferencePage.this.disposed) {
                            PathmapsPreferencePage.this.performDefaults();
                        }
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().getPathVariableManager().addChangeListener(this.pathVariableChangeListener);
        this.disposed = false;
        this.applyDialogFont(composite);
        return composite;
    }

    private void adjustScrollpanes() {
        this.pathVariablesScroll.setMinSize(this.pathVariables.getTable().computeSize(-1, -1));
        this.pathVariablesScroll.layout();
        this.referencedPathVariablesScroll.setMinSize(this.referencedPathVariables.getTable().computeSize(-1, -1));
        this.referencedPathVariablesScroll.layout();
    }

    private String getValue(String pathVariable, boolean includeRegistered) {
        String result = null;
        if (includeRegistered && PathmapManager.isRegisteredPathVariable((String)pathVariable)) {
            String path = PathmapManager.getRegisteredValue((String)pathVariable);
            if (path != null) {
                URI uri = URI.createURI((String)path);
                path = (uri = CommonPlugin.resolve((URI)uri)).isFile() ? uri.toFileString() : uri.toString();
                result = path;
            }
        } else {
            IPathVariableManager pathVarMgr = ResourcesPlugin.getWorkspace().getPathVariableManager();
            IPath path = pathVarMgr.getValue(pathVariable);
            if (path != null) {
                result = path.toOSString();
            }
        }
        return result;
    }

    private boolean validateAdditions(IStructuredSelection selection, boolean showError) {
        if (selection.isEmpty()) {
            return false;
        }
        for (String name : selection) {
            if (!PathmapManager.isCompatiblePathVariable((String)name)) {
                if (showError) {
                    this.setMessage(EMFUIMessages.PathmapsPreferencePage_incompatiblePathVariableErrorMessage, 3);
                }
                return false;
            }
            if (!PathmapManager.isRegisteredPathVariable((String)name)) continue;
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private boolean validateRemovals(IStructuredSelection selection, boolean showError) {
        if (selection.isEmpty()) {
            return false;
        }
        for (String name : selection) {
            if (!PathmapManager.isRegisteredPathVariable((String)name)) continue;
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private void initializeContents() {
        this.setMessage(null);
        this.add.setEnabled(true);
        this.remove.setEnabled(true);
        this.referencedPathVariables.setInput(new HashSet(PathmapManager.getAllPathVariables()));
        Set currentVariables = PathmapManager.getPathVariableReferences();
        HashSet<String> available = new HashSet<String>();
        String[] pathVariableNames = ResourcesPlugin.getWorkspace().getPathVariableManager().getPathVariableNames();
        int i = 0;
        while (i < pathVariableNames.length) {
            if (!currentVariables.contains(pathVariableNames[i])) {
                available.add(pathVariableNames[i]);
            }
            ++i;
        }
        this.pathVariables.setInput(available);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.initializeContents();
        super.performDefaults();
    }

    public boolean performOk() {
        Object[] nonReferencedPathVariables = this.pathVariablesContent.getElements(null);
        int i = 0;
        while (i < nonReferencedPathVariables.length) {
            String variableName = (String)nonReferencedPathVariables[i];
            PathmapManager.removePathVariableReference((String)variableName);
            ++i;
        }
        Set currentVariables = PathmapManager.getAllPathVariables();
        Object[] variablesToReference = this.referencedPathVariablesContent.getElements(null);
        int i2 = 0;
        while (i2 < variablesToReference.length) {
            String variableName = (String)variablesToReference[i2];
            if (!currentVariables.contains(variableName)) {
                PathmapManager.addPathVariableReference((String)variableName);
            }
            ++i2;
        }
        PathmapManager.updatePreferenceStore();
        return true;
    }

    public void dispose() {
        this.disposed = true;
        if (this.pathVariableChangeListener != null) {
            ResourcesPlugin.getWorkspace().getPathVariableManager().removeChangeListener(this.pathVariableChangeListener);
            this.pathVariableChangeListener = null;
        }
        super.dispose();
    }

    private static class StringsContentProvider
    implements IStructuredContentProvider {
        private Set strings = new HashSet();
        private TableViewer table;

        StringsContentProvider() {
        }

        void add(String string) {
            if (!this.strings.contains(string)) {
                this.strings.add(string);
                this.table.add((Object)string);
            }
        }

        void remove(String string) {
            if (this.strings.contains(string)) {
                this.strings.remove(string);
                this.table.remove((Object)string);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.strings.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.strings = (Set)newInput;
            this.table = (TableViewer)viewer;
        }

        public void dispose() {
        }
    }

    private static class StringsLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final boolean isReferencedPathVariables;

        StringsLabelProvider() {
            this(false);
        }

        StringsLabelProvider(boolean isReferencedPathVariables) {
            this.isReferencedPathVariables = isReferencedPathVariables;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? (String)element : null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            if (this.isReferencedPathVariables && PathmapManager.isRegisteredPathVariable((String)((String)element))) {
                return Display.getDefault().getSystemColor(34);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    private static class StringsViewerComparator
    extends ViewerComparator {
        StringsViewerComparator() {
        }

        public int category(Object element) {
            return PathmapManager.isRegisteredPathVariable((String)((String)element)) ? 1 : 0;
        }
    }
}

