/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.StringConstants;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.ApplyAppearancePropertiesRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractShapeTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class LogicShapeTests
extends AbstractShapeTests {
    public LogicShapeTests(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        return new TestSuite(LogicShapeTests.class);
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    public void testCopyAppearanceProperties() throws Exception {
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        Point createPt = new Point(100, 100);
        final LEDEditPart ledEP1 = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(ledEP1.getFigure().getSize().getExpanded(100, 100));
        final LEDEditPart ledEP2 = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        final Color red = new Color(null, 255, 0, 0);
        this.getLogicTestFixture().execute((ICommand)new AbstractTransactionalCommand(this.getLogicTestFixture().getEditingDomain(), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                View ledView = ledEP2.getNotationView();
                ShapeStyle shapeStyle = (ShapeStyle)ledView.getStyle(NotationPackage.eINSTANCE.getShapeStyle());
                shapeStyle.setFillColor(FigureUtilities.colorToInteger((Color)red).intValue());
                shapeStyle.setLineColor(FigureUtilities.colorToInteger((Color)red).intValue());
                shapeStyle.setFontColor(FigureUtilities.colorToInteger((Color)red).intValue());
                shapeStyle.setFontHeight(10);
                return CommandResult.newOKCommandResult();
            }
        });
        ApplyAppearancePropertiesRequest request = new ApplyAppearancePropertiesRequest();
        request.setViewToCopyFrom(ledEP2.getNotationView());
        Command cmd = ledEP1.getCommand((Request)request);
        this.getCommandStack().execute(cmd);
        this.flushEventQueue();
        ledEP1.getEditingDomain().runExclusive(new Runnable(){

            public void run() {
                View ledView = ledEP1.getNotationView();
                ShapeStyle shapeStyle = (ShapeStyle)ledView.getStyle(NotationPackage.eINSTANCE.getShapeStyle());
                LogicShapeTests.assertTrue((shapeStyle.getFillColor() == FigureUtilities.colorToInteger((Color)red).intValue() ? 1 : 0) != 0);
                LogicShapeTests.assertTrue((shapeStyle.getLineColor() == FigureUtilities.colorToInteger((Color)red).intValue() ? 1 : 0) != 0);
                LogicShapeTests.assertTrue((shapeStyle.getFontColor() == FigureUtilities.colorToInteger((Color)red).intValue() ? 1 : 0) != 0);
                LogicShapeTests.assertTrue((shapeStyle.getFontHeight() == 10 ? 1 : 0) != 0);
            }
        });
    }

    public void testGetPrimaryEditParts() throws Exception {
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeHalfAdder = ElementTypeRegistry.getInstance().getType("logic.halfAdder");
        Point createPt = new Point(100, 100);
        CircuitEditPart circuitEP = (CircuitEditPart)this.getLogicTestFixture().createShapeUsingTool(typeHalfAdder, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        ISurfaceEditPart logicCompartmentEP = (ISurfaceEditPart)circuitEP.getChildBySemanticHint("LogicCompartment");
        LogicShapeTests.assertEquals((int)8, (int)logicCompartmentEP.getPrimaryEditParts().size());
    }

    public void testPropertiesSetStyle() throws Exception {
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        Point createPt = new Point(200, 200);
        LEDEditPart ledEP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        Request request = new Request((Object)"PortsColor");
        Integer color = FigureUtilities.RGBToInteger((RGB)new RGB(100, 100, 100));
        request.getExtendedData().put(StringConstants.PORTS_COLOR_PROPERTY_NAME, color);
        Command cmd = ledEP.getCommand(request);
        this.getCommandStack().execute(cmd);
        this.flushEventQueue();
        for (Object obj : ledEP.getChildren()) {
            if (!(obj instanceof TerminalEditPart)) continue;
            Integer currentColor = FigureUtilities.colorToInteger((Color)((TerminalEditPart)obj).getFigure().getBackgroundColor());
            LogicShapeTests.assertEquals((Object)color, (Object)currentColor);
        }
    }
}

