/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DiagramAssistantTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(DiagramAssistantTests.class);
        return s;
    }

    public DiagramAssistantTests() {
        super("Diagram Assistant Tests");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    public void testShouldShowDiagramAssistant() throws Exception {
        this.getTestFixture().openDiagram();
        IGraphicalEditPart ep = (IGraphicalEditPart)this.getDiagramEditPart().getPrimaryEditParts().get(0);
        TestDiagramAssistantEditPolicy da = new TestDiagramAssistantEditPolicy();
        ep.installEditPolicy((Object)"TestDiagramAssistantRole", (EditPolicy)da);
        da.activate();
        DiagramAssistantTests.assertTrue((boolean)da.shouldShowDiagramAssistant());
        ep.disableEditMode();
        DiagramAssistantTests.assertFalse((boolean)da.shouldShowDiagramAssistant());
        ep.enableEditMode();
        DiagramAssistantTests.assertTrue((boolean)da.shouldShowDiagramAssistant());
        ep.deactivate();
        DiagramAssistantTests.assertFalse((boolean)da.shouldShowDiagramAssistant());
        ep.activate();
        DiagramAssistantTests.assertTrue((boolean)da.shouldShowDiagramAssistant());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDiagramWorkbenchPart diagramPart = this.getDiagramWorkbenchPart();
        if (page.getViewReferences().length > 0) {
            int i = 0;
            while (i < page.getViewReferences().length) {
                IWorkbenchPart part = page.getViewReferences()[i].getPart(false);
                if (part != null & part != diagramPart) {
                    page.activate(part);
                    DiagramAssistantTests.assertFalse((boolean)da.shouldShowDiagramAssistant());
                    break;
                }
                ++i;
            }
        }
        page.activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        DiagramAssistantTests.assertTrue((boolean)da.shouldShowDiagramAssistant());
    }

    class TestDiagramAssistantEditPolicy
    extends DiagramAssistantEditPolicy {
        TestDiagramAssistantEditPolicy() {
        }

        protected boolean isDiagramAssistant(Object object) {
            return false;
        }

        protected boolean isDiagramAssistantShowing() {
            return false;
        }

        protected void showDiagramAssistant(Point referencePoint) {
        }

        protected void hideDiagramAssistant() {
        }

        public boolean shouldShowDiagramAssistant() {
            return super.shouldShowDiagramAssistant();
        }
    }
}

