/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.common.reconcile.Matcher;

public class ReflectiveMatcher
implements Matcher {
    private final EStructuralFeature myFeature;

    public ReflectiveMatcher(EStructuralFeature feature) {
        assert (feature != null);
        this.myFeature = feature;
    }

    public final boolean match(EObject current, EObject old) {
        this.assertCompatible(current, old);
        this.checkReflector(current.eClass());
        Object currentValue = current.eGet(this.myFeature);
        return currentValue != null && currentValue.equals(old.eGet(this.myFeature));
    }

    private void assertCompatible(EObject current, EObject old) {
        if (!current.eClass().equals(old.eClass())) {
            throw new IllegalStateException(MessageFormat.format("Objects not compatible: {0}, {1}", current, old));
        }
    }

    private void checkReflector(EClass eClass) {
        if (!this.myFeature.getEContainingClass().isSuperTypeOf(eClass)) {
            throw new IllegalStateException(MessageFormat.format("EClass {0} is not compatible with expected class {1} ", eClass, this.myFeature.getEContainingClass()));
        }
    }
}

