/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Collection;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;

public class DiagramLinksTest
extends GeneratedCanvasTest {
    public DiagramLinksTest(String name) {
        super(name);
    }

    public void testBendpoints() throws Exception {
        Node createdNode1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNode1);
        Node createdNode2 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeB());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNode2);
        Edge link = this.createLink(this.getSetup().getGenModel().getLinkC(), (View)createdNode1, (View)createdNode2);
        DiagramLinksTest.assertNotNull((String)"Link not created", (Object)link);
        ConnectionEditPart linkEp = (ConnectionEditPart)this.findEditPart((View)link);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart that represents link", (Object)linkEp);
        this.modifyBendpoints("create bendpoint", 0, new Point(500, 500), linkEp);
        this.checkBendpointsSize(link, 1);
        this.modifyBendpoints("move bendpoint", 0, new Point(400, 400), linkEp);
        this.checkBendpointsSize(link, 1);
        this.modifyBendpoints("create bendpoint", 1, new Point(700, 700), linkEp);
        this.checkBendpointsSize(link, 2);
        this.modifyBendpoints("move bendpoint", 1, new Point(401, 400), linkEp);
        this.checkBendpointsSize(link, 1);
    }

    private void modifyBendpoints(String requestType, int index, Point point, ConnectionEditPart linkEp) {
        ((PolylineConnection)linkEp.getFigure()).layout();
        BendpointRequest bendpointRequest = new BendpointRequest();
        bendpointRequest.setType((Object)requestType);
        bendpointRequest.setIndex(index);
        bendpointRequest.setLocation(point);
        bendpointRequest.setSource(linkEp);
        linkEp.showSourceFeedback((Request)bendpointRequest);
        Command command = linkEp.getCommand((Request)bendpointRequest);
        DiagramLinksTest.assertNotNull((String)"No command", (Object)command);
        DiagramLinksTest.assertTrue((String)"Unexecutable command", (boolean)command.canExecute());
        linkEp.eraseSourceFeedback((Request)bendpointRequest);
        command.execute();
    }

    private void checkBendpointsSize(Edge link, int expectedSize) {
        Bendpoints bendpoints = link.getBendpoints();
        DiagramLinksTest.assertNotNull((Object)bendpoints);
        DiagramLinksTest.assertTrue((boolean)(bendpoints instanceof RelativeBendpoints));
        RelativeBendpoints relativeBendpoints = (RelativeBendpoints)bendpoints;
        DiagramLinksTest.assertEquals((int)expectedSize, (int)relativeBendpoints.getPoints().size());
    }

    public void testRerouteLinkWithClass() throws Exception {
        Node createdNodeA = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeA);
        Node createdNodeB = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeB());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeB);
        Edge link = this.createLink(this.getSetup().getGenModel().getLinkC(), (View)createdNodeA, (View)createdNodeB);
        DiagramLinksTest.assertNotNull((String)"Link not created", (Object)link);
        ConnectionEditPart linkEp = (ConnectionEditPart)this.findEditPart((View)link);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart that represents link", (Object)linkEp);
        TypeLinkModelFacet typeLinkModelFacet = (TypeLinkModelFacet)this.getSetup().getGenModel().getLinkC().getModelFacet();
        EStructuralFeature containmentFeature = createdNodeA.getElement().eClass().getEStructuralFeature(typeLinkModelFacet.getContainmentMetaFeature().getName());
        DiagramLinksTest.assertNotNull((String)"Could not find containment feature", (Object)containmentFeature);
        EStructuralFeature targetFeature = link.getElement().eClass().getEStructuralFeature(typeLinkModelFacet.getTargetMetaFeature().getName());
        DiagramLinksTest.assertNotNull((String)"Could not find target feature", (Object)targetFeature);
        DiagramLinksTest.assertSame((String)"Target feature incorrect before reconnecting source", (Object)createdNodeB.getElement(), (Object)link.getElement().eGet(targetFeature));
        Node createdNodeA1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeA1);
        EditPart a1Ep = this.findEditPart((View)createdNodeA1);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart for the new source", (Object)a1Ep);
        this.reconnectLink(linkEp, a1Ep, true);
        DiagramLinksTest.assertSame((String)"Notation model not updated", (Object)createdNodeA1, (Object)link.getSource());
        Collection containedObjectsA = (Collection)createdNodeA.getElement().eGet(containmentFeature);
        DiagramLinksTest.assertFalse((String)"Old source still contains the link", (boolean)containedObjectsA.contains(link.getElement()));
        Collection containedObjectsA1 = (Collection)createdNodeA1.getElement().eGet(containmentFeature);
        DiagramLinksTest.assertTrue((String)"New source does not contain the link", (boolean)containedObjectsA1.contains(link.getElement()));
        DiagramLinksTest.assertSame((String)"Target feature changed after reconnecting source", (Object)createdNodeB.getElement(), (Object)link.getElement().eGet(targetFeature));
        this.getCommandStack().undo();
        DiagramLinksTest.assertSame((String)"Notation model inconsistent after undo", (Object)createdNodeA, (Object)link.getSource());
        containedObjectsA = (Collection)createdNodeA.getElement().eGet(containmentFeature);
        DiagramLinksTest.assertTrue((String)"Old source does not contain the link after undo", (boolean)containedObjectsA.contains(link.getElement()));
        containedObjectsA1 = (Collection)createdNodeA1.getElement().eGet(containmentFeature);
        DiagramLinksTest.assertFalse((String)"New source contains the link after undo", (boolean)containedObjectsA1.contains(link.getElement()));
        DiagramLinksTest.assertSame((String)"Target feature incorrect after undoing source reconnection", (Object)createdNodeB.getElement(), (Object)link.getElement().eGet(targetFeature));
        Node createdNodeB1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeB());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeB1);
        EditPart b1Ep = this.findEditPart((View)createdNodeB1);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart for the new target", (Object)b1Ep);
        this.reconnectLink(linkEp, b1Ep, false);
        DiagramLinksTest.assertSame((String)"Notation model not updated", (Object)createdNodeB1, (Object)link.getTarget());
        DiagramLinksTest.assertSame((String)"Target feature not updated", (Object)createdNodeB1.getElement(), (Object)link.getElement().eGet(targetFeature));
        this.getCommandStack().undo();
        DiagramLinksTest.assertSame((String)"Notation model inconsistent after undo", (Object)createdNodeB, (Object)link.getTarget());
        DiagramLinksTest.assertSame((String)"Target feature inconsistent after undo", (Object)createdNodeB.getElement(), (Object)link.getElement().eGet(targetFeature));
    }

    public void testRerouteLinkWithFeature() throws Exception {
        Node createdNodeA = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeA);
        Node createdNodeB = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeB());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeB);
        Edge link = this.createLink(this.getSetup().getGenModel().getLinkD(), (View)createdNodeA, (View)createdNodeB);
        DiagramLinksTest.assertNotNull((String)"Link not created", (Object)link);
        ConnectionEditPart linkEp = (ConnectionEditPart)this.findEditPart((View)link);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart that represents link", (Object)linkEp);
        FeatureLinkModelFacet featureLinkModelFacet = (FeatureLinkModelFacet)this.getSetup().getGenModel().getLinkD().getModelFacet();
        EStructuralFeature metaFeature = createdNodeA.getElement().eClass().getEStructuralFeature(featureLinkModelFacet.getMetaFeature().getName());
        DiagramLinksTest.assertSame((String)"Domain source of the link does not point at the element its notation points at", (Object)createdNodeB.getElement(), (Object)createdNodeA.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"Link's element is incorrect", (Object)link.getElement());
        Node createdNodeA1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeA1);
        EditPart a1Ep = this.findEditPart((View)createdNodeA1);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart for the new source", (Object)a1Ep);
        this.reconnectLink(linkEp, a1Ep, true);
        DiagramLinksTest.assertSame((String)"Notation model not updated on reconnecting source", (Object)createdNodeA1, (Object)link.getSource());
        DiagramLinksTest.assertNull((String)"Old source still references target after reconnecting source", (Object)createdNodeA.getElement().eGet(metaFeature));
        DiagramLinksTest.assertSame((String)"New source does not reference target after reconnecting source", (Object)createdNodeB.getElement(), (Object)createdNodeA1.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"Link's element is incorrect after reconnecting source", (Object)link.getElement());
        this.getCommandStack().undo();
        DiagramLinksTest.assertSame((String)"Notation model inconsistent after undo", (Object)createdNodeA, (Object)link.getSource());
        DiagramLinksTest.assertSame((String)"Old source does not reference target after undo", (Object)createdNodeB.getElement(), (Object)createdNodeA.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"New source references target after undo", (Object)createdNodeA1.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"Link's element is incorrect", (Object)link.getElement());
        Node createdNodeB1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeB());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNodeB1);
        EditPart b1Ep = this.findEditPart((View)createdNodeB1);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart for the new target", (Object)b1Ep);
        this.reconnectLink(linkEp, b1Ep, false);
        DiagramLinksTest.assertSame((String)"Notation model not updated on reconnecting target", (Object)createdNodeB1, (Object)link.getTarget());
        DiagramLinksTest.assertSame((String)"Source does not reference new target after reconnecting target", (Object)createdNodeB1.getElement(), (Object)createdNodeA.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"Link's element is incorrect", (Object)link.getElement());
        this.getCommandStack().undo();
        DiagramLinksTest.assertSame((String)"Notation model inconsistent after undo", (Object)createdNodeA, (Object)link.getSource());
        DiagramLinksTest.assertSame((String)"source does not reference old target after undo", (Object)createdNodeB.getElement(), (Object)createdNodeA.getElement().eGet(metaFeature));
        DiagramLinksTest.assertNull((String)"Link's element is incorrect", (Object)link.getElement());
    }

    protected void reconnectLink(ConnectionEditPart linkEP, EditPart elementToReconnectTo, boolean isSourceNotTarget) {
        ReconnectRequest reconnectRequest = new ReconnectRequest((Object)(isSourceNotTarget ? "Reconnection source" : "Reconnection target"));
        reconnectRequest.setConnectionEditPart(linkEP);
        reconnectRequest.setLocation(new Point(0, 0));
        reconnectRequest.setTargetEditPart(elementToReconnectTo);
        Command command = elementToReconnectTo.getCommand((Request)reconnectRequest);
        DiagramLinksTest.assertNotNull((String)"No command for reconnect request", (Object)command);
        DiagramLinksTest.assertTrue((String)"Reconnect command cannot be executed", (boolean)command.canExecute());
        this.execute(command);
    }
}

