/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledUnit {
    private List<String> fQname;
    private URI fUri;
    private List<QvtMessage> fAllProblems;
    private List<CompiledUnit> fImports;
    private List<QvtOperationalModuleEnv> moduleEnvs;
    UnitCS fUnitCST;

    CompiledUnit(List<String> qualifiedName, URI uri, List<? extends QvtOperationalModuleEnv> modules) {
        if (qualifiedName == null || modules == null || uri == null) {
            throw new IllegalArgumentException();
        }
        this.fUri = uri;
        this.fQname = qualifiedName;
        this.moduleEnvs = new ArrayList<QvtOperationalModuleEnv>(modules);
        ArrayList<QvtMessage> problems = new ArrayList<QvtMessage>();
        this.fAllProblems = problems;
        for (QvtOperationalModuleEnv qvtOperationalModuleEnv : modules) {
            this.fAllProblems.addAll(qvtOperationalModuleEnv.getAllProblemMessages());
        }
        if (!problems.isEmpty()) {
            problems.trimToSize();
        }
    }

    void addProblem(QvtMessage problem) {
        if (problem == null) {
            throw new IllegalArgumentException();
        }
        this.fAllProblems.add(problem);
    }

    void setImports(List<CompiledUnit> imports) {
        this.fImports = imports;
    }

    List<String> getQualifiedName() {
        return this.fQname;
    }

    public String getName() {
        return this.fQname.get(this.fQname.size() - 1);
    }

    public List<QvtOperationalModuleEnv> getModuleEnvironments() {
        return this.moduleEnvs;
    }

    public List<QvtMessage> getErrors() {
        ArrayList<QvtMessage> errors = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 2) continue;
            errors.add(nextMessage);
        }
        return errors;
    }

    public List<QvtMessage> getWarnings() {
        ArrayList<QvtMessage> warnings = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 1) continue;
            warnings.add(nextMessage);
        }
        return warnings;
    }

    public List<CompiledUnit> getCompiledImports() {
        return this.fImports != null ? this.fImports : Collections.emptyList();
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>(this.moduleEnvs.size());
        for (QvtOperationalModuleEnv next : this.moduleEnvs) {
            if (next.getModuleContextType() == null) continue;
            modules.add(next.getModuleContextType());
        }
        return modules;
    }

    public URI getURI() {
        return this.fUri;
    }

    public UnitCS getUnitCST() {
        return this.fUnitCST;
    }

    public List<QvtMessage> getProblems() {
        return this.fAllProblems;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompiledUnit) {
            CompiledUnit another = (CompiledUnit)obj;
            return this.fUri.equals((Object)another.fUri);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fUri.hashCode();
    }

    public String toString() {
        return this.fUri.toString();
    }
}

