/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.backend.types.uml2.UmlTypesystem;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;
import org.eclipse.xtend.typesystem.uml2.UML2MetaModel;
import org.eclipse.xtend.typesystem.uml2.profile.ProfileMetaModel;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OldHelper {
    public static BackendTypesystem guessTypesystem(Collection<MetaModel> mms) {
        boolean hasEmf = false;
        boolean hasUml2 = false;
        boolean hasXsd = false;
        Class<?> emfOldXtendTypesClass = null;
        Class<?> umlOldXtendTypesClass = null;
        Class<?> xsdOldXtendTypesClass = null;
        ArrayList umlProfiles = new ArrayList();
        CompositeTypesystem result = new CompositeTypesystem();
        try {
            emfOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.emf.EmfMetaModel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            umlOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.uml2.UML2MetaModel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            xsdOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.xsd.XSDMetaModel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (MetaModel mm : mms) {
            if (mm instanceof EmfRegistryMetaModel) {
                hasEmf = true;
            }
            if (umlOldXtendTypesClass != null && mm instanceof UML2MetaModel) {
                hasUml2 = true;
            }
            if (umlOldXtendTypesClass != null && mm instanceof ProfileMetaModel) {
                ProfileMetaModel profileMM = (ProfileMetaModel)mm;
                umlProfiles.addAll(profileMM.profiles);
                hasUml2 = true;
            }
            if (xsdOldXtendTypesClass == null || !(mm instanceof XSDMetaModel)) continue;
            hasXsd = true;
        }
        if (hasEmf) {
            result.register((BackendTypesystem)new EmfTypesystem());
        }
        if (umlOldXtendTypesClass != null && hasUml2) {
            if (!hasEmf) {
                result.register((BackendTypesystem)new EmfTypesystem());
            }
            result.register((BackendTypesystem)new UmlTypesystem(umlProfiles, false));
        }
        if (xsdOldXtendTypesClass != null && hasXsd) {
            if (!hasEmf) {
                result.register((BackendTypesystem)new EmfTypesystem());
            }
            result.register((BackendTypesystem)new XsdTypesystem());
        }
        return result;
    }

    public static String normalizedFileEncoding(String fileEncoding) {
        if (fileEncoding == null) {
            return System.getProperty("file.encoding");
        }
        return fileEncoding;
    }

    public static String normalizeXtendResourceName(String xtendName) {
        if (xtendName == null) {
            return null;
        }
        if ((xtendName = xtendName.replace("::", "/")).endsWith(".ext")) {
            xtendName = xtendName.substring(0, xtendName.length() - ("ext".length() + 1));
        }
        if (xtendName.startsWith("/")) {
            xtendName = xtendName.substring(1);
        }
        return xtendName;
    }

    public static String normalizeXpandResourceName(String xpandName) {
        if (xpandName == null) {
            return null;
        }
        if (xpandName.endsWith(".xpt")) {
            xpandName = xpandName.substring(0, xpandName.length() - "xpt".length() - 1);
        }
        if ((xpandName = xpandName.replace("::", "/")).startsWith("/")) {
            xpandName = xpandName.substring(1);
        }
        return xpandName;
    }

    public static String normalizeCheckResourceName(String checkName) {
        if (checkName == null) {
            return null;
        }
        if ((checkName = checkName.replace("::", "/")).endsWith(".chk")) {
            checkName = checkName.substring(0, checkName.length() - ("chk".length() + 1));
        }
        if (checkName.startsWith("/")) {
            checkName = checkName.substring(1);
        }
        return checkName;
    }

    public static String xpandFileAsOldResourceName(String xpandName) {
        if (xpandName == null) {
            return null;
        }
        if (xpandName.toLowerCase().endsWith("xpt")) {
            xpandName = xpandName.substring(0, xpandName.length() - "xpt".length() - 1);
        }
        xpandName = xpandName.replace("/", "::");
        return xpandName;
    }
}

