/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.ripoffs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCheckboxTree
extends FilteredTree {
    private WorkbenchJob refreshJob;

    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new FilterableCheckboxTreeViewer(parent, style);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job;
        this.refreshJob = job = super.doCreateRefreshJob();
        return job;
    }

    public void resetFilter() {
        Text filterText = this.getFilterControl();
        if (filterText != null) {
            filterText.setText(String.valueOf(this.initialText));
        }
        this.refreshJob.cancel();
        this.refreshJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            if ((this.filterText.getStyle() & 0x100) == 0) {
                int filterColor = enabled ? 25 : 22;
                this.filterComposite.setBackground(this.getDisplay().getSystemColor(filterColor));
            }
            this.filterText.setEnabled(enabled);
            this.treeViewer.getTree().setEnabled(enabled);
        }
    }

    public void disableTextWidget() {
        this.filterComposite.setVisible(false);
    }

    public void enableTextWidget() {
        this.filterComposite.setVisible(true);
    }

    public class FilterableCheckboxTreeViewer
    extends CheckboxTreeViewer {
        static final String NONE = "none";
        static final String CHECKED = "checked";
        static final String GRAYED = "greyed";
        static final String CHECKED_GRAYED = "checked_greyed";
        Map<Object, FilteredCheckboxTreeItem> itemCache;

        protected void unmapAllElements() {
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            super.unmapAllElements();
        }

        public FilterableCheckboxTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            this.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    FilteredCheckboxTreeItem item = FilterableCheckboxTreeViewer.this.itemCache.get(event.getElement());
                    if (item != null) {
                        item.state = event.getChecked() ? FilterableCheckboxTreeViewer.CHECKED : FilterableCheckboxTreeViewer.NONE;
                    }
                }
            });
        }

        public boolean getChecked(Object element) {
            Widget testFindItem = FilteredCheckboxTree.this.getViewer().testFindItem(element);
            if (testFindItem == null && this.itemCache.containsKey(element)) {
                FilteredCheckboxTreeItem item = this.itemCache.get(element);
                assert (item != null);
                if (item.state.equals(CHECKED)) {
                    return true;
                }
                if (item.state.equals(CHECKED_GRAYED)) {
                    return true;
                }
                if (item.state.equals(GRAYED)) {
                    return true;
                }
                if (item.state.equals(NONE)) {
                    return false;
                }
            }
            return super.getChecked(element);
        }

        public Object[] getCheckedElements() {
            Iterator<FilteredCheckboxTreeItem> iterator = this.itemCache.values().iterator();
            LinkedList<Object> checkedElements = new LinkedList<Object>();
            while (iterator.hasNext()) {
                FilteredCheckboxTreeItem item = iterator.next();
                Widget testFindItem = FilteredCheckboxTree.this.getViewer().testFindItem(item.data);
                if (testFindItem == null) {
                    if (!item.state.equals(CHECKED) && !item.state.equals(CHECKED_GRAYED) && !item.state.equals(GRAYED)) continue;
                    checkedElements.add(item.data);
                    continue;
                }
                if (!((TreeItem)testFindItem).getChecked()) continue;
                checkedElements.add(testFindItem.getData());
            }
            return checkedElements.toArray();
        }

        public boolean setChecked(Object element, boolean state) {
            if (this.itemCache.containsKey(element)) {
                FilteredCheckboxTreeItem item = this.itemCache.get(element);
                assert (item != null);
                item.state = state ? CHECKED : NONE;
            }
            return super.setChecked(element, state);
        }

        public void setCheckedElements(Object[] elements) {
            HashSet<Object> s = new HashSet<Object>(this.itemCache.keySet());
            s.removeAll(new HashSet<Object>(Arrays.asList(elements)));
            int i = 0;
            while (i < elements.length) {
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(elements[i]);
                if (filteredCheckboxTreeItem != null) {
                    filteredCheckboxTreeItem.state = CHECKED;
                }
                ++i;
            }
            for (Object e : s) {
                FilteredCheckboxTreeItem item = this.itemCache.get(e);
                if (item == null) continue;
                item.state = NONE;
            }
            super.setCheckedElements(elements);
        }

        public boolean setSubtreeChecked(Object element, boolean state) {
            String newState = state ? CHECKED : NONE;
            TreeItem item = (TreeItem)this.testFindItem(element);
            FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(element);
            if (item != null && filteredCheckboxTreeItem != null) {
                filteredCheckboxTreeItem.state = newState;
                TreeItem[] items = item.getItems();
                int i = 0;
                while (i < items.length) {
                    item = items[i];
                    if (item != null && (filteredCheckboxTreeItem = this.itemCache.get(item.getData())) != null) {
                        filteredCheckboxTreeItem.state = newState;
                    }
                    ++i;
                }
            }
            return super.setSubtreeChecked(element, state);
        }

        protected void preservingSelection(Runnable updateCode) {
            super.preservingSelection(updateCode);
            ArrayList<TreeItem> allTreeItems = this.getAllTreeItems(FilteredCheckboxTree.this.treeViewer.getTree().getItems());
            for (TreeItem item : allTreeItems) {
                if (item.getData() == null) continue;
                this.doApplyCheckedState((Item)item, item.getData());
            }
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            this.saveCheckedState();
            super.internalRefresh(element, updateLabels);
        }

        private void doApplyCheckedState(Item item, Object element) {
            super.doUpdateItem(item, element);
            TreeItem treeItem = (TreeItem)item;
            if (this.itemCache.containsKey(element)) {
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(element);
                assert (filteredCheckboxTreeItem != null);
                String state = filteredCheckboxTreeItem.state;
                if (state.equals(CHECKED_GRAYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(true);
                } else if (state.equals(CHECKED)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(false);
                } else if (state.equals(GRAYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(false);
                } else {
                    treeItem.setGrayed(false);
                    treeItem.setChecked(false);
                }
            }
        }

        private ArrayList<TreeItem> getAllTreeItems(TreeItem[] roots) {
            ArrayList<TreeItem> list = new ArrayList<TreeItem>();
            int i = 0;
            while (i < roots.length) {
                TreeItem item = roots[i];
                list.add(item);
                list.addAll(this.getAllTreeItems(item.getItems()));
                ++i;
            }
            return list;
        }

        private void saveCheckedState() {
            TreeItem[] items = FilteredCheckboxTree.this.treeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, null);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                assert (filteredCheckboxTreeItem != null);
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private void saveCheckedState(FilteredCheckboxTreeItem parent, TreeItem parentItem) {
            TreeItem[] items = parentItem.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, parent);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                assert (filteredCheckboxTreeItem != null);
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private String getItemState(TreeItem item) {
            if (item.getChecked() && item.getGrayed()) {
                return CHECKED_GRAYED;
            }
            if (item.getChecked()) {
                return CHECKED;
            }
            if (item.getGrayed()) {
                return GRAYED;
            }
            return NONE;
        }

        class FilteredCheckboxTreeItem {
            Object data;
            String state;
            List<FilteredCheckboxTreeItem> children = new ArrayList<FilteredCheckboxTreeItem>();

            public FilteredCheckboxTreeItem(Object data, String state, Map<Object, FilteredCheckboxTreeItem> itemCache, FilteredCheckboxTreeItem parent) {
                this.data = data;
                this.state = state;
                itemCache.put(data, this);
                if (parent != null) {
                    parent.children.add(this);
                }
            }
        }
    }
}

