/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ResourceWithSize;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.XMIResourceWithSize;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.RawNotification;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.RealWorldReplayNotificationProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationResourceLoader {
    public static final String MODEL_FIXTURE_LOCATION = "fixtures/models/";
    public static final String EVENTTRACE_FIXTURE_LOCATION = "fixtures/eventtraces/";

    public static ResourceWithSize loadModel(String path) {
        String resourcePath = MODEL_FIXTURE_LOCATION + path;
        ResourceSetImpl resultRS = new ResourceSetImpl();
        resultRS.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        ECrossReferenceAdapter adapter = new ECrossReferenceAdapter();
        resultRS.eAdapters().add((Object)adapter);
        InputStream fileStream = RealWorldReplayNotificationProducer.class.getResourceAsStream(resourcePath);
        ResourceWithSize instanceResource = NotificationResourceLoader.readResourceOutOfStream(fileStream, resultRS);
        return instanceResource;
    }

    public static List<String> getFilenamesOfEventFixtures() {
        return NotificationResourceLoader.getFileListOfDirectory(EVENTTRACE_FIXTURE_LOCATION);
    }

    public static List<String> getFilenamesOfModelFixture() {
        return NotificationResourceLoader.getFileListOfDirectory(MODEL_FIXTURE_LOCATION);
    }

    private static List<String> getFileListOfDirectory(String directory) {
        File folder;
        ArrayList<String> result = new ArrayList<String>();
        URL url = NotificationResourceLoader.class.getResource(directory);
        try {
            folder = url.getPath().startsWith("file:") ? new File(URLDecoder.decode(url.getPath(), "UTF-8")) : new File(url.getPath());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (folder.listFiles() != null) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result.add(file.getName());
                ++n2;
            }
        }
        return result;
    }

    public static List<RawNotification> loadTrace(String path) {
        String resourcePath = EVENTTRACE_FIXTURE_LOCATION + path;
        ArrayList<RawNotification> informationList = new ArrayList<RawNotification>();
        InputStream traceInput = NotificationResourceLoader.class.getResourceAsStream(resourcePath);
        InputStreamReader ireader = new InputStreamReader(traceInput);
        BufferedReader reader = new BufferedReader(ireader);
        try {
            while (reader.ready()) {
                String newLine = reader.readLine();
                String[] splitOnOpenBracket = newLine.split("\\(");
                String[] splitOnComma = splitOnOpenBracket[1].split("\\)")[0].split(",");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String[] stringArray = splitOnComma;
                int n = splitOnComma.length;
                int n2 = 0;
                while (n2 < n) {
                    String attributePair = stringArray[n2];
                    String[] attributePairSplitted = attributePair.split("=");
                    hashMap.put(attributePairSplitted[0], attributePairSplitted[1]);
                    ++n2;
                }
                informationList.add(new RawNotification(splitOnOpenBracket[0], hashMap));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return informationList;
    }

    private static ResourceWithSize readResourceOutOfStream(InputStream fileStream, ResourceSetImpl resultRS) {
        XMIResourceWithSize instanceResource = null;
        try {
            instanceResource = new XMIResourceWithSize(URI.createURI((String)"http://org.eclipse.ocl.examples.impactanalyzer.benchmarks/test.xmi"));
            resultRS.getResources().add((Object)instanceResource);
            instanceResource.load(fileStream, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return instanceResource;
    }
}

