/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Appender;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ocl.examples.test.xtext.EMFURIEditorInput;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.ui.model.BaseEditorCallback;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.PivotDiagnosticConverter;
import org.eclipse.ocl.xtext.base.utilities.PivotResourceValidator;
import org.eclipse.ocl.xtext.completeocl.ui.internal.CompleteOCLActivator;
import org.eclipse.ocl.xtext.essentialocl.ui.internal.EssentialOCLActivator;
import org.eclipse.ocl.xtext.oclinecore.ui.internal.OCLinEcoreActivator;
import org.eclipse.ocl.xtext.oclstdlib.ui.internal.OCLstdlibActivator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IDiagnosticConverter;

public class EditorTests
extends XtextTestCase {
    private void checkContent(@NonNull XtextEditor editor, @NonNull String referenceContent) {
        IXtextDocument document = editor.getDocument();
        String content = document.get();
        EditorTests.assertEquals((String)referenceContent, (String)content);
    }

    protected FileEditorInput createEcoreFileEditorInput(@NonNull String projectName, @NonNull String fileName, @NonNull String testDocument) throws IOException, CoreException {
        OCL ocl = OCL.newInstance((ProjectManager)EditorTests.getProjectMap());
        String ecoreString = this.createEcoreString(ocl, fileName, testDocument, true);
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(ecoreString, "UTF-8");
        FileEditorInput fileEditorInput = this.createFileEditorInput(projectName, fileName, (InputStream)inputStream);
        ocl.dispose();
        return fileEditorInput;
    }

    protected FileEditorInput createFileEditorInput(@NonNull String projectName, @NonNull String testFile, @NonNull InputStream inputStream) throws CoreException {
        IProject project = this.createProject(projectName);
        IFile file1 = project.getFile(testFile);
        file1.create(inputStream, true, null);
        return new FileEditorInput(file1);
    }

    protected IProject createProject(@NonNull String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        return project;
    }

    protected void doTearDown(@NonNull XtextEditor editor) {
        TestUIUtil.flushEvents();
        editor.close(false);
        TestUIUtil.flushEvents();
    }

    public void doTestEditor(@NonNull String editorId, @NonNull String testFile, @NonNull String testContent) throws Exception {
        XtextEditor editor = this.doStartUp(editorId, testFile, testContent);
        this.checkContent(editor, testContent);
        this.doTearDown(editor);
    }

    public XtextEditor doStartUp(@NonNull String editorId, @NonNull String testFile, @NonNull String testFileContent) throws CoreException, PartInitException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testFileContent, "UTF-8");
        FileEditorInput fileEditorInput = this.createFileEditorInput("test", testFile, (InputStream)inputStream);
        XtextEditor editor = this.doTestEditor(editorId, fileEditorInput);
        IXtextDocument document = editor.getDocument();
        String content = document.get();
        return editor;
    }

    protected XtextEditor doTestEditor(@NonNull String editorId, @NonNull FileEditorInput fileEditorInput) throws PartInitException, CoreException {
        Injector injector = null;
        if (editorId == "org.eclipse.ocl.xtext.completeocl.CompleteOCL") {
            injector = CompleteOCLActivator.getInstance().getInjector("org.eclipse.ocl.xtext.completeocl.CompleteOCL");
        } else if (editorId == "org.eclipse.ocl.xtext.essentialocl.EssentialOCL") {
            injector = EssentialOCLActivator.getInstance().getInjector("org.eclipse.ocl.xtext.essentialocl.EssentialOCL");
        } else if (editorId == "org.eclipse.ocl.xtext.oclinecore.OCLinEcore") {
            injector = OCLinEcoreActivator.getInstance().getInjector("org.eclipse.ocl.xtext.oclinecore.OCLinEcore");
        } else if (editorId == "org.eclipse.ocl.xtext.oclstdlib.OCLstdlib") {
            injector = OCLstdlibActivator.getInstance().getInjector("org.eclipse.ocl.xtext.oclstdlib.OCLstdlib");
        }
        if (injector != null) {
            ((BaseEditorCallback)injector.getInstance(BaseEditorCallback.class)).setDontAskForNatureAgain();
        }
        IFile file = fileEditorInput.getFile();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        XtextEditor editor = (XtextEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fileEditorInput, (String)editorId, (boolean)true);
        TestUIUtil.wait(7500);
        String languageName = editor.getLanguageName();
        EditorTests.assertEquals((String)editorId, (String)languageName);
        file.refreshLocal(2, null);
        IMarker[] markers = file.findMarkers(null, true, 2);
        if (markers.length > 0) {
            StringBuilder s = new StringBuilder();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                s.append("\n  ");
                Object location = marker.getAttribute("location");
                if (location != null) {
                    s.append(location.toString());
                    s.append(": ");
                } else {
                    Object lineNumber = marker.getAttribute("lineNumber");
                    if (lineNumber != null) {
                        s.append(lineNumber.toString());
                        s.append(": ");
                    }
                }
                s.append(marker.getAttribute("message"));
                ++n2;
            }
            EditorTests.fail((String)("Markers" + s.toString()));
        }
        return editor;
    }

    private String doTestEditor(@NonNull String editorId, @NonNull URI testFile) throws CoreException, PartInitException {
        EMFURIEditorInput input = new EMFURIEditorInput(testFile);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editorId, (boolean)true);
        TestUIUtil.wait(750);
        XtextEditor editor = (XtextEditor)openEditor;
        String languageName = editor.getLanguageName();
        EditorTests.assertEquals((String)editorId, (String)languageName);
        XtextDocument document = (XtextDocument)editor.getDocument();
        document.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(@Nullable XtextResource resource) throws Exception {
                if (!$assertionsDisabled && resource == null) {
                    throw new AssertionError();
                }
                resource.setValidationDisabled(false);
                PivotResourceValidator resourceValidator = new PivotResourceValidator();
                resourceValidator.setDiagnostician(Diagnostician.INSTANCE);
                resourceValidator.setDiagnosticConverter((IDiagnosticConverter)new PivotDiagnosticConverter());
                resourceValidator.validate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl);
                return null;
            }
        });
        document.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(@Nullable XtextResource resource) throws Exception {
                if (!$assertionsDisabled && resource == null) {
                    throw new AssertionError();
                }
                EditorTests.assertNoResourceErrorsOrWarnings("Loaded CS", (Resource)resource);
                BaseCSResource csResource = (BaseCSResource)resource;
                CS2AS cs2as = csResource.findCS2AS();
                if (cs2as != null) {
                    ASResource asResource = cs2as.getASResource();
                    EditorTests.assertNoResourceErrorsOrWarnings("Loaded pivot", (Resource)asResource);
                }
                return null;
            }
        });
        try {
            String string = document.get();
            return string;
        }
        finally {
            this.doTearDown(editor);
        }
    }

    protected Set<EObject> indexPivotContent(@NonNull XtextDocument document, final @NonNull String prefix) {
        String doc = document.get();
        final HashSet<EObject> pivotContent = new HashSet<EObject>();
        document.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(@Nullable XtextResource resource) throws Exception {
                if (!$assertionsDisabled && resource == null) {
                    throw new AssertionError();
                }
                CS2AS cs2as = ((BaseCSResource)resource).getCS2AS();
                if (cs2as != null) {
                    ASResource asResource = cs2as.getASResource();
                    EditorTests.assertNoResourceErrors(prefix, (Resource)asResource);
                    TreeIterator tit = asResource.getAllContents();
                    while (tit.hasNext()) {
                        EObject eObject = (EObject)tit.next();
                        pivotContent.add(eObject);
                    }
                }
                return null;
            }
        });
        return pivotContent;
    }

    private void replaceInContent(@NonNull XtextEditor editor, final @NonNull String oldContent, final @NonNull String newContent) throws BadLocationException {
        IXtextDocument document = editor.getDocument();
        document.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(XtextResource xtextResource) throws Exception {
                String xtextContent = ((EObject)xtextResource.getContents().get(0)).toString();
                int index = xtextContent.indexOf(oldContent);
                if (!$assertionsDisabled && index < 0) {
                    throw new AssertionError();
                }
                xtextResource.update(index, oldContent.length(), newContent);
                return null;
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        TestUIUtil.suppressGitPrefixPopUp();
        TestUIUtil.closeIntro();
        super.setUp();
    }

    public void testEditor_OpenCompleteOCLEditor() throws Exception {
        this.doTestEditor("org.eclipse.ocl.xtext.completeocl.CompleteOCL", "test.ocl", "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/'\npackage ecore\nendpackage");
    }

    public void testEditor_OpenCompleteOCLEditor4Pivot_OCL() throws Exception {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.ocl.pivot/model/Pivot.ocl", (boolean)true);
        String documentText = this.doTestEditor("org.eclipse.ocl.xtext.completeocl.CompleteOCL", uri);
        EditorTests.assertTrue((boolean)documentText.contains("inv SourceIsCollection: true"));
    }

    public void testEditor_OpenCompleteOCLEditor4Fruit_OCL() throws Exception {
        URI uri = EditorTests.getTestModelURI("models/uml/Fruit.ocl");
        String documentText = this.doTestEditor("org.eclipse.ocl.xtext.completeocl.CompleteOCL", uri);
        EditorTests.assertTrue((boolean)documentText.contains("body: Color::red"));
    }

    public void testEditor_OpenEssentialOCLEditor() throws Exception {
        this.doTestEditor("org.eclipse.ocl.xtext.essentialocl.EssentialOCL", "test.essentialocl", "1 + 4");
    }

    public void testEditor_OpenOCLinEcoreEditor() throws Exception {
        this.doTestEditor("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", "test.oclinecore", "package test : test = 'test' { }");
    }

    public void testEditor_OpenOCLinEcoreEditor4Ecore() throws Exception {
        int count;
        String testFileName = "test.ecore";
        String ecoreContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n    name=\"test\" nsURI=\"testURI\" nsPrefix=\"test\"/>\n";
        String oclinecoreContent = "package test : test = 'testURI';";
        XtextEditor editor = this.doStartUp("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", testFileName, ecoreContent);
        this.checkContent(editor, oclinecoreContent);
        this.replaceInContent(editor, "testURI", "testing");
        editor.doSave(null);
        URI uri = EditUIUtil.getURI((IEditorInput)editor.getEditorInput(), (URIConverter)URIConverter.INSTANCE);
        InputStream inputStream = URIConverter.INSTANCE.createInputStream(uri, null);
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] ch = new char[4096];
        while ((count = reader.read(ch)) > 0) {
            s.append(ch, 0, count);
        }
        String tweakedEcoreContent = ecoreContent.replace("testURI", "testing");
        EditorTests.assertEquals((String)tweakedEcoreContent, (String)s.toString());
        this.doTearDown(editor);
    }

    public void testEditor_OpenOCLinEcoreEditor_Bug460625() throws Exception {
        String testContent = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\n\npackage test : tut = 'http://bug/382087'\n{\n\tclass Test\n\t{\n\t\tinvariant Testing: self->select(self);\n\t}\n}\n";
        XtextEditor editor = this.doStartUp("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", "Bug460625.ecore", testContent);
        this.checkContent(editor, testContent);
        int selectionOffset = testContent.indexOf("->");
        int selectionLength = "->".length();
        editor.selectAndReveal(selectionOffset, selectionLength);
        this.doTearDown(editor);
    }

    public void testEditor_OpenOCLinEcoreEditor4Pivot() throws Exception {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        String documentText = this.doTestEditor("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", uri);
        EditorTests.assertTrue((boolean)documentText.contains("primitive datatype _'Boolean'"));
    }

    public void testEditor_OpenOCLStdLibEditor() throws Exception {
        this.doTestEditor("org.eclipse.ocl.xtext.oclstdlib.OCLstdlib", "test.oclstdlib", "import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary test : xxx = 'http://www.eclipse.org/ocl/2015/Library' { }");
    }

    public void testEditor_OpenOCLStdLibEditor4OCL_OCLstdlib() throws Exception {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.ocl.pivot/model/OCL-2.5.oclstdlib", (boolean)true);
        String documentText = this.doTestEditor("org.eclipse.ocl.xtext.oclstdlib.OCLstdlib", uri);
        EditorTests.assertTrue((boolean)documentText.contains("type UniqueCollection(T) : CollectionType conformsTo Collection(T) {"));
    }

    public void testEditor_OpenOCLinEcoreEditor4Ecore_Ecore() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            URI uri = URI.createPlatformPluginURI((String)"org.eclipse.emf.ecore/model/Ecore.ecore", (boolean)true);
            String documentText = this.doTestEditor("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", uri);
            EditorTests.assertTrue((boolean)documentText.contains("abstract class ETypedElement extends ENamedElement"));
            EditorTests.assertEquals((String)("Conflicting access to 'http://www.eclipse.org/emf/2002/Ecore' already accessed as '" + uri.toString() + "'"), (String)TestCaseLogger.INSTANCE.get());
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    public void zztestEditor_OpenOCLinEcoreEditor4Pivot_Ecore() throws Exception {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        String documentText = this.doTestEditor("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", uri);
        EditorTests.assertTrue((boolean)documentText.contains("abstract class Visitable : 'org.eclipse.ocl.pivot.util.Visitable' { interface };"));
        EditorTests.assertTrue((boolean)documentText.contains("reference Type::ownedAttribute"));
    }

    public void zztestEditor_OpenOCLinEcoreEditor4Test_Ecore_Update() throws Exception {
        int i;
        String testDocument = "package tutorial : tuttut = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Library\n\t{\n\t\tproperty books#library : Book[*] { composes };\n\t}\n\tclass Book\n\t{\n\t\tproperty library#books : Library[?];\n\t}\n}\n";
        FileEditorInput fileEditorInput = this.createEcoreFileEditorInput("test", "RefreshTest.ecore", testDocument);
        XtextEditor editor = this.doTestEditor("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", fileEditorInput);
        XtextDocument document = (XtextDocument)editor.getDocument();
        Set<EObject> oldPivotContent = this.indexPivotContent(document, "Loaded pivot");
        oldPivotContent.toString();
        IProject iProject = this.createProject("test");
        IFile iFile = iProject.getFile("RefreshTest.ecore");
        InputStreamReader reader = new InputStreamReader(iFile.getContents());
        char[] cbuf = new char[4096];
        StringBuilder s = new StringBuilder();
        while ((i = reader.read(cbuf)) > 0) {
            s.append(cbuf, 0, i);
        }
        String updatedDocument = s.toString().replace("tuttut", "tut");
        iFile.setContents((InputStream)new URIConverter.ReadableInputStream(updatedDocument, "UTF-8"), true, false, null);
        TestUIUtil.flushEvents();
        String newDoc = document.get();
        Set<EObject> newPivotContent = this.indexPivotContent(document, "Loaded pivot");
        EditorTests.assertEquals((int)oldPivotContent.size(), (int)newPivotContent.size());
        TestUIUtil.flushEvents();
        EditorTests.assertEquals(oldPivotContent, newPivotContent);
        TestUIUtil.flushEvents();
        this.doTearDown(editor);
    }
}

