/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.CustomSegmentSupport;
import org.eclipse.ocl.examples.xtext.serializer.PostCommentSerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.PreCommentSerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.UserElementFormatter;
import org.eclipse.ocl.examples.xtext.serializer.UserElementSerializer;
import org.eclipse.xtext.nodemodel.INode;

public interface SerializationSegment {
    public static final @NonNull SerializationSegment HALF_NEW_LINE = new StringSerializationSegment(SerializationBuilder.HALF_NEW_LINE);
    public static final @NonNull SerializationSegment NEW_LINE = new StringSerializationSegment(SerializationBuilder.NEW_LINE);
    public static final @NonNull SerializationSegment NO_SPACE = new StringSerializationSegment(SerializationBuilder.NO_SPACE);
    public static final @NonNull SerializationSegment POP = new ControlSerializationSegment(SerializationBuilder.POP);
    public static final @NonNull SerializationSegment POST_COMMENT = new PostCommentSerializationSegment();
    public static final @NonNull SerializationSegment PRE_COMMENT = new PreCommentSerializationSegment();
    public static final @NonNull SerializationSegment PUSH = new ControlSerializationSegment(SerializationBuilder.PUSH);
    public static final @NonNull SerializationSegment PUSH_NEXT = new ControlSerializationSegment(SerializationBuilder.PUSH_NEXT);
    public static final @NonNull SerializationSegment SOFT_NEW_LINE = new StringSerializationSegment(SerializationBuilder.SOFT_NEW_LINE);
    public static final @NonNull SerializationSegment SOFT_SPACE = new StringSerializationSegment(SerializationBuilder.SOFT_SPACE);
    public static final @NonNull SerializationSegment VALUE = new ValueSerializationSegment();
    public static final @NonNull SerializationSegment WRAP_ANCHOR = new ControlSerializationSegment(SerializationBuilder.WRAP_ANCHOR);
    public static final @NonNull SerializationSegment WRAP_BEGIN_ALL = new ControlSerializationSegment(SerializationBuilder.WRAP_BEGIN_ALL);
    public static final @NonNull SerializationSegment WRAP_BEGIN_SOME = new ControlSerializationSegment(SerializationBuilder.WRAP_BEGIN_SOME);
    public static final @NonNull SerializationSegment WRAP_END = new ControlSerializationSegment(SerializationBuilder.WRAP_END);
    public static final @NonNull SerializationSegment WRAP_HERE = new ControlSerializationSegment(SerializationBuilder.WRAP_HERE);
    public static final @NonNull SerializationSegment @NonNull [] VALUE_SEGMENTS_ARRAY = new SerializationSegment[]{VALUE};
    public static final @NonNull List<@NonNull SerializationSegment> VALUE_SEGMENTS_LIST = Lists.newArrayList((Object[])new SerializationSegment[]{VALUE});

    public void format(@NonNull UserElementFormatter var1, @NonNull SerializationBuilder var2);

    public boolean isControl();

    public boolean isValue();

    public void serialize(int var1, @NonNull UserElementSerializer var2, @NonNull SerializationBuilder var3);

    public @NonNull String toString();

    public static abstract class AbstractSerializationSegment
    implements SerializationSegment {
        @Override
        public boolean isControl() {
            return false;
        }

        @Override
        public boolean isValue() {
            return false;
        }
    }

    public static class ControlSerializationSegment
    extends StringSerializationSegment {
        public ControlSerializationSegment(@NonNull String string) {
            super(string);
        }

        @Override
        public boolean isControl() {
            return true;
        }
    }

    public static class CustomSerializationSegment
    extends AbstractSerializationSegment {
        private @Nullable String supportClassName;
        private @Nullable Class<?> supportClass;
        private @Nullable CustomSegmentSupport supportInstance = null;

        public CustomSerializationSegment(@NonNull String supportClassName) {
            this.supportClassName = supportClassName;
            this.supportClass = null;
            this.supportInstance = null;
        }

        public CustomSerializationSegment(@NonNull Class<?> supportClass) {
            this.supportClassName = null;
            this.supportClass = supportClass;
            this.supportInstance = null;
        }

        public @NonNull String getSupportClassName() {
            if (this.supportClassName != null) {
                return this.supportClassName;
            }
            assert (this.supportClass != null);
            @NonNull String castName = this.supportClass.getName();
            return castName;
        }

        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            CustomSegmentSupport supportInstance2 = this.getSupportInstance(formatter.getElement());
            if (supportInstance2 == null) {
                serializationBuilder.appendError("\n\n\u00abmissing " + this.getSupportClassName() + "\u00bb\n\n");
            } else {
                supportInstance2.format(formatter, serializationBuilder);
            }
        }

        protected CustomSegmentSupport getSupportInstance(@NonNull EObject eObject) {
            CustomSegmentSupport supportInstance2 = this.supportInstance;
            if (supportInstance2 == null) {
                if (this.supportClass == null && this.supportClassName != null) {
                    ClassLoader classLoader = eObject.getClass().getClassLoader();
                    try {
                        this.supportClass = classLoader.loadClass(this.supportClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.supportClass != null) {
                    try {
                        this.supportInstance = supportInstance2 = (CustomSegmentSupport)this.supportClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
            }
            return supportInstance2;
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            CustomSegmentSupport supportInstance2 = this.getSupportInstance(serializer.getElement());
            if (supportInstance2 == null) {
                serializationBuilder.appendError("\n\n\u00abmissing " + this.getSupportClassName() + "\u00bb\n\n");
            } else {
                supportInstance2.serialize(serializationStepIndex, serializer, serializationBuilder);
            }
        }

        @Override
        public @NonNull String toString() {
            if (this.supportClass == PreCommentSerializationSegment.class) {
                return "pre-comment";
            }
            if (this.supportClass == PostCommentSerializationSegment.class) {
                return "post-comment";
            }
            return this.getSupportClassName();
        }
    }

    public static class StringSerializationSegment
    extends AbstractSerializationSegment {
        protected final @NonNull String string;

        public StringSerializationSegment(@NonNull String string) {
            this.string = string;
        }

        public @NonNull String getString() {
            return this.string;
        }

        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(this.string);
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(this.string);
        }

        @Override
        public @NonNull String toString() {
            return this.string;
        }
    }

    public static class ValueSerializationSegment
    extends AbstractSerializationSegment {
        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            INode node = formatter.getNode();
            String text = node.getText();
            serializationBuilder.append(text);
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            SerializationRule serializationRule = serializer.getSerializationRule();
            SerializationStep serializationStep = serializationRule.getSerializationSteps()[serializationStepIndex];
            serializationStep.serializeInnerValue(serializationStepIndex, serializer, serializationBuilder);
        }

        @Override
        public @NonNull String toString() {
            return SerializationBuilder.VALUE;
        }
    }
}

