/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.VariableExp;

public class OperationConstraintsTest
extends AbstractTestSuite {
    public void test_simplePrecondition() {
        this.parseConstraint("package ocltest context Fruit::ripen(color : Color) : Boolean pre: color <> Color::black endpackage");
    }

    public void test_simplePostcondition() {
        this.parseConstraint("package ocltest context Fruit::ripen(color : Color) : Boolean post: self.color = color endpackage");
    }

    public void test_passingOclInvalidToOperation() {
        this.parseConstraint("package ocltest context Fruit::ripen(color : Color) : Boolean body: color.oclIsInvalid() endpackage");
        OCLExpression query = this.parse("package ocltest context Apple inv: self.ripen(if 1.3 / 0 > 1.3 then Color::black else Color::red endif) endpackage");
        EObject anApple = this.fruitFactory.create(this.apple);
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        OperationConstraintsTest.assertTrue((boolean)((Boolean)this.evaluate(query, anApple)));
    }

    public void test_postcondition_atPre() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: color <> color@ pre implies color = c endpackage");
    }

    public void test_postcondition_atPre_operation() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: preferredColor() <> preferredColor@pre() implies color = c endpackage");
    }

    public void test_postcondition_result() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: result implies color <> color@pre endpackage");
    }

    public void test_namespaces() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre notBlack: let ok : Boolean = c <> Color::black in   ok pre different: let ok : Boolean = c <> color in   ok body: let b : Boolean = c <> color in   b implies color <> Color::black post worked: result implies color <> color@pre endpackage");
    }

    public void test_illegalUseOfAtPre_precondition() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: c <> color@pre endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_illegalUseOfAtPre_invariant() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit inv: color@pre <> Color::black endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_illegalUseOfAtPre_postcondition() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: let oldColor : Color = color in c <> oldColor@pre endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_variablesHidingAttributes() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: let color : Boolean = (c = self.color) in   color implies c <> Color::black endpackage");
    }

    public void test_parametersAreLocalVariables() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: color : Boolean = (c = self.color) in   color implies c <> Color::black endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
    }

    public void test_bodyConditionConformance() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::preferredColor() : Color body: result = (if true then 'red' else 'brown' endif) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newApple() : Apple body: result = self.newFruit() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newFruit() : Fruit body: result = self.newApple() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.err.println("Got unexpected error: " + e.getLocalizedMessage());
        }
        OperationConstraintsTest.assertNull((Object)((Object)err));
    }

    public void test_bodyConditionVoidOperation() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Apple::label(newLabel : String) : body: result = (if true then 'Spy' else 'Spartan' endif) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
    }

    public void test_parameterNameCoincidesWithAttributeName_140008() {
        this.expectModified = true;
        EOperation foo = EcoreFactory.eINSTANCE.createEOperation();
        foo.setName("foo");
        EParameter parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("str");
        parm.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        foo.getEParameters().add((Object)parm);
        foo.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        this.apple.getEOperations().add((Object)foo);
        EAttribute myStr = EcoreFactory.eINSTANCE.createEAttribute();
        myStr.setName("str");
        myStr.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        this.apple.getEStructuralFeatures().add((Object)myStr);
        try {
            OCLExpression expr = this.parseConstraint("package ocltest context Apple::foo(str : String) : String body: result = (if str = self.str then '' else str endif) endpackage");
            int propertyCalls = 0;
            int variableCalls = 0;
            TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(expr));
            while (iter.hasNext()) {
                VariableExp v;
                Object next = iter.next();
                if (next instanceof PropertyCallExp) {
                    PropertyCallExp pc = (PropertyCallExp)next;
                    if (!"str".equals(((EStructuralFeature)pc.getReferredProperty()).getName())) continue;
                    ++propertyCalls;
                    continue;
                }
                if (!(next instanceof VariableExp) || !"str".equals((v = (VariableExp)next).getReferredVariable().getName())) continue;
                ++variableCalls;
            }
            OperationConstraintsTest.assertEquals((String)"property calls", (int)1, (int)propertyCalls);
            OperationConstraintsTest.assertEquals((String)"variable calls", (int)2, (int)variableCalls);
        }
        finally {
            this.apple.getEOperations().remove((Object)foo);
            this.apple.getEStructuralFeatures().remove((Object)myStr);
        }
    }

    public void test_implicitPropertySourceLookup_raw_151234() {
        OCLExpression expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: color <> newColor endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OperationCallExp notEquals = (OperationCallExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
        PropertyCallExp propertyCall = (PropertyCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
        VariableExp var = (VariableExp)propertyCall.getSource();
        OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
        expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: Fruit.allInstances()->forAll(color <> newColor) endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
        IteratorExp forAll = (IteratorExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
        notEquals = (OperationCallExp)forAll.getBody();
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
        propertyCall = (PropertyCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
        var = (VariableExp)propertyCall.getSource();
        OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
    }

    public void test_implicitPropertySourceLookup_helper_151234() {
        try {
            this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_setColor);
            OCLExpression expr = ((Constraint)this.helper.createPrecondition("color <> newColor")).getSpecification().getBodyExpression();
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp notEquals = (OperationCallExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
            VariableExp var = (VariableExp)propertyCall.getSource();
            OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
            expr = ((Constraint)this.helper.createPrecondition("Fruit.allInstances()->forAll(color <> newColor)")).getSpecification().getBodyExpression();
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
            IteratorExp forAll = (IteratorExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
            notEquals = (OperationCallExp)forAll.getBody();
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
            propertyCall = (PropertyCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
            var = (VariableExp)propertyCall.getSource();
            OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
        }
        catch (ParserException e) {
            OperationConstraintsTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_implicitOperationSourceLookup_raw_151234() {
        OCLExpression expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: preferredColor() <> newColor endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OperationCallExp notEquals = (OperationCallExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
        OperationCallExp operationCall = (OperationCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
        VariableExp var = (VariableExp)operationCall.getSource();
        OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
        expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: Fruit.allInstances()->forAll(preferredColor() <> newColor) endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
        IteratorExp forAll = (IteratorExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
        notEquals = (OperationCallExp)forAll.getBody();
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
        operationCall = (OperationCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
        var = (VariableExp)operationCall.getSource();
        OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
    }

    public void test_implicitOperationSourceLookup_helper_151234() {
        try {
            this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_setColor);
            OCLExpression expr = ((Constraint)this.helper.createPrecondition("preferredColor() <> newColor")).getSpecification().getBodyExpression();
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp notEquals = (OperationCallExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
            OperationCallExp operationCall = (OperationCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
            VariableExp var = (VariableExp)operationCall.getSource();
            OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
            expr = ((Constraint)this.helper.createPrecondition("Fruit.allInstances()->forAll(preferredColor() <> newColor)")).getSpecification().getBodyExpression();
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
            IteratorExp forAll = (IteratorExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
            notEquals = (OperationCallExp)forAll.getBody();
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
            operationCall = (OperationCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
            var = (VariableExp)operationCall.getSource();
            OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
        }
        catch (ParserException e) {
            OperationConstraintsTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_bodyExpressionConformance_185345() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::preferredColor() : Color body: if true then 'red' else 'brown' endif endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newApple() : Apple body: self.newFruit() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newFruit() : Fruit body: self.newApple() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.err.println("Got unexpected error: " + e.getLocalizedMessage());
        }
        OperationConstraintsTest.assertNull((Object)((Object)err));
    }

    public void test_bodyExpressionResultUsage_185345() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Apple::preferredLabel(text : String) : String body: if true then text else result endif endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        this.parseConstraint("package ocltest context Apple::preferredLabel(result : String) : String body: if true then 'me' else result endif endpackage");
    }

    public void test_bodyExpressionEvaluation_185345() {
        this.parseConstraint("package ocltest context Fruit::preferredColor() : Color body: if color = Color::black then Color::red else Color::black endif endpackage");
        OCLExpression query = this.parse("package ocltest context Apple inv: self.preferredColor() endpackage");
        EObject anApple = this.fruitFactory.create(this.apple);
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        OperationConstraintsTest.assertSame((Object)this.color_red, (Object)this.evaluate(query, anApple));
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_green);
        OperationConstraintsTest.assertSame((Object)this.color_black, (Object)this.evaluate(query, anApple));
    }
}

