/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorClass;
import org.eclipse.ocl.pivot.internal.library.executor.DomainProperties;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorFragment;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeArgument;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.types.AbstractInheritance;
import org.eclipse.ocl.pivot.utilities.ArrayIterable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.OCLValue;

public abstract class ExecutorType
extends AbstractExecutorClass
implements ExecutorTypeArgument {
    private @NonNull ExecutorFragment @Nullable [] fragments = null;
    private int[] indexes = null;
    protected final @NonNull Package evaluationPackage;
    private final @NonNull TemplateParameters typeParameters;
    private DomainProperties allProperties;

    public ExecutorType(@NonNull String name, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, flags);
        this.evaluationPackage = evaluationPackage;
        this.typeParameters = TypeUtil.createTemplateParameters(typeParameters);
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        CompleteInheritance thatInheritance = type.getInheritance(standardLibrary);
        if (this == thatInheritance) {
            return true;
        }
        return thatInheritance.isSuperInheritanceOf(this);
    }

    @Override
    public Class flattenedType() {
        return this;
    }

    public final  @NonNull AbstractInheritance.FragmentIterable getAllProperSuperFragments() {
        @NonNull InheritanceFragment @NonNull [] fragments2 = ClassUtil.nonNullState(this.fragments);
        return new AbstractInheritance.FragmentIterable(fragments2, 0, fragments2.length - 1);
    }

    public  @NonNull AbstractInheritance.FragmentIterable getAllSuperFragments() {
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments));
    }

    @Override
    public @NonNull Type getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (this == type) {
            return this.getPivotClass();
        }
        ExecutorType firstInheritance = this;
        CompleteInheritance secondInheritance = type.getInheritance(idResolver.getStandardLibrary());
        CompleteInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance.getPivotClass();
    }

    @Override
    public int getDepth() {
        return this.indexes.length - 2;
    }

    @Override
    public @NonNull Iterable<@NonNull InheritanceFragment> getFragments() {
        return new ArrayIterable<InheritanceFragment>(this.fragments);
    }

    @Override
    public @NonNull ExecutorFragment getFragment(int fragmentNumber) {
        return ClassUtil.nonNullState(this.fragments)[fragmentNumber];
    }

    @Override
    public int getIndex(int fragmentNumber) {
        return this.indexes[fragmentNumber];
    }

    @Override
    public int getIndexes() {
        return this.indexes.length;
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull StandardLibrary standardLibrary) {
        return this;
    }

    @Override
    public @Nullable Operation getMemberOperation(@NonNull OperationId operationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Property getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties(this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getNormalizedType(@NonNull StandardLibrary standardLibrary) {
        return this;
    }

    @Override
    public @NonNull List<Constraint> getOwnedInvariants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<Property> getOwnedProperties() {
        return this.getSelfFragment().getLocalProperties();
    }

    @Override
    public @NonNull List<Operation> getOwnedOperations() {
        return this.getSelfFragment().getLocalOperations();
    }

    @Override
    public @NonNull Package getOwningPackage() {
        return this.evaluationPackage;
    }

    @Override
    public @NonNull List<Constraint> getOwnedConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getPivotClass() {
        return this;
    }

    @Override
    public @NonNull ExecutorFragment getSelfFragment() {
        return this.getFragment(ClassUtil.nonNullState(this.fragments).length - 1);
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return OCLstdlibTables.LIBRARY;
    }

    @Override
    public @NonNull List<Class> getSuperClasses() {
        return this.getSelfFragment().getSuperClasses();
    }

    public final  @NonNull AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments), this.indexes[depth], this.indexes[depth + 1]);
    }

    @Override
    public @NonNull TemplateParameters getTypeParameters() {
        return this.typeParameters;
    }

    public void initFragments(@NonNull ExecutorFragment @NonNull [] fragments, int[] depthCounts) {
        int[] indexes = new int[depthCounts.length + 1];
        indexes[0] = 0;
        int i = 0;
        while (i < depthCounts.length) {
            indexes[i + 1] = indexes[i] + depthCounts[i];
            ++i;
        }
        this.fragments = fragments;
        this.indexes = indexes;
    }

    @Override
    public @NonNull Class isClass() {
        return this;
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        return this == type;
    }

    @Override
    public boolean isEqualToUnspecializedType(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        return this == type;
    }

    @Override
    public boolean isOrdered() {
        return (this.flags & 1) != 0;
    }

    @Override
    public @Nullable TemplateParameter isTemplateParameter() {
        return null;
    }

    @Override
    public boolean isUnique() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean oclEquals(@NonNull OCLValue thatValue) {
        if (!(thatValue instanceof Type)) {
            return false;
        }
        TypeId thisTypeId = this.getTypeId();
        TypeId thatTypeId = ((Type)thatValue).getTypeId();
        return thisTypeId.equals(thatTypeId);
    }

    @Override
    public int oclHashCode() {
        return this.getTypeId().hashCode();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.evaluationPackage)) + "::" + String.valueOf(this.name);
    }
}

