/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.logical;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class BooleanXorOperation
extends AbstractSimpleBinaryOperation {
    public static final @NonNull BooleanXorOperation INSTANCE = new BooleanXorOperation();

    @Override
    public @Nullable Boolean evaluate(@Nullable Object left, @Nullable Object right) {
        if (left instanceof InvalidValueException) {
            throw (InvalidValueException)left;
        }
        if (right instanceof InvalidValueException) {
            throw (InvalidValueException)right;
        }
        if (left == null || right == null) {
            return null;
        }
        if (left == Boolean.FALSE) {
            if (right == Boolean.TRUE) {
                return TRUE_VALUE;
            }
            if (right == Boolean.FALSE) {
                return FALSE_VALUE;
            }
        } else if (left == Boolean.TRUE) {
            if (right == Boolean.TRUE) {
                return FALSE_VALUE;
            }
            if (right == Boolean.FALSE) {
                return TRUE_VALUE;
            }
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Boolean", BooleanXorOperation.getTypeName(left));
    }
}

