/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;

public class NameUtil {
    public static final @NonNull ENamedElementComparator ENAMED_ELEMENT_COMPARATOR = ENamedElementComparator.INSTANCE;
    public static final @NonNull NameableComparator NAMEABLE_COMPARATOR = NameableComparator.INSTANCE;
    public static final @NonNull ToStringComparator TO_STRING_COMPARATOR = ToStringComparator.INSTANCE;

    public static String debugFullName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String debugSimpleName(Object object) {
        if (object == null) {
            return "null";
        }
        String name = object.getClass().getName();
        int lastIndex = name.lastIndexOf(".");
        return String.valueOf(lastIndex >= 0 ? name.substring(lastIndex + 1) : name) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static <T extends ENamedElement> @Nullable T getENamedElement(@Nullable Iterable<T> elements, @Nullable String name) {
        if (elements == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (element == null || !ClassUtil.safeEquals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static <T extends ENamedElement, R extends T> @Nullable R getENamedElement(@Nullable Iterable<T> elements, @Nullable String name, @Nullable Class<R> returnClass) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (returnClass == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (element == null || !returnClass.isAssignableFrom(element.getClass()) || !ClassUtil.safeEquals(name, element.getName())) continue;
            return (R)element;
        }
        return null;
    }

    public static <T extends Nameable> @Nullable T getNameable(@Nullable Iterable<T> elements, @Nullable String name) {
        if (elements == null) {
            return null;
        }
        for (Nameable element : elements) {
            if (element == null || !ClassUtil.safeEquals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static @Nullable String getOriginalName(@NonNull ENamedElement eNamedElement) {
        String originalName;
        EAnnotation eAnnotation = eNamedElement.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && (originalName = (String)eAnnotation.getDetails().get((Object)"originalName")) != null) {
            return originalName;
        }
        return eNamedElement.getName();
    }

    public static @NonNull String getSafeName(@Nullable Nameable aNameable) {
        if (aNameable == null) {
            return "";
        }
        String name = aNameable.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static @NonNull String qualifiedNameFor(@Nullable Object object) {
        if (object == null) {
            return "\u00abnull\u00bb";
        }
        HashMap options = new HashMap();
        options.put(ILabelGenerator.Builder.SHOW_QUALIFIER, "::");
        return LabelUtil.QUALIFIED_NAME_REGISTRY.labelFor(object, options);
    }

    public static void setOriginalName(@NonNull ENamedElement eNamedElement, @NonNull String originalName) {
        EAnnotation eAnnotation = eNamedElement.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/uml2/2.0.0/UML");
            eNamedElement.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)"originalName", (Object)originalName);
    }

    public static @NonNull String simpleNameFor(@Nullable Object object) {
        if (object == null) {
            return "\u00abnull\u00bb";
        }
        return LabelUtil.SIMPLE_NAME_REGISTRY.labelFor(object);
    }

    public static final class EAnnotationComparator
    implements Comparator<EAnnotation> {
        public static final @NonNull EAnnotationComparator INSTANCE = new EAnnotationComparator();

        @Override
        public int compare(EAnnotation o1, EAnnotation o2) {
            String n1 = o1.getSource();
            String n2 = o2.getSource();
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }

    public static final class ENamedElementComparator
    implements Comparator<ENamedElement> {
        public static final @NonNull ENamedElementComparator INSTANCE = new ENamedElementComparator();

        @Override
        public int compare(ENamedElement o1, ENamedElement o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }

    public static final class NameableComparator
    implements Comparator<Nameable> {
        public static final @NonNull NameableComparator INSTANCE = new NameableComparator();

        @Override
        public int compare(Nameable o1, Nameable o2) {
            String n1 = NameUtil.getSafeName(o1);
            String n2 = NameUtil.getSafeName(o2);
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }

    public static final class ToStringComparator
    implements Comparator<Object> {
        public static final @NonNull ToStringComparator INSTANCE = new ToStringComparator(null);
        private final Map<@NonNull Object, String> object2string;

        public ToStringComparator() {
            this(new HashMap<Object, String>());
        }

        protected ToStringComparator(@Nullable Map<@NonNull Object, String> object2string) {
            this.object2string = object2string;
        }

        @Override
        public int compare(@NonNull Object o1, @NonNull Object o2) {
            if (this.object2string == null) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                return ClassUtil.safeCompareTo(s1, s2);
            }
            String s1 = this.getString(o1);
            String s2 = this.getString(o2);
            return ClassUtil.safeCompareTo(s1, s2);
        }

        private String getString(@NonNull Object o) {
            String string = this.object2string.get(o);
            if (string == null) {
                string = o.toString();
                this.object2string.put(o, string);
            }
            return string;
        }
    }
}

