/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.xtext.base.ui.labeling.BaseLabelProvider;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.TemplateParameterCS;
import org.eclipse.ocl.xtext.basecs.TuplePartCS;
import org.eclipse.ocl.xtext.basecs.TupleTypeCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.essentialoclcs.BooleanLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InvalidLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NullLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NumberLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.OperatorExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.SelfExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.StringLiteralExpCS;

public class EssentialOCLLabelProvider
extends BaseLabelProvider {
    @Inject
    public EssentialOCLLabelProvider(@NonNull AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected void appendTemplateParameter(@NonNull StringBuilder s, TemplateParameterCS templateParameter) {
        this.appendName(s, (NamedElementCS)templateParameter);
    }

    protected void appendType(@NonNull StringBuilder s, Type type) {
        if (type instanceof CollectionTypeCS) {
            this.appendName(s, (Nameable)((CollectionTypeCS)type));
            s.append("(");
            this.appendType(s, (TypeRefCS)((CollectionTypeCS)type).getOwnedType());
            s.append(")");
        } else if (type instanceof TupleTypeCS) {
            this.appendName(s, (Nameable)((TupleTypeCS)type));
            s.append("Tuple(");
            String prefix = "";
            for (TuplePartCS part : ((TupleTypeCS)type).getOwnedParts()) {
                s.append(prefix);
                this.appendName(s, (NamedElementCS)part);
                s.append(" : ");
                this.appendType(s, (TypeRefCS)part.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        } else if (!(type instanceof NameExpCS)) {
            super.appendType(s, type);
        }
    }

    protected String text(BooleanLiteralExpCS ele) {
        return String.valueOf(ele.getSymbol());
    }

    protected String text(ExpCS ele) {
        return "<<" + ele.eClass().getName() + ">>";
    }

    protected String text(InvalidLiteralExpCS ele) {
        return "invalid";
    }

    protected String text(NameExpCS ele) {
        return String.valueOf(ele.getOwnedPathName().toString());
    }

    protected String text(NavigatingArgCS ele) {
        return "<" + String.valueOf(ele.getRole()).toLowerCase() + ">";
    }

    protected String text(NestedExpCS ele) {
        return "(   )";
    }

    protected String text(NullLiteralExpCS ele) {
        return "null";
    }

    protected String text(NumberLiteralExpCS ele) {
        return String.valueOf(ele.getSymbol());
    }

    protected String image(OperatorExpCS ele) {
        return "/org.eclipse.ocl.edit/icons/full/obj16/OperationCallExp.gif";
    }

    protected String text(OperatorExpCS ele) {
        return String.valueOf(ele.getName());
    }

    protected String image(SelfExpCS ele) {
        return "/org.eclipse.ocl.edit/icons/full/obj16/VariableExp.gif";
    }

    protected String text(SelfExpCS ele) {
        return "self";
    }

    protected String text(StringLiteralExpCS ele) {
        return String.valueOf(ele.getSegments());
    }
}

