/*
 * Decompiled with CFR 0.152.
 */
package data.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ObjectState implements Enumerator
{
    INITIAL(0, "INITIAL", "INITIAL"),
    TRANSIENT(1, "TRANSIENT", "TRANSIENT"),
    SAVED(2, "SAVED", "SAVED"),
    ACTIVE(3, "ACTIVE", "ACTIVE"),
    COMPLIANT(4, "COMPLIANT", "COMPLIANT");

    public static final int INITIAL_VALUE = 0;
    public static final int TRANSIENT_VALUE = 1;
    public static final int SAVED_VALUE = 2;
    public static final int ACTIVE_VALUE = 3;
    public static final int COMPLIANT_VALUE = 4;
    private static final ObjectState[] VALUES_ARRAY;
    public static final List<ObjectState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectState[]{INITIAL, TRANSIENT, SAVED, ACTIVE, COMPLIANT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectState get(int value) {
        switch (value) {
            case 0: {
                return INITIAL;
            }
            case 1: {
                return TRANSIENT;
            }
            case 2: {
                return SAVED;
            }
            case 3: {
                return ACTIVE;
            }
            case 4: {
                return COMPLIANT;
            }
        }
        return null;
    }

    private ObjectState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

