/*
 * Decompiled with CFR 0.152.
 */
package integration.binding.util;

import integration.binding.Binding;
import integration.binding.BindingPackage;
import integration.binding.HttpBinding;
import integration.binding.HttpGetBinding;
import integration.binding.HttpPutBinding;
import integration.binding.RestUrlPattern;
import integration.binding.SimpleUrlPattern;
import integration.binding.UrlPattern;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingValidator
extends EObjectValidator {
    public static final BindingValidator INSTANCE = new BindingValidator();
    public static final String DIAGNOSTIC_SOURCE = "integration.binding";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String BINDING__FUNCTION_EXPRESSION_HAS_FUNCTION_TYPE__EEXPRESSION = "self.function.getType().oclIsKindOf(data::classes::FunctionSignatureTypeDefinition)";

    protected EPackage getEPackage() {
        return BindingPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateBinding((Binding)value, diagnostics, context);
            }
            case 1: {
                return this.validateHttpBinding((HttpBinding)value, diagnostics, context);
            }
            case 2: {
                return this.validateHttpGetBinding((HttpGetBinding)value, diagnostics, context);
            }
            case 3: {
                return this.validateHttpPutBinding((HttpPutBinding)value, diagnostics, context);
            }
            case 4: {
                return this.validateUrlPattern((UrlPattern)value, diagnostics, context);
            }
            case 5: {
                return this.validateSimpleUrlPattern((SimpleUrlPattern)value, diagnostics, context);
            }
            case 6: {
                return this.validateRestUrlPattern((RestUrlPattern)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateBinding(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(binding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(binding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinding_FunctionExpressionHasFunctionType(binding, diagnostics, context);
        }
        return result;
    }

    public boolean validateBinding_FunctionExpressionHasFunctionType(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(BindingPackage.Literals.BINDING, binding, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FunctionExpressionHasFunctionType", BINDING__FUNCTION_EXPRESSION_HAS_FUNCTION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateHttpBinding(HttpBinding httpBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(httpBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(httpBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(httpBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinding_FunctionExpressionHasFunctionType(httpBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateHttpGetBinding(HttpGetBinding httpGetBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(httpGetBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(httpGetBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(httpGetBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinding_FunctionExpressionHasFunctionType(httpGetBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateHttpPutBinding(HttpPutBinding httpPutBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(httpPutBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(httpPutBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(httpPutBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinding_FunctionExpressionHasFunctionType(httpPutBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateUrlPattern(UrlPattern urlPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(urlPattern, diagnostics, context);
    }

    public boolean validateSimpleUrlPattern(SimpleUrlPattern simpleUrlPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(simpleUrlPattern, diagnostics, context);
    }

    public boolean validateRestUrlPattern(RestUrlPattern restUrlPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(restUrlPattern, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

