/*
 * Decompiled with CFR 0.152.
 */
package persistence.actions.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import persistence.actions.ActionsPackage;
import persistence.actions.Delete;
import persistence.actions.Rollback;
import persistence.actions.StatementWithEntityArgument;
import persistence.actions.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsValidator
extends EObjectValidator {
    public static final ActionsValidator INSTANCE = new ActionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "persistence.actions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String STATEMENT_WITH_ENTITY_ARGUMENT__CAN_STORE_ONLY_ENTITIES__EEXPRESSION = "if self.argument.getType().oclIsKindOf(data::classes::ClassTypeDefinition) then\r\n    not self.argument.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.valueType\r\n  else\r\n    false\r\n  endif";

    protected EPackage getEPackage() {
        return ActionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateStore((Store)value, diagnostics, context);
            }
            case 1: {
                return this.validateDelete((Delete)value, diagnostics, context);
            }
            case 2: {
                return this.validateStatementWithEntityArgument((StatementWithEntityArgument)value, diagnostics, context);
            }
            case 3: {
                return this.validateRollback((Rollback)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateStore(Store store, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(store, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(store, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(store, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStatementWithEntityArgument_CanStoreOnlyEntities(store, diagnostics, context);
        }
        return result;
    }

    public boolean validateDelete(Delete delete, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(delete, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(delete, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStatementWithEntityArgument_CanStoreOnlyEntities(delete, diagnostics, context);
        }
        return result;
    }

    public boolean validateStatementWithEntityArgument(StatementWithEntityArgument statementWithEntityArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(statementWithEntityArgument, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(statementWithEntityArgument, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(statementWithEntityArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStatementWithEntityArgument_CanStoreOnlyEntities(statementWithEntityArgument, diagnostics, context);
        }
        return result;
    }

    public boolean validateStatementWithEntityArgument_CanStoreOnlyEntities(StatementWithEntityArgument statementWithEntityArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.STATEMENT_WITH_ENTITY_ARGUMENT, statementWithEntityArgument, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CanStoreOnlyEntities", STATEMENT_WITH_ENTITY_ARGUMENT__CAN_STORE_ONLY_ENTITIES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRollback(Rollback rollback, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rollback, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

