/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.validation;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.validation.LoadableConstraintProvider;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.resource.UMLResource;

public class UMLProfileConstraintProvider
extends LoadableConstraintProvider {
    private static final Logger logger = Logger.getLogger(UMLProfileConstraintProvider.class);

    @Override
    protected boolean load(@NonNull EnvironmentFactory environmentFactory, @NonNull URI uri, @NonNull Set<@NonNull Category> categories) {
        Resource asResource;
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        UMLResource umlResource = null;
        try {
            umlResource = (UMLResource)resourceSet.getResource(uri, true);
        }
        catch (WrappedException e) {
            logger.error((Object)("Failed to load '" + uri), (Throwable)e);
            throw e;
        }
        EList errors = umlResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + uri + message));
            return false;
        }
        try {
            UML2AS uml2as = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)environmentFactory);
            Model pivotModel = uml2as.getASModel();
            asResource = (Resource)ClassUtil.nonNullState((Object)pivotModel.eResource());
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to load Pivot from '" + uri + "': "), (Throwable)e);
            return false;
        }
        return this.installResource(asResource, categories);
    }
}

