/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collections;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class OperationConstraintsTest
extends AbstractTestSuite {
    public void test_simplePrecondition() {
        this.parseConstraint("package ocltest context Fruit::ripen(color : Color) : Boolean pre: color <> Color::black endpackage");
    }

    public void test_simplePostcondition() {
        this.parseConstraint("package ocltest context Fruit::ripen(color : Color) : Boolean post: self.color = color endpackage");
    }

    public void test_postcondition_atPre() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: color <> color@ pre implies color = c endpackage");
    }

    public void test_postcondition_atPre_operation() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: preferredColor() <> preferredColor@pre() implies color = c endpackage");
    }

    public void test_postcondition_result() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: result implies color <> color@pre endpackage");
    }

    public void test_namespaces() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre notBlack: let ok : Boolean = c <> Color::black in   ok pre different: let ok : Boolean = c <> color in   ok body: let b : Boolean = c <> color in   result = b implies color <> Color::black post worked: result implies color <> color@pre endpackage");
    }

    public void test_illegalUseOfAtPre_precondition() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: c <> color@pre endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_illegalUseOfAtPre_invariant() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit inv: color@pre <> Color::black endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_illegalUseOfAtPre_postcondition() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: let oldColor : Color = color in c <> oldColor@pre endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((String)"Should not have succeeded in validating illegal @pre", (Object)((Object)err));
    }

    public void test_variablesHidingAttributes() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: let color : Boolean = (c = self.color) in   color implies c <> Color::black endpackage");
    }

    public void test_parametersAreLocalVariables() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean pre: color : Boolean = (c = self.color) in   color implies c <> Color::black endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
    }

    public void test_bodyConditionConformance() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Fruit::preferredColor() : Color body: result = (if true then 'red' else 'brown' endif) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newApple() : Apple body: result = self.newFruit() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
        err = null;
        try {
            this.parseConstraint("package ocltest context Apple::newFruit() : Fruit body: result = self.newApple() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.err.println("Got unexpected error: " + e.getLocalizedMessage());
        }
        OperationConstraintsTest.assertNull((Object)((Object)err));
    }

    public void test_bodyConditionVoidOperation() {
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ocltest context Apple::label(newLabel : String) : body: result = (if true then 'Spy' else 'Spartan' endif) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            OperationConstraintsTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        OperationConstraintsTest.assertNotNull((Object)((Object)err));
    }

    public void test_parameterNameCoincidesWithAttributeName_140008() {
        this.expectModified = true;
        Operation foo = this.apple.createOwnedOperation("foo", (EList)new BasicEList(Collections.singleton("str")), (EList)new BasicEList(Collections.singleton((Type)this.getUMLString())), (Type)this.getUMLString());
        Property myStr = this.apple.createOwnedAttribute("str", (Type)this.getUMLString());
        try {
            OCLExpression expr = this.parseConstraint("package ocltest context Apple::foo(str : String) : String body: result = (if str = self.str then '' else str endif) endpackage");
            int propertyCalls = 0;
            int variableCalls = 0;
            TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(expr));
            while (iter.hasNext()) {
                VariableExp v;
                Object next = iter.next();
                if (next instanceof PropertyCallExp) {
                    PropertyCallExp pc = (PropertyCallExp)next;
                    if (!"str".equals(((Property)pc.getReferredProperty()).getName())) continue;
                    ++propertyCalls;
                    continue;
                }
                if (!(next instanceof VariableExp) || !"str".equals((v = (VariableExp)next).getReferredVariable().getName())) continue;
                ++variableCalls;
            }
            OperationConstraintsTest.assertEquals((String)"property calls", (int)1, (int)propertyCalls);
            OperationConstraintsTest.assertEquals((String)"variable calls", (int)2, (int)variableCalls);
        }
        finally {
            this.apple.getOwnedOperations().remove((Object)foo);
            this.apple.getOwnedAttributes().remove((Object)myStr);
        }
    }

    public void test_implicitPropertySourceLookup_raw_151234() {
        OCLExpression expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: color <> newColor endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OperationCallExp notEquals = (OperationCallExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
        PropertyCallExp propertyCall = (PropertyCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
        VariableExp var = (VariableExp)propertyCall.getSource();
        OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
        expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: Fruit.allInstances()->forAll(color <> newColor) endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
        IteratorExp forAll = (IteratorExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
        notEquals = (OperationCallExp)forAll.getBody();
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
        propertyCall = (PropertyCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
        var = (VariableExp)propertyCall.getSource();
        OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
    }

    public void test_implicitPropertySourceLookup_helper_151234() {
        try {
            this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_setColor);
            OCLExpression expr = this.getBodyExpression((Constraint)this.helper.createPrecondition("color <> newColor"));
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp notEquals = (OperationCallExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
            VariableExp var = (VariableExp)propertyCall.getSource();
            OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
            expr = this.getBodyExpression((Constraint)this.helper.createPrecondition("Fruit.allInstances()->forAll(color <> newColor)"));
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
            IteratorExp forAll = (IteratorExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
            notEquals = (OperationCallExp)forAll.getBody();
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof PropertyCallExp));
            propertyCall = (PropertyCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(propertyCall.getSource() instanceof VariableExp));
            var = (VariableExp)propertyCall.getSource();
            OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
        }
        catch (ParserException e) {
            OperationConstraintsTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_implicitOperationSourceLookup_raw_151234() {
        OCLExpression expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: preferredColor() <> newColor endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OperationCallExp notEquals = (OperationCallExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
        OperationCallExp operationCall = (OperationCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
        VariableExp var = (VariableExp)operationCall.getSource();
        OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
        expr = this.parseConstraint("package ocltest context Apple::setColor(fruit : Fruit, newColor : Color) : pre: Fruit.allInstances()->forAll(preferredColor() <> newColor) endpackage");
        OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
        IteratorExp forAll = (IteratorExp)expr;
        OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
        notEquals = (OperationCallExp)forAll.getBody();
        OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
        operationCall = (OperationCallExp)notEquals.getSource();
        OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
        var = (VariableExp)operationCall.getSource();
        OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
    }

    public void test_implicitOperationSourceLookup_helper_151234() {
        try {
            this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_setColor);
            OCLExpression expr = this.getBodyExpression((Constraint)this.helper.createPrecondition("preferredColor() <> newColor"));
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp notEquals = (OperationCallExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
            OperationCallExp operationCall = (OperationCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
            VariableExp var = (VariableExp)operationCall.getSource();
            OperationConstraintsTest.assertEquals((String)"self", (String)var.getReferredVariable().getName());
            expr = this.getBodyExpression((Constraint)this.helper.createPrecondition("Fruit.allInstances()->forAll(preferredColor() <> newColor)"));
            OperationConstraintsTest.assertTrue((boolean)(expr instanceof IteratorExp));
            IteratorExp forAll = (IteratorExp)expr;
            OperationConstraintsTest.assertTrue((boolean)(forAll.getBody() instanceof OperationCallExp));
            notEquals = (OperationCallExp)forAll.getBody();
            OperationConstraintsTest.assertTrue((boolean)(notEquals.getSource() instanceof OperationCallExp));
            operationCall = (OperationCallExp)notEquals.getSource();
            OperationConstraintsTest.assertTrue((boolean)(operationCall.getSource() instanceof VariableExp));
            var = (VariableExp)operationCall.getSource();
            OperationConstraintsTest.assertTrue((boolean)var.getReferredVariable().getName().startsWith("temp"));
        }
        catch (ParserException e) {
            OperationConstraintsTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }
}

