/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;

public class PrimitiveTypesTest
extends AbstractTestSuite {
    public void test_unlimitedNaturalType() {
        OCLExpression expression = this.parse("package UML context MultiplicityElement inv: self.upper endpackage");
        PrimitiveTypesTest.assertSame((Object)this.ocl.getEnvironment().getOCLStandardLibrary().getUnlimitedNatural(), (Object)expression.getType());
    }

    public void test_unlimitedValue() {
        OCLExpression expression = this.parse("package UML context Class inv: let x : UnlimitedNatural = * in x endpackage");
        PrimitiveTypesTest.assertSame((Object)this.ocl.getEnvironment().getOCLStandardLibrary().getUnlimitedNatural(), (Object)expression.getType());
        Object result = this.evaluate(expression);
        PrimitiveTypesTest.assertEquals((Object)-1, (Object)result);
    }

    public void test_unlimitedValueComparison() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "2 = *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 <> *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 < *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 <= *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* > 2"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* >= 2"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* = *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* <> *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* < *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* <= *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* > *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* >= *"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_integers() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "2 + *"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "* + 2"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_reals() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 + *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 - *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 / *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 * *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0.min(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0.max(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* + 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* - 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* / 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* * 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.min(2.0)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.max(2.0)"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_naturals() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "*.round()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.floor()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.abs()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* + *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* - *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* / *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* * *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.min(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.max(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.mod(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.div(*)"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

