/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AlwaysEmptyChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.HashCodeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.SourceTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TargetTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectingStep
extends AbstractNavigationStep
implements HashCodeChangeListener {
    private NavigationStep actualStep;
    private int hashCode;
    private final boolean currentlyEvaluatingHashCode = false;
    private int maxTokenSeen = -1;
    private final List<Object> currentlyEvaluatingEqualsForParameters = new ArrayList<Object>();
    private final SemanticIdentity semanticIdentity;
    private final ThreadLocal<Set<EObject>> currentlyEvaluatingNavigateFor = new IndirectingStepThreadLocal();

    public IndirectingStep(OCLExpression debugInfo) {
        super(null, null, debugInfo);
        this.semanticIdentity = new IndirectingStepSemanticIdentity();
    }

    private SemanticIdentity getSemanticIdentityOfSuper() {
        return super.getSemanticIdentity();
    }

    public void setActualStep(NavigationStep actualStep) {
        if (this.actualStep != null) {
            throw new RuntimeException("Internal error: can't set an IndirectingStep's actual step twice");
        }
        this.fireBeforeHashCodeChange(IndirectingStep.newTokenForFiringHashCodeChangeEvent());
        this.actualStep = actualStep;
        this.hashCode = actualStep.getSemanticIdentity().hashCode();
        this.fireAfterHashCodeChange(IndirectingStep.newTokenForFiringHashCodeChangeEvent());
        actualStep.addHashCodeChangeListener(this);
        if (actualStep.getSourceType() == null) {
            actualStep.addSourceTypeChangeListener(new SourceTypeChangeListener(){

                public void sourceTypeChanged(NavigationStep stepForWhichSourceTypeChanged) {
                    IndirectingStep.this.setSourceType(stepForWhichSourceTypeChanged.getSourceType());
                }
            });
        } else {
            this.setSourceType(actualStep.getSourceType());
        }
        if (actualStep.getTargetType() == null) {
            actualStep.addTargetTypeChangeListener(new TargetTypeChangeListener(){

                public void targetTypeChanged(NavigationStep stepForWhichTargetTypeChanged) {
                    IndirectingStep.this.setTargetType(stepForWhichTargetTypeChanged.getTargetType());
                }
            });
        } else {
            this.setTargetType(actualStep.getTargetType());
        }
        if (this.actualStep.isAlwaysEmpty()) {
            this.setAlwaysEmpty();
        } else {
            this.actualStep.addAlwaysEmptyChangeListener(new AlwaysEmptyChangeListener(){

                public void alwaysEmptyChanged(NavigationStep stepForWhichAlwaysEmptyChanged) {
                    if (!$assertionsDisabled && stepForWhichAlwaysEmptyChanged != IndirectingStep.this.actualStep) {
                        throw new AssertionError();
                    }
                    IndirectingStep.this.setAlwaysEmpty();
                }
            });
        }
    }

    public NavigationStep getActualStep() {
        return this.actualStep;
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        Set<AnnotatedEObject> result;
        if (this.currentlyEvaluatingNavigateFor.get().contains(fromObject) || this.isAlwaysEmpty()) {
            result = Collections.emptySet();
        } else {
            try {
                this.currentlyEvaluatingNavigateFor.get().add(fromObject);
                Set<AnnotatedEObject> set = Collections.singleton(fromObject);
                result = this.actualStep.navigate(set, cache, changeEvent);
            }
            finally {
                boolean removedSuccessfully = this.currentlyEvaluatingNavigateFor.get().remove(fromObject);
                assert (removedSuccessfully);
            }
        }
        return result;
    }

    @Override
    protected void incrementNavigateCounter(Set<AnnotatedEObject> from) {
        boolean oneFromObjectIsEvaluating = false;
        for (EObject eObject : from) {
            if (!this.currentlyEvaluatingNavigateFor.get().contains(eObject)) continue;
            oneFromObjectIsEvaluating = true;
            return;
        }
        if (!oneFromObjectIsEvaluating) {
            super.incrementNavigateCounter(from);
        }
    }

    @Override
    public boolean isAbsolute() {
        boolean result = this.actualStep == null ? false : this.actualStep.isAbsolute();
        return result;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return "(i)" + (this.actualStep != null ? (this.actualStep instanceof AbstractNavigationStep ? ((AbstractNavigationStep)this.actualStep).contentToString(visited, indent) : this.actualStep.toString()) : "null");
    }

    @Override
    protected int size(Set<NavigationStep> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        if ((AbstractNavigationStep)this.actualStep != null) {
            return 1 + ((AbstractNavigationStep)this.actualStep).size(visited);
        }
        return 0;
    }

    @Override
    public synchronized void beforeHashCodeChange(NavigationStep step, int token) {
        if (token > this.maxTokenSeen) {
            this.maxTokenSeen = token;
            this.fireBeforeHashCodeChange(token);
        }
    }

    @Override
    public synchronized void afterHashCodeChange(NavigationStep step, int token) {
        if (token > this.maxTokenSeen) {
            this.maxTokenSeen = token;
            this.hashCode = step.getSemanticIdentity().hashCode();
            this.fireAfterHashCodeChange(token);
        }
    }

    @Override
    protected int distinctSize(Set<SemanticIdentity> visited) {
        if (visited.contains(this.getSemanticIdentity())) {
            return 0;
        }
        visited.add(this.getSemanticIdentity());
        return 1 + ((AbstractNavigationStep)this.actualStep).distinctSize(visited);
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    public InstanceScopeAnalysis getInstanceScopeAnalysis() {
        return null;
    }

    public class IndirectingStepSemanticIdentity
    extends SemanticIdentity {
        public synchronized boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            int i = IndirectingStep.this.currentlyEvaluatingEqualsForParameters.size() - 1;
            while (i >= 0) {
                if (IndirectingStep.this.currentlyEvaluatingEqualsForParameters.get(i) == o) {
                    return true;
                }
                --i;
            }
            IndirectingStep.this.currentlyEvaluatingEqualsForParameters.add(o);
            boolean result = IndirectingStep.this.actualStep == null ? false : (o instanceof IndirectingStep ? IndirectingStep.this.actualStep.equals(((IndirectingStep)o).getActualStep()) : false);
            IndirectingStep.this.currentlyEvaluatingEqualsForParameters.remove(IndirectingStep.this.currentlyEvaluatingEqualsForParameters.size() - 1);
            return result;
        }

        protected synchronized int calculateHashCode() {
            int result = IndirectingStep.this.actualStep == null ? this.getStep().hashCode() : IndirectingStep.this.hashCode;
            return result;
        }

        public NavigationStep getStep() {
            return IndirectingStep.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndirectingStepThreadLocal
    extends ThreadLocal<Set<EObject>> {
        private IndirectingStepThreadLocal() {
        }

        @Override
        protected Set<EObject> initialValue() {
            return new HashSet<EObject>();
        }
    }
}

