/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentRegistryImpl
implements Environment.Registry {
    private final EList<Object> environments = new BasicEList();
    private static final String PT_ENVIRONMENTS = "environments";
    private static final String E_ENVIRONMENT_FACTORY = "environmentFactory";
    private static final String A_CLASS = "class";
    private static final String E_PACKAGE = "package";
    private static final String A_NS_URI = "nsURI";

    @Override
    public <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEnvironmentFor(OCLExpression<C> expression) {
        return this.getEnvironmentFor(expression.getType());
    }

    @Override
    public <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEnvironmentFor(Object abstractSyntaxElement) {
        if (abstractSyntaxElement instanceof TypedElement) {
            return this.getEnvironmentFor(((TypedElement)abstractSyntaxElement).getType());
        }
        int i = 0;
        while (i < this.environments.size()) {
            Environment env;
            UMLReflection uml;
            EnvironmentDescriptor descriptor;
            Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> next = this.environments.get(i);
            if (next instanceof EnvironmentDescriptor && (descriptor = (EnvironmentDescriptor)((Object)next)).matches(abstractSyntaxElement)) {
                next = descriptor.instantiate();
                this.environments.set(i, next);
            }
            if (next instanceof Environment && ((uml = (env = (Environment)next).getUMLReflection()).isClassifier(abstractSyntaxElement) || uml.isOperation(abstractSyntaxElement) || uml.isProperty(abstractSyntaxElement))) {
                return next;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void registerEnvironment(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment) {
        if (!this.environments.contains(environment)) {
            this.environments.add(environment);
        }
    }

    @Override
    public void deregisterEnvironment(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment) {
        this.environments.remove(environment);
    }

    private String getExtensionID(IConfigurationElement element) {
        return this.getExtensionID(element.getDeclaringExtension());
    }

    private String getExtensionID(IExtension extension) {
        String result = extension.getUniqueIdentifier();
        if (result == null) {
            result = extension.getNamespaceIdentifier();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EnvironmentDescriptor {
        private final Set<String> packageURIs = new HashSet<String>();
        private Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env;

        EnvironmentDescriptor() {
        }

        void addPackageURI(String packageURI) {
            this.packageURIs.add(packageURI);
        }

        boolean matches(Object object) {
            boolean result = object instanceof EObject;
            if (result) {
                EPackage epackage = ((EObject)object).eClass().getEPackage();
                result = epackage != null && this.packageURIs.contains(epackage.getNsURI());
            }
            return result;
        }

        Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> instantiate() {
            if (this.env == null) {
                EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> factory = this.createFactory();
                this.env = factory.createEnvironment();
            }
            return this.env;
        }

        void dispose() {
            if (this.env != null) {
                EnvironmentRegistryImpl.this.environments.remove(this.env);
            }
            EnvironmentRegistryImpl.this.environments.remove((Object)this);
        }

        abstract EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createFactory();
    }

    class RegistryReader
    implements IRegistryChangeListener {
        private final String namespace;
        private IExtensionRegistry extensionRegistry;
        private final Map<String, EnvironmentDescriptor> descriptors = new HashMap<String, EnvironmentDescriptor>();

        RegistryReader(OCLPlugin plugin) {
            this.namespace = "org.eclipse.ocl";
        }

        void readRegistry() {
            if (this.extensionRegistry == null) {
                this.extensionRegistry = Platform.getExtensionRegistry();
                this.readRegistryImpl();
            }
        }

        private void readRegistryImpl() {
            IExtension[] extensions;
            this.extensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this, this.namespace);
            IExtension[] iExtensionArray = extensions = this.extensionRegistry.getExtensionPoint(this.namespace, EnvironmentRegistryImpl.PT_ENVIRONMENTS).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.read(extension);
                ++n2;
            }
        }

        private void read(IExtension extension) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (EnvironmentRegistryImpl.E_ENVIRONMENT_FACTORY.equals(element.getName())) {
                    this.readEnvironmentFactory(element);
                } else {
                    OCLPlugin.log(4, 1, OCLMessages.bind(OCLMessages.EnvRegistry_unknownElement_ERROR_, EnvironmentRegistryImpl.this.getExtensionID(extension), element.getName()), null);
                }
                ++n2;
            }
        }

        private void readEnvironmentFactory(final IConfigurationElement element) {
            String className = element.getAttribute(EnvironmentRegistryImpl.A_CLASS);
            if (className != null) {
                EnvironmentDescriptor descriptor = new EnvironmentDescriptor(EnvironmentRegistryImpl.this){

                    @Override
                    EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createFactory() {
                        try {
                            return (EnvironmentFactory)element.createExecutableExtension(EnvironmentRegistryImpl.A_CLASS);
                        }
                        catch (CoreException e) {
                            OCLPlugin.getInstance().log((Object)e);
                            return null;
                        }
                    }
                };
                this.descriptors.put(className, descriptor);
                EnvironmentRegistryImpl.this.environments.add((Object)descriptor);
                IConfigurationElement[] iConfigurationElementArray = element.getChildren(EnvironmentRegistryImpl.E_PACKAGE);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement pkg = iConfigurationElementArray[n2];
                    this.readPackage(descriptor, pkg);
                    ++n2;
                }
            } else {
                OCLPlugin.log(4, 1, OCLMessages.bind(OCLMessages.EnvRegistry_missingClass_ERROR_, EnvironmentRegistryImpl.this.getExtensionID(element)), null);
            }
        }

        private void readPackage(EnvironmentDescriptor descriptor, IConfigurationElement element) {
            String nsURI = element.getAttribute(EnvironmentRegistryImpl.A_NS_URI);
            if (nsURI != null) {
                descriptor.addPackageURI(nsURI);
            } else {
                OCLPlugin.log(4, 1, OCLMessages.bind(OCLMessages.EnvRegistry_missingNsURI_ERROR_, EnvironmentRegistryImpl.this.getExtensionID(element)), null);
            }
        }

        private void remove(IExtension extension) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (EnvironmentRegistryImpl.E_ENVIRONMENT_FACTORY.equals(element.getName())) {
                    this.removeEnvironmentFactory(element);
                }
                ++n2;
            }
        }

        private void removeEnvironmentFactory(IConfigurationElement element) {
            EnvironmentDescriptor descriptor;
            String className = element.getAttribute(EnvironmentRegistryImpl.A_CLASS);
            if (className != null && (descriptor = this.descriptors.get(className)) != null) {
                descriptor.dispose();
            }
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(this.namespace, EnvironmentRegistryImpl.PT_ENVIRONMENTS);
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                switch (delta.getKind()) {
                    case 1: {
                        this.read(delta.getExtension());
                        break;
                    }
                    case 2: {
                        this.remove(delta.getExtension());
                    }
                }
                ++n2;
            }
        }
    }
}

