/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;

public class URIUtil {
    public static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI((String)"/", (boolean)false);

    public static @NonNull URI deresolve(@NonNull URI fullURI, URI baseURI) {
        return URIUtil.deresolve(fullURI, baseURI, true, false, true);
    }

    public static @NonNull URI deresolve(@NonNull URI fullURI, @Nullable URI baseURI, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
        if (baseURI == null) {
            return fullURI;
        }
        if (fullURI.isPlatform() && baseURI.isPlatform()) {
            String[] segments1 = fullURI.segments();
            String[] segments2 = baseURI.segments();
            if (segments1.length < 2 || segments2.length < 2) {
                return fullURI;
            }
            if (!segments1[0].equals(segments2[0]) || !segments1[1].equals(segments2[1])) {
                return fullURI;
            }
        }
        return fullURI.deresolve(baseURI, preserveRootParents, anyRelPath, shorterRelPath);
    }

    public static @NonNull URI getAbsoluteOrPlatformURI(@NonNull URI uri) {
        boolean isHierarchical = uri.isHierarchical();
        boolean isPlatform = uri.isPlatform();
        boolean isRelative = uri.isRelative();
        if (uri.isRelative()) {
            return URI.createPlatformResourceURI((String)uri.toString(), (boolean)true);
        }
        return uri;
    }

    public static @NonNull URI getNonASURI(@NonNull URI uri) {
        if (PivotUtilInternal.isASURI(uri)) {
            uri = PivotUtilInternal.getNonASURI(uri);
        }
        return uri;
    }

    public static @Nullable IFile getResolvedFile(@NonNull URI uri) {
        if (uri.isHierarchical() && (uri.isRelative() || (uri = uri.deresolve(PLATFORM_RESOURCE)).isRelative())) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile((IPath)new Path(uri.toString()));
            return file;
        }
        return null;
    }
}

