/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.properties.widgets.StereotypeExplorerDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeQualifyNameValueEditor
extends StringEditor {
    private static final String BROWSE_ICON = "/icons/browse_12x12.gif";
    private Button button = null;
    private Element sourceUMLElement;

    public StereotypeQualifyNameValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, null, 8);
        this.button.setImage(Activator.getDefault().getImage(BROWSE_ICON));
        this.button.setToolTipText(Messages.StereotypeQualifyNameValueEditor_browseStereotypeButtonLabel);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StereotypeQualifyNameValueEditor.this.handleManageBrowseButtonPressed();
            }
        });
    }

    protected void handleManageBrowseButtonPressed() {
        StereotypeExplorerDialog dialog = new StereotypeExplorerDialog(this.getParent().getShell(), this.getText().getText());
        dialog.setElementToApplyStereotype(this.sourceUMLElement);
        if (dialog.open() == 0) {
            Object[] values = dialog.getResult();
            if (1 != values.length) {
                String message = Messages.StereotypeQualifyNameValueEditor_ReturnErrorMessage + values.length;
                Activator.getDefault();
                Activator.log.error(message, null);
                Status status = new Status(4, "org.eclipse.papyrus.infra.widgets", message);
                this.updateStatus((IStatus)status);
            } else if (values[0] instanceof Stereotype) {
                Stereotype stereotype = (Stereotype)values[0];
                this.setValue(stereotype.getQualifiedName());
                this.notifyChange();
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.button.setEnabled(!readOnly);
    }

    public void setElementToApplyStereotype(Element sourceUMLElement) {
        this.sourceUMLElement = sourceUMLElement;
    }
}

