/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.IGraphicalRepresentationElementCreationChecker;
import org.eclipse.papyrus.sirius.junit.utils.rules.SiriusDiagramEditorFixture;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractSemanticTopNodeDropTests
extends AbstractSiriusDiagramTests {
    @Rule
    public final SiriusDiagramEditorFixture fixture = new SiriusDiagramEditorFixture();
    protected Package root;
    protected Diagram diagram;
    protected DDiagram diagramRepresentation;

    @Before
    public void setUp() {
        this.root = this.fixture.getModel();
        Assert.assertNotNull((Object)this.root);
        DiagramEditPart diagramEditpart = this.fixture.getActiveDiagram();
        this.diagram = diagramEditpart.getDiagramView();
        this.diagramRepresentation = (DDiagram)this.diagram.getElement();
    }

    protected void dropNode(String dropToolId, IGraphicalRepresentationElementCreationChecker checker, Element elementToBeDropped, DragAndDropTarget dropTarget) {
        Assert.assertNotNull((Object)dropTarget);
        boolean result = this.fixture.applyContainerDropDescriptionTool(this.diagramRepresentation, dropToolId, dropTarget, (EObject)elementToBeDropped);
        Assert.assertTrue((String)"The drop of element failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        EObject createdElementRepresentation = null;
        if (dropTarget instanceof DNodeContainer) {
            createdElementRepresentation = (EObject)((DNodeContainer)dropTarget).getOwnedDiagramElements().get(0);
        }
        if (dropTarget instanceof DSemanticDiagram) {
            createdElementRepresentation = (EObject)((DSemanticDiagram)dropTarget).getOwnedDiagramElements().get(0);
        }
        Assert.assertTrue((boolean)(createdElementRepresentation instanceof DRepresentationElement));
        checker.validateRepresentationElement((DRepresentationElement)createdElementRepresentation);
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        checker.validateAfterUndo();
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        checker.validateAfterRedo();
    }

    @Override
    protected void checkSiriusDiagramSynchronization(boolean isSynchronized) {
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((String)"We don't found a Sirius active diagram", (Object)siriusDiagram);
        Assert.assertEquals((String)"The synchronization status of the diagram is not the expected one", (Object)isSynchronized, (Object)siriusDiagram.isSynchronized());
    }

    @After
    public void tearDown() {
        this.root = null;
    }
}

