/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.LocalProfileIndex;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeApplicationMatcherCustomValidator
extends CustomModelChecker.SwitchValidator {
    public StereotypeApplicationMatcherCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(StereotypeApplicationMatcherConfiguration stereotypeMatcher, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String profileURI = stereotypeMatcher.getProfileUri();
        if (profileURI != null && !profileURI.isBlank()) {
            this.validateRequiredProfile(stereotypeMatcher, stereotypeMatcher.getProfileUri(), diagnostics, context);
        }
        for (String stereotype : stereotypeMatcher.getStereotypesQualifiedNames()) {
            this.validateStereotypeName(stereotypeMatcher, stereotype, diagnostics, context);
        }
    }

    private void validateRequiredProfile(StereotypeApplicationMatcherConfiguration stereotypeMatcher, String profileURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        LocalProfileIndex index = LocalProfileIndex.getInstance((EObject)stereotypeMatcher, context);
        Profile profile = index.getProfileByURI(profileURI, (EObject)stereotypeMatcher);
        if (profile == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeMatcher, this.format(Messages.StereotypeApplicationMatcherCustomValidator_0, context, new Object[]{stereotypeMatcher, profileURI})));
        }
    }

    private void validateStereotypeName(StereotypeApplicationMatcherConfiguration stereotypeMatcher, String qualifiedName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Stereotype stereotype = this.getStereotype(stereotypeMatcher, qualifiedName, context);
        if (stereotype == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeMatcher, this.format(Messages.StereotypeApplicationMatcherCustomValidator_1, context, new Object[]{stereotypeMatcher})));
        }
    }

    private Stereotype getStereotype(StereotypeApplicationMatcherConfiguration stereotypeMatcher, String qualifiedName, Map<Object, Object> context) {
        Stereotype result = null;
        LocalProfileIndex index = LocalProfileIndex.getInstance((EObject)stereotypeMatcher, context);
        String profileURI = stereotypeMatcher.getProfileUri();
        if (profileURI != null && !profileURI.isBlank()) {
            Profile profile = index.getProfileByURI(profileURI, (EObject)stereotypeMatcher);
            if (profile != null) {
                result = index.getStereotype(qualifiedName, profile, (EObject)stereotypeMatcher);
            }
        } else {
            result = index.getStereotype(qualifiedName, (EObject)stereotypeMatcher);
        }
        return result;
    }
}

