/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.utils;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BundleVersionHelper {
    private final String bundleName;

    public BundleVersionHelper(String bundleName) {
        this.bundleName = bundleName;
    }

    public final VersionRange getVersionRange() {
        Version moreUpperVersion = this.getMoreUpperBundleVersion();
        Version minVersion = new Version(moreUpperVersion.getMajor(), moreUpperVersion.getMinor(), 0);
        Version maxVersion = new Version(moreUpperVersion.getMajor() + 1, 0, 0);
        return new VersionRange('[', minVersion, maxVersion, ')');
    }

    public final String getVersionRangeForManifest() {
        VersionRange ranges = this.getVersionRange();
        return ranges.toString();
    }

    public final String getVersionRangeForManifest(Version minimumVersion, Version maximumVersion) {
        return new VersionRange('[', minimumVersion, maximumVersion, ')').toString();
    }

    protected Version getMoreUpperBundleVersion() {
        Version workspaceVersion = this.getWorkspaceBundleVersion();
        Version installedVersion = this.getInstalledBundleVersion();
        Version versionToUse = new Version(0, 0, 0);
        if (workspaceVersion != null && installedVersion != null) {
            if (installedVersion.compareTo(workspaceVersion) >= 0) {
                versionToUse = workspaceVersion;
            }
        } else if (workspaceVersion == null && installedVersion != null) {
            versionToUse = installedVersion;
        } else if (workspaceVersion != null && installedVersion == null) {
            versionToUse = workspaceVersion;
        }
        return versionToUse;
    }

    public final Version getWorkspaceBundleVersion() {
        Version version = null;
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.bundleName);
        if (currentProject != null && currentProject.exists() && currentProject.isOpen()) {
            try {
                ManifestEditor editor = new ManifestEditor(currentProject);
                editor.init();
                String currentVersion = editor.getBundleVersion();
                version = new Version(currentVersion);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return version;
    }

    public final Version getInstalledBundleVersion() {
        Bundle bundle = Platform.getBundle((String)this.bundleName);
        if (bundle != null) {
            return bundle.getVersion();
        }
        return null;
    }
}

