/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.interfaces;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IFeatureProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IJavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.FeatureProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.JavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.xml.sax.SAXException;

public class ProjectEditors {
    private ProjectEditors() {
    }

    public static IPluginEditor getPluginEditor(IProject project) throws CoreException {
        try {
            return new PluginEditor(project);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.eclipse.project.editors", "Failed to create plugin.xml editor", (Throwable)e));
        }
    }

    public static IProjectEditor getProjectEditor(IProject project) throws CoreException {
        return new ProjectEditor(project);
    }

    public static IJavaProjectEditor getJavaProjectEditor(IProject project) throws CoreException {
        return new JavaProjectEditor(project);
    }

    public static IPluginProjectEditor getPluginProjectEditor(IProject project) throws CoreException {
        try {
            return new PluginProjectEditor(project);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.eclipse.project.editors", "Failed to create plugin.xml editor", (Throwable)e));
        }
    }

    public static IManifestEditor getManifestEditor(IProject project) throws CoreException {
        try {
            return new ManifestEditor(project);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.eclipse.project.editors", "Failed to create manifest editor", (Throwable)e));
        }
    }

    public static IFeatureProjectEditor getFeatureProjectEditor(IProject project) throws CoreException {
        try {
            return new FeatureProjectEditor(project);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.eclipse.project.editors", "Failed to create feature editor", (Throwable)e));
        }
    }
}

